/*
 * Decompiled with CFR 0.152.
 */
package com.wintercogs.beyonddimensions.Menu;

import com.wintercogs.beyonddimensions.BeyondDimensions;
import com.wintercogs.beyonddimensions.DataBase.DimensionsNet;
import com.wintercogs.beyonddimensions.DataBase.Handler.IStackTypedHandler;
import com.wintercogs.beyonddimensions.DataBase.Stack.IStackType;
import com.wintercogs.beyonddimensions.DataBase.Stack.ItemStackType;
import com.wintercogs.beyonddimensions.Integration.Polymorph.PolymorphHelper;
import com.wintercogs.beyonddimensions.Menu.DimensionsNetMenu;
import com.wintercogs.beyonddimensions.Menu.Slot.AutoRefillResultSlot;
import com.wintercogs.beyonddimensions.Menu.Slot.StoredStackSlot;
import com.wintercogs.beyonddimensions.Unit.InventoryHelper;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundContainerSetSlotPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.ResultContainer;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.TransientCraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.extensions.IMenuTypeExtension;
import net.neoforged.neoforge.registries.DeferredRegister;

public class DimensionsCraftMenu
extends DimensionsNetMenu {
    protected CraftingContainer craftSlots;
    protected ResultContainer resultSlots;
    public int resultSlotIndex;
    public int craftSlotStartIndex;
    public int craftSlotEndIndex;
    public boolean firstCraftReturnDir = false;
    public static final DeferredRegister<MenuType<?>> MENU_TYPES = DeferredRegister.create((ResourceKey)Registries.MENU, (String)"beyonddimensions");
    public static final Supplier<MenuType<DimensionsCraftMenu>> Dimensions_Craft_Menu = MENU_TYPES.register("dimensions_craft_menu", () -> IMenuTypeExtension.create(DimensionsCraftMenu::new));

    public DimensionsCraftMenu(int id, Inventory playerInventory, FriendlyByteBuf data) {
        this(Dimensions_Craft_Menu.get(), id, playerInventory, new DimensionsNet(true), null, null);
    }

    public DimensionsCraftMenu(MenuType<?> type, int id, Inventory playerInventory, DimensionsNet data, @Nullable NonNullList<ItemStack> craftItems, final @Nullable BlockPos entityPos) {
        super(type, id, playerInventory, data);
        TransientCraftingContainer craftContainer = craftItems != null ? new TransientCraftingContainer(this, 3, 3, craftItems){

            public void setChanged() {
                super.setChanged();
                if (entityPos != null && !DimensionsCraftMenu.this.player.level().isClientSide()) {
                    DimensionsCraftMenu.this.player.level().blockEntityChanged(entityPos);
                }
            }
        } : new TransientCraftingContainer(this, 3, 3){

            public void setChanged() {
                super.setChanged();
                if (entityPos != null && !DimensionsCraftMenu.this.player.level().isClientSide()) {
                    DimensionsCraftMenu.this.player.level().blockEntityChanged(entityPos);
                }
            }
        };
        this.initCraftSlots(playerInventory, craftContainer);
    }

    protected void initCraftSlots(Inventory playerInventory, @Nullable TransientCraftingContainer craftSlots) {
        this.craftSlots = (CraftingContainer)Objects.requireNonNullElseGet(craftSlots, () -> new TransientCraftingContainer((AbstractContainerMenu)this, 3, 3));
        this.resultSlots = new ResultContainer();
        this.addSlot((Slot)new AutoRefillResultSlot(this, playerInventory.player, this.craftSlots, (Container)this.resultSlots, 0, 120, 24 + (this.getLines() - 1) * 18 + 26 + 21));
        this.resultSlotIndex = this.slots.size() - 1;
        this.craftSlotStartIndex = this.slots.size();
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                this.addSlot(new Slot((Container)this.craftSlots, j + i * 3, 26 + j * 18, 24 + (this.getLines() - 1) * 18 + 26 + 3 + i * 18));
            }
        }
        this.craftSlotEndIndex = this.slots.size();
    }

    public static void slotChangedCraftingGrid(AbstractContainerMenu menu, Level level, Player player, CraftingContainer craftSlots, ResultContainer resultSlots, int resultSlotIndex) {
        if (!level.isClientSide) {
            CraftingInput craftinginput = craftSlots.asCraftInput();
            ServerPlayer serverplayer = (ServerPlayer)player;
            ItemStack itemstack = ItemStack.EMPTY;
            Optional<RecipeHolder<CraftingRecipe>> optional = DimensionsCraftMenu.getRecipe(player, craftinginput, level);
            if (optional.isPresent()) {
                ItemStack itemstack1;
                RecipeHolder<CraftingRecipe> recipeholder = optional.get();
                CraftingRecipe craftingrecipe = (CraftingRecipe)recipeholder.value();
                if (resultSlots.setRecipeUsed(level, serverplayer, recipeholder) && (itemstack1 = craftingrecipe.assemble((RecipeInput)craftinginput, (HolderLookup.Provider)level.registryAccess())).isItemEnabled(level.enabledFeatures())) {
                    itemstack = itemstack1;
                }
            }
            resultSlots.setItem(0, itemstack);
            menu.setRemoteSlot(resultSlotIndex, itemstack);
            serverplayer.connection.send((Packet)new ClientboundContainerSetSlotPacket(menu.containerId, menu.incrementStateId(), resultSlotIndex, itemstack));
        }
    }

    public static Optional<RecipeHolder<CraftingRecipe>> getRecipe(Player player, CraftingInput input, Level level) {
        if (BeyondDimensions.PolymorphLoaded && player != null) {
            return PolymorphHelper.getRecipe(player, (RecipeType<CraftingRecipe>)RecipeType.CRAFTING, input, level);
        }
        return level.getRecipeManager().getRecipeFor(RecipeType.CRAFTING, (RecipeInput)input, level);
    }

    public void transferRecipe(List<ItemStack> inputs) {
        if (this.player instanceof ServerPlayer) {
            List stacks = this.craftSlots.getItems();
            for (ItemStack stack : stacks) {
                if (stack.isEmpty()) continue;
                if (this.player.isAlive() && !((ServerPlayer)this.player).hasDisconnected()) {
                    this.player.getInventory().placeItemBackInInventory(stack);
                    continue;
                }
                long remaining = this.storage.insert(new ItemStackType(stack), false).getStackAmount();
                if (remaining <= 0L) continue;
                stack.setCount((int)remaining);
                this.player.drop(stack, false);
            }
            this.craftSlots.clearContent();
            this.resultSlots.clearContent();
        }
        for (int slotIndex = 0; slotIndex < inputs.size() && slotIndex < this.craftSlots.getContainerSize(); ++slotIndex) {
            ItemStack required = inputs.get(slotIndex);
            if (required.isEmpty()) continue;
            int remaining = required.getCount();
            ItemStack collected = required.copy();
            remaining = this.extractFromInventory(this.player.getInventory(), collected, remaining);
            if (remaining > 0) {
                remaining = this.extractFromStorage(this.storage, new ItemStackType(collected), remaining);
            }
            if (remaining >= required.getCount()) continue;
            collected.setCount(required.getCount() - remaining);
            this.craftSlots.setItem(slotIndex, collected);
        }
    }

    private int extractFromInventory(Inventory inventory, ItemStack template, int amount) {
        int remaining = amount;
        for (int i = 0; i < 36 && remaining > 0; ++i) {
            ItemStack stack = inventory.getItem(i);
            if (!ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)template)) continue;
            int extract = Math.min(remaining, stack.getCount());
            stack.shrink(extract);
            remaining -= extract;
            inventory.setItem(i, stack.isEmpty() ? ItemStack.EMPTY : stack);
        }
        return remaining;
    }

    private int extractFromStorage(IStackTypedHandler storage, IStackType type, int amount) {
        IStackType extraction = storage.extract(type.copyWithCount(amount), false);
        if (extraction.getStackAmount() > 0L) {
            return amount - (int)extraction.getStackAmount();
        }
        return amount;
    }

    public void slotsChanged(Container container) {
        super.slotsChanged(container);
        DimensionsCraftMenu.slotChangedCraftingGrid(this, this.player.level(), this.player, this.craftSlots, this.resultSlots, this.resultSlotIndex);
    }

    @Override
    protected void addStorageSlots() {
        for (int row = 0; row < 99; ++row) {
            for (int col = 0; col < 9; ++col) {
                StoredStackSlot newSlot = new StoredStackSlot(this.viewerStorage, -1, 8 + col * 18, 25 + row * 18);
                if (row >= this.getLines()) {
                    newSlot.setActive(false);
                }
                this.addSlot(newSlot);
            }
        }
    }

    @Override
    protected void addPlayerInv(Inventory playerInventory) {
        this.inventoryStartIndex = this.slots.size();
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 9; ++col) {
                this.addSlot(new Slot((Container)playerInventory, col + row * 9 + 9, 8 + col * 18, 87 + (this.getLines() - 1) * 18 + 26 + 6 + row * 18));
            }
        }
        for (int col = 0; col < 9; ++col) {
            this.addSlot(new Slot((Container)playerInventory, col, 8 + col * 18, 87 + (this.getLines() - 1) * 18 + 26 + 6 + 54 + 4));
        }
        this.inventoryEndIndex = this.slots.size();
    }

    @Override
    public void rebuildSlots() {
        int sSlotNum = 0;
        for (Slot slot : this.slots) {
            if (!(slot instanceof StoredStackSlot)) continue;
            StoredStackSlot sSlot = (StoredStackSlot)slot;
            if (sSlotNum / 9 < this.getLines()) {
                sSlot.setActive(true);
            } else {
                sSlot.setActive(false);
            }
            ++sSlotNum;
        }
        int slotNum = 0;
        for (int i = this.inventoryStartIndex; i < this.inventoryEndIndex; ++i) {
            Slot slot = (Slot)this.slots.get(i);
            if (slot == null) continue;
            slot.y = slotNum / 9 < 3 ? 87 + (this.getLines() - 1) * 18 + 26 + 6 + slotNum / 9 * 18 : 87 + (this.getLines() - 1) * 18 + 26 + 6 + 54 + 4;
            ++slotNum;
        }
        Slot resultSlot = (Slot)this.slots.get(this.resultSlotIndex);
        resultSlot.y = 24 + (this.getLines() - 1) * 18 + 26 + 21;
        slotNum = 0;
        for (int i = this.craftSlotStartIndex; i < this.craftSlotEndIndex; ++i) {
            Slot slot = (Slot)this.slots.get(i);
            if (slot == null) continue;
            slot.y = 24 + (this.getLines() - 1) * 18 + 26 + 3 + slotNum / 3 * 18;
            ++slotNum;
        }
    }

    public void cleanCraftSlots(boolean toStorageFirst) {
        if (this.player instanceof ServerPlayer) {
            List stacks = this.craftSlots.getItems();
            for (ItemStack stack : stacks) {
                long remaining;
                if (stack.isEmpty()) continue;
                if (toStorageFirst) {
                    remaining = this.storage.insert(new ItemStackType(stack.copy()), false).getStackAmount();
                    if (remaining <= 0L) continue;
                    stack.setCount((int)remaining);
                    remaining = InventoryHelper.transferToPlayerInventory(this.player, stack.copy()).getCount();
                    if (remaining <= 0L) continue;
                    stack.setCount((int)remaining);
                    this.player.drop(stack, false);
                    continue;
                }
                if (this.player.isAlive() && !((ServerPlayer)this.player).hasDisconnected()) {
                    remaining = InventoryHelper.transferToPlayerInventory(this.player, stack.copy()).getCount();
                    if (remaining <= 0L) continue;
                    stack.setCount((int)remaining);
                    remaining = this.storage.insert(new ItemStackType(stack.copy()), false).getStackAmount();
                    if (remaining <= 0L) continue;
                    stack.setCount((int)remaining);
                    this.player.drop(stack, false);
                    continue;
                }
                this.player.drop(stack, false);
            }
            this.craftSlots.clearContent();
            this.resultSlots.clearContent();
        }
    }

    public void removed(Player player) {
        super.removed(player);
        this.cleanCraftSlots(this.firstCraftReturnDir);
    }
}

