/*
 * Decompiled with CFR 0.152.
 */
package com.wintercogs.beyonddimensions.DataBase.Handler.Chemicals;

import com.wintercogs.beyonddimensions.DataBase.Handler.StackTypedHandler;
import com.wintercogs.beyonddimensions.DataBase.Stack.Chemicals.SlurryStackType;
import com.wintercogs.beyonddimensions.DataBase.Stack.IStackType;
import java.util.List;
import mekanism.api.Action;
import mekanism.api.chemical.slurry.ISlurryHandler;
import mekanism.api.chemical.slurry.SlurryStack;

public class SlurryStackTypedHandler
implements ISlurryHandler {
    private StackTypedHandler handlerStorage;

    public SlurryStackTypedHandler(StackTypedHandler handlerStorage) {
        this.handlerStorage = handlerStorage;
    }

    public int getTanks() {
        return this.handlerStorage.getTypeIdIndexList(SlurryStackType.ID).map(List::size).orElse(0);
    }

    public SlurryStack getChemicalInTank(int tank) {
        return this.handlerStorage.getTypeIdIndexList(SlurryStackType.ID).filter(slots -> tank >= 0 && tank < slots.size()).map(slots -> (Integer)slots.get(tank)).filter(actualIndex -> actualIndex >= 0).map(this.handlerStorage::getStackBySlot).map(obj -> (SlurryStack)obj.getStack()).orElse(SlurryStack.EMPTY);
    }

    public void setChemicalInTank(int tank, SlurryStack stack) {
        this.handlerStorage.getTypeIdIndexList(SlurryStackType.ID).filter(slots -> tank >= 0 && tank < slots.size()).map(slots -> (Integer)slots.get(tank)).filter(actualIndex -> actualIndex >= 0).ifPresent(actualIndex -> this.handlerStorage.setStackDirectly((int)actualIndex, new SlurryStackType(stack.copy())));
    }

    public long getTankCapacity(int tank) {
        return 64000L;
    }

    public boolean isValid(int tank, SlurryStack stack) {
        return true;
    }

    public SlurryStack insertChemical(int tank, SlurryStack stack, Action action) {
        if (stack.isEmpty()) {
            return SlurryStack.EMPTY;
        }
        return this.handlerStorage.getTypeIdIndexList(SlurryStackType.ID).filter(slots -> tank >= 0 && tank < slots.size()).map(slots -> (Integer)slots.get(tank)).filter(actualIndex -> actualIndex >= 0).map(actualIndex -> {
            IStackType remainingStack = this.handlerStorage.insert((int)actualIndex, new SlurryStackType(stack.copy()), action.simulate());
            long remaining = remainingStack.getStackAmount();
            return remaining > 0L ? new SlurryStack(stack, remaining) : SlurryStack.EMPTY;
        }).orElse(stack.copy());
    }

    public SlurryStack extractChemical(int tank, long amount, Action action) {
        return this.handlerStorage.getTypeIdIndexList(SlurryStackType.ID).filter(slots -> tank >= 0 && tank < slots.size()).map(slots -> (Integer)slots.get(tank)).filter(actualIndex -> actualIndex >= 0).map(actualIndex -> this.handlerStorage.extract((int)actualIndex, amount, action.simulate())).map(extracts -> ((SlurryStackType)extracts).copyStack()).orElse(SlurryStack.EMPTY);
    }

    public SlurryStack insertChemical(SlurryStack stack, Action action) {
        if (stack.isEmpty()) {
            return SlurryStack.EMPTY;
        }
        long remaining = this.handlerStorage.insert(new SlurryStackType(stack.copy()), action.simulate()).getStackAmount();
        if (remaining > 0L) {
            return new SlurryStack(stack, remaining);
        }
        return SlurryStack.EMPTY;
    }

    public SlurryStack extractChemical(long amount, Action action) {
        return this.handlerStorage.getTypeIdIndexList(SlurryStackType.ID).map(slots -> (Integer)slots.get(0)).filter(actualIndex -> actualIndex >= 0).map(this.handlerStorage::getStackBySlot).map(stack -> stack.copy()).map(stack -> this.handlerStorage.extract((IStackType)stack, action.simulate())).map(extracts -> ((SlurryStackType)extracts).copyStack()).orElse(SlurryStack.EMPTY);
    }

    public SlurryStack extractChemical(SlurryStack stack, Action action) {
        return ((SlurryStackType)this.handlerStorage.extract(new SlurryStackType(stack.copy()), action.simulate())).copyStack();
    }

    public SlurryStack getEmptyStack() {
        return SlurryStack.EMPTY;
    }
}

