/*
 * Decompiled with CFR 0.152.
 */
package com.wintercogs.beyonddimensions.DataBase.Handler;

import com.wintercogs.beyonddimensions.DataBase.Handler.StackTypedHandler;
import com.wintercogs.beyonddimensions.DataBase.Stack.FluidStackType;
import com.wintercogs.beyonddimensions.DataBase.Stack.IStackType;
import java.util.List;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class FluidStackTypedHandler
implements IFluidHandler {
    private StackTypedHandler handlerStorage;

    public FluidStackTypedHandler(StackTypedHandler handlerStorage) {
        this.handlerStorage = handlerStorage;
    }

    public int getTanks() {
        return this.handlerStorage.getTypeIdIndexList(FluidStackType.ID).map(List::size).orElse(0);
    }

    public FluidStack getFluidInTank(int tank) {
        return this.handlerStorage.getTypeIdIndexList(FluidStackType.ID).filter(slots -> tank >= 0 && tank < slots.size()).map(slots -> (Integer)slots.get(tank)).filter(actualIndex -> actualIndex >= 0).map(this.handlerStorage::getStackBySlot).map(obj -> (FluidStack)obj.getStack()).orElse(FluidStack.EMPTY);
    }

    public int getTankCapacity(int tank) {
        return 64000;
    }

    public boolean isFluidValid(int tank, FluidStack fluidStack) {
        return true;
    }

    public int fill(FluidStack fluidStack, IFluidHandler.FluidAction fluidAction) {
        if (fluidStack.isEmpty()) {
            return 0;
        }
        int allAmount = fluidStack.getAmount();
        int remaining = (int)this.handlerStorage.insert(new FluidStackType(fluidStack.copy()), fluidAction.simulate()).getStackAmount();
        return allAmount - remaining;
    }

    public FluidStack drain(FluidStack fluidStack, IFluidHandler.FluidAction fluidAction) {
        return ((FluidStackType)this.handlerStorage.extract(new FluidStackType(fluidStack.copy()), fluidAction.simulate())).copyStack();
    }

    public FluidStack drain(int count, IFluidHandler.FluidAction fluidAction) {
        return this.handlerStorage.getTypeIdIndexList(FluidStackType.ID).map(slots -> (Integer)slots.get(0)).filter(actualIndex -> actualIndex >= 0).map(this.handlerStorage::getStackBySlot).map(stack -> stack.copy()).map(stack -> this.handlerStorage.extract((IStackType)stack, fluidAction.simulate())).map(extracts -> ((FluidStackType)extracts).copyStack()).orElse(FluidStack.EMPTY);
    }
}

