/*
 * Decompiled with CFR 0.152.
 */
package com.wintercogs.beyonddimensions.DataBase.Storage;

import com.wintercogs.beyonddimensions.DataBase.Stack.FluidStackType;
import com.wintercogs.beyonddimensions.DataBase.Storage.UnifiedStorage;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class FluidUnifiedStorageHandler
implements IFluidHandler {
    private UnifiedStorage storage;

    public FluidUnifiedStorageHandler(UnifiedStorage storage) {
        this.storage = storage;
    }

    public int getTanks() {
        return this.storage.getTypeIdIndexList(FluidStackType.ID).map(list -> list.size() + 1).orElse(1);
    }

    public FluidStack getFluidInTank(int slot) {
        return this.storage.getTypeIdIndexList(FluidStackType.ID).filter(slots -> slot >= 0 && slot < slots.size()).map(slots -> (Integer)slots.get(slot)).filter(actualIndex -> actualIndex >= 0).map(actualIndex -> (FluidStackType)this.storage.getStackBySlot((int)actualIndex)).map(FluidStackType::getStack).orElse(FluidStack.EMPTY);
    }

    public int getTankCapacity(int i) {
        return Integer.MAX_VALUE;
    }

    public boolean isFluidValid(int slot, FluidStack fluidStack) {
        return true;
    }

    public int fill(FluidStack fluidStack, IFluidHandler.FluidAction fluidAction) {
        if (fluidStack.isEmpty()) {
            return 0;
        }
        int allAmount = fluidStack.getAmount();
        int remaining = (int)this.storage.insert(new FluidStackType(fluidStack.copy()), fluidAction.simulate()).getStackAmount();
        return allAmount - remaining;
    }

    public FluidStack drain(FluidStack fluidStack, IFluidHandler.FluidAction fluidAction) {
        return ((FluidStackType)this.storage.extract(new FluidStackType(fluidStack.copy()), fluidAction.simulate())).copyStack();
    }

    public FluidStack drain(int count, IFluidHandler.FluidAction fluidAction) {
        return ((FluidStackType)this.storage.extract(new FluidStackType(new FluidStack(this.getFluidInTank(0), count)), fluidAction.simulate())).copyStack();
    }
}

