/*
 * Decompiled with CFR 0.152.
 */
package com.wintercogs.beyonddimensions.Menu;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.wintercogs.beyonddimensions.BeyondDimensions;
import com.wintercogs.beyonddimensions.DataBase.Handler.IStackTypedHandler;
import com.wintercogs.beyonddimensions.DataBase.Stack.IStackType;
import com.wintercogs.beyonddimensions.DataBase.Stack.ItemStackType;
import com.wintercogs.beyonddimensions.DataBase.Stack.StackCreater;
import com.wintercogs.beyonddimensions.Menu.Slot.StoredStackSlot;
import java.util.Objects;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import org.checkerframework.checker.nullness.qual.Nullable;

public abstract class BDBaseMenu
extends AbstractContainerMenu {
    public final IStackTypedHandler storage;
    public final Player player;
    protected int inventoryStartIndex = -1;
    protected int inventoryEndIndex = -1;
    private boolean init = false;
    public boolean isHanding = false;

    protected BDBaseMenu(@Nullable MenuType<?> menuType, int containerId, Inventory playerInventory, @Nullable IStackTypedHandler storage) {
        super(menuType, containerId);
        this.player = playerInventory.f_35978_;
        this.storage = storage;
    }

    public void m_38946_() {
        for (int i = 0; i < this.f_38839_.size(); ++i) {
            Slot slot = (Slot)this.f_38839_.get(i);
            if (slot instanceof StoredStackSlot) continue;
            ItemStack itemstack = slot.m_7993_();
            Objects.requireNonNull(itemstack);
            Supplier supplier = Suppliers.memoize(() -> ((ItemStack)itemstack).m_41777_());
            this.m_150407_(i, itemstack, (java.util.function.Supplier)supplier);
            this.m_150435_(i, itemstack, (java.util.function.Supplier)supplier);
        }
        this.m_150445_();
        for (int j = 0; j < this.f_38842_.size(); ++j) {
            DataSlot dataslot = (DataSlot)this.f_38842_.get(j);
            int k = dataslot.m_6501_();
            if (dataslot.m_39409_()) {
                this.m_182420_(j, k);
            }
            this.m_150440_(j, k);
        }
        if (!this.player.m_9236_().m_5776_()) {
            if (!this.init) {
                this.initUpdate();
                this.init = true;
            }
            this.updateChange();
        }
    }

    protected abstract void updateChange();

    protected abstract void initUpdate();

    public void customClickHandler(int slotIndex, IStackType clickedStack, int button, boolean shiftDown) {
        StoredStackSlot sSlot;
        Object object;
        if (this.storage == null) {
            return;
        }
        if (this.inventoryStartIndex < 0 || this.inventoryEndIndex < 0) {
            BeyondDimensions.LOGGER.info("\u8b66\u544a:\u80cc\u5305\u7d22\u5f15\u8bbe\u7f6e\u9519\u8bef\uff01\uff01\uff01");
        }
        if ((object = this.f_38839_.get(slotIndex)) instanceof StoredStackSlot && (sSlot = (StoredStackSlot)((Object)object)).isFake()) {
            this.FakeClickHandle(slotIndex, clickedStack, button, this.player, this.storage);
            return;
        }
        if (shiftDown) {
            this.quickMoveHandle(this.player, slotIndex, clickedStack, this.storage);
        } else {
            this.clickHandle(slotIndex, clickedStack, button, this.player, this.storage);
        }
    }

    protected void FakeClickHandle(int slotIndex, IStackType clickStack, int button, Player player, IStackTypedHandler storage) {
    }

    protected abstract ItemStack quickMoveHandle(Player var1, int var2, IStackType var3, IStackTypedHandler var4);

    protected abstract void clickHandle(int var1, IStackType var2, int var3, Player var4, IStackTypedHandler var5);

    public void m_182423_() {
        super.m_182423_();
    }

    public ItemStack m_7648_(Player player, int slotIndex) {
        return ItemStack.f_41583_;
    }

    protected boolean m_38903_(ItemStack stack, int startIndex, int endIndex, boolean reverseDirection) {
        boolean flag = false;
        int i = startIndex;
        if (reverseDirection) {
            i = endIndex - 1;
        }
        while (!stack.m_41619_() && !(!reverseDirection ? i >= endIndex : i < startIndex)) {
            if (this.f_38839_.get(i) instanceof StoredStackSlot) {
                this.storage.insert(StackCreater.Create(ItemStackType.ID, stack.m_41777_(), stack.m_41613_()), false);
                flag = true;
                break;
            }
            Slot slot = (Slot)this.f_38839_.get(i);
            ItemStack itemstack = slot.m_7993_();
            if (!itemstack.m_41619_() && ItemStack.m_150942_((ItemStack)stack, (ItemStack)itemstack)) {
                int k;
                int j = itemstack.m_41613_() + stack.m_41613_();
                if (j <= (k = slot.m_5866_(itemstack))) {
                    stack.m_41764_(0);
                    itemstack.m_41764_(j);
                    slot.m_6654_();
                    flag = true;
                } else if (itemstack.m_41613_() < k) {
                    stack.m_41774_(k - itemstack.m_41613_());
                    itemstack.m_41764_(k);
                    slot.m_6654_();
                    flag = true;
                }
            }
            if (itemstack.m_41619_() && slot.m_5857_(stack)) {
                int l = slot.m_5866_(stack);
                slot.m_269060_(stack.m_41620_(Math.min(stack.m_41613_(), l)));
                slot.m_6654_();
                flag = true;
            }
            if (reverseDirection) {
                --i;
                continue;
            }
            ++i;
        }
        return flag;
    }

    protected int checkCanMoveStackCount(ItemStack stack, int startIndex, int endIndex, boolean reverseDirection) {
        int flag = 0;
        int i = startIndex;
        if (reverseDirection) {
            i = endIndex - 1;
        }
        while (!stack.m_41619_() && !(!reverseDirection ? i >= endIndex : i < startIndex)) {
            if (this.f_38839_.get(i) instanceof StoredStackSlot) {
                flag = stack.m_41741_();
                break;
            }
            Slot slot = (Slot)this.f_38839_.get(i);
            ItemStack itemstack = slot.m_7993_();
            if (!itemstack.m_41619_() && ItemStack.m_150942_((ItemStack)stack, (ItemStack)itemstack)) {
                int k = slot.m_5866_(itemstack);
                int maxCanPut = k - itemstack.m_41613_();
                flag += maxCanPut;
            }
            if (itemstack.m_41619_() && slot.m_5857_(stack)) {
                int l = slot.m_5866_(stack);
                flag += l;
            }
            if (reverseDirection) {
                --i;
                continue;
            }
            ++i;
        }
        return flag;
    }

    public abstract boolean m_6875_(Player var1);

    public boolean m_5882_(ItemStack stack, Slot slot) {
        if (!(slot instanceof StoredStackSlot)) {
            return super.m_5882_(stack, slot);
        }
        return false;
    }
}

