/*
 * Decompiled with CFR 0.152.
 */
package com.wintercogs.beyonddimensions.Api.DataBase.Stack;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.wintercogs.beyonddimensions.Api.DataBase.LongType.ManaType;
import com.wintercogs.beyonddimensions.Api.DataBase.Stack.IStackType;
import com.wintercogs.beyonddimensions.Api.DataBase.Stack.LongStackType;
import com.wintercogs.beyonddimensions.Render.IngredientRenderer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class ManaStackType
extends LongStackType<ManaType> {
    public static final ResourceLocation ID = ResourceLocation.fromNamespaceAndPath((String)"beyonddimensions", (String)"stack_type/mana");
    public static final ManaStackType EMPTY = new ManaStackType();
    public static final MapCodec<ManaStackType> TYPE_CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ManaType.CODEC.fieldOf("internal_stack").forGetter(LongStackType::getStack)).apply((Applicative)instance, ManaStackType::new));
    public static final Codec<ManaStackType> CODEC = TYPE_CODEC.codec();

    public ManaStackType() {
        this.stack = new ManaType(0L);
    }

    public ManaStackType(ManaType stack) {
        this.stack = stack;
    }

    public ManaStackType(long stackSize) {
        this.stack = new ManaType(stackSize);
    }

    @Override
    public ResourceLocation getTypeID() {
        return ID;
    }

    @Override
    public String getModId() {
        return "botania";
    }

    @Override
    public MapCodec<? extends IStackType<ManaType>> codec() {
        return TYPE_CODEC;
    }

    @Override
    public IStackType<ManaType> fromObject(Object key, long amount, DataComponentPatch dataComponentPatch) {
        if (key instanceof ManaType) {
            return new ManaStackType(amount);
        }
        return null;
    }

    @Override
    public IStackType<ManaType> getEmpty() {
        return new ManaStackType(0L);
    }

    @Override
    public Object getSource() {
        return new ManaType(0L);
    }

    @Override
    public ManaType getEmptyStack() {
        return new ManaType(0L);
    }

    @Override
    public IStackType<ManaType> copy() {
        ManaStackType copy = new ManaStackType(((ManaType)this.stack).getStackCount());
        copy.NeedRecalHash = this.NeedRecalHash;
        copy.hashCodeCache = this.hashCodeCache;
        return copy;
    }

    @Override
    public IStackType<ManaType> copyWithCount(long count) {
        ManaStackType copy = new ManaStackType(count);
        copy.NeedRecalHash = this.NeedRecalHash;
        copy.hashCodeCache = this.hashCodeCache;
        return copy;
    }

    @Override
    public IStackType<ManaType> split(long amount) {
        if (amount <= 0L) {
            return new ManaStackType();
        }
        long splitAmount = Math.min(amount, ((ManaType)this.stack).getStackCount());
        ((ManaType)this.stack).shrink(splitAmount);
        return new ManaStackType(splitAmount);
    }

    @Override
    public boolean hasTag(TagKey<?> tagKey) {
        return false;
    }

    @Override
    public long getVanillaMaxStackSize() {
        return 1000000L;
    }

    @Override
    public void serialize(RegistryFriendlyByteBuf buf) {
        buf.writeResourceLocation(this.getTypeId());
        buf.writeVarLong(((ManaType)this.stack).getStackCount());
    }

    @Override
    public IStackType<ManaType> deserialize(RegistryFriendlyByteBuf buf, ResourceLocation typeId) {
        if (!typeId.equals((Object)this.getTypeId())) {
            return null;
        }
        long count = buf.readVarLong();
        return new ManaStackType(count);
    }

    @Override
    public CompoundTag serializeNBT(HolderLookup.Provider levelRegistryAccess) {
        CompoundTag tag = new CompoundTag();
        tag.putString("Type", ID.toString());
        tag.putLong("Amount", this.getStackAmount());
        return tag;
    }

    @Override
    public IStackType<ManaType> deserializeNBT(CompoundTag nbt, HolderLookup.Provider levelRegistryAccess) {
        return new ManaStackType(nbt.getLong("Amount"));
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void render(GuiGraphics gui, int x, int y) {
        if (((ManaType)this.stack).isEmpty()) {
            return;
        }
        PoseStack poseStack = gui.pose();
        poseStack.pushPose();
        int tintColor = -1;
        TextureAtlasSprite sprite = IngredientRenderer.BOTANIA_MANA.sprite();
        IngredientRenderer.drawTiledSprite(gui, 16, 16, tintColor, 16L, sprite, x, y);
        poseStack.popPose();
        String countText = this.getCountText(this.getStackAmount());
        float scale = 0.666f;
        PoseStack poseStackText = gui.pose();
        poseStackText.pushPose();
        poseStackText.translate(0.0f, 0.0f, 200.0f);
        poseStackText.scale(scale, scale, scale);
        RenderSystem.disableBlend();
        int X = (int)(((float)(x + -1) + 16.0f + 2.0f - (float)Minecraft.getInstance().font.width(countText) * 0.666f) * 1.0f / 0.666f);
        int Y = (int)(((float)(y + -1) + 16.0f - 3.33f) * 1.0f / 0.666f);
        if (!((ManaType)this.stack).isEmpty()) {
            gui.drawString(Minecraft.getInstance().font, countText, X, Y, 0xFFFFFF);
        }
        poseStackText.popPose();
    }
}

