/*
 * Decompiled with CFR 0.152.
 */
package com.wintercogs.beyonddimensions.Api.DataBase.Stack;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.wintercogs.beyonddimensions.Api.DataBase.LongType.SourceType;
import com.wintercogs.beyonddimensions.Api.DataBase.Stack.IStackType;
import com.wintercogs.beyonddimensions.Api.DataBase.Stack.LongStackType;
import com.wintercogs.beyonddimensions.Render.IngredientRenderer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class SourceStackType
extends LongStackType<SourceType> {
    public static final ResourceLocation ID = ResourceLocation.fromNamespaceAndPath((String)"beyonddimensions", (String)"stack_type/source");
    public static final SourceStackType EMPTY = new SourceStackType();
    public static final MapCodec<SourceStackType> TYPE_CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)SourceType.CODEC.fieldOf("internal_stack").forGetter(LongStackType::getStack)).apply((Applicative)instance, SourceStackType::new));
    public static final Codec<SourceStackType> CODEC = TYPE_CODEC.codec();

    public SourceStackType() {
        this.stack = new SourceType(0L);
    }

    public SourceStackType(SourceType stack) {
        this.stack = stack;
    }

    public SourceStackType(long stackSize) {
        this.stack = new SourceType(stackSize);
    }

    @Override
    public MapCodec<SourceStackType> codec() {
        return TYPE_CODEC;
    }

    @Override
    public ResourceLocation getTypeID() {
        return ID;
    }

    @Override
    public String getModId() {
        return "ars_nouveau";
    }

    @Override
    public IStackType<SourceType> fromObject(Object key, long amount, DataComponentPatch dataComponentPatch) {
        if (key instanceof SourceType) {
            return new SourceStackType(amount);
        }
        return null;
    }

    @Override
    public IStackType<SourceType> getEmpty() {
        return new SourceStackType();
    }

    @Override
    public Object getSource() {
        return new SourceType(0L);
    }

    @Override
    public SourceType getEmptyStack() {
        return new SourceType(0L);
    }

    @Override
    public IStackType<SourceType> copy() {
        SourceStackType copy = new SourceStackType(((SourceType)this.stack).getStackCount());
        copy.NeedRecalHash = this.NeedRecalHash;
        copy.hashCodeCache = this.hashCodeCache;
        return copy;
    }

    @Override
    public IStackType<SourceType> copyWithCount(long count) {
        SourceStackType copy = new SourceStackType(count);
        copy.NeedRecalHash = this.NeedRecalHash;
        copy.hashCodeCache = this.hashCodeCache;
        return copy;
    }

    @Override
    public IStackType<SourceType> split(long amount) {
        if (amount <= 0L) {
            return new SourceStackType();
        }
        long splitAmount = Math.min(amount, ((SourceType)this.stack).getStackCount());
        ((SourceType)this.stack).shrink(splitAmount);
        return new SourceStackType(splitAmount);
    }

    @Override
    public boolean hasTag(TagKey<?> tagKey) {
        return false;
    }

    @Override
    public long getVanillaMaxStackSize() {
        return 1000000L;
    }

    @Override
    public void serialize(RegistryFriendlyByteBuf buf) {
        buf.writeResourceLocation(this.getTypeId());
        buf.writeVarLong(((SourceType)this.stack).getStackCount());
    }

    @Override
    public IStackType<SourceType> deserialize(RegistryFriendlyByteBuf buf, ResourceLocation typeId) {
        if (!typeId.equals((Object)this.getTypeId())) {
            return null;
        }
        long count = buf.readVarLong();
        return new SourceStackType(count);
    }

    @Override
    public CompoundTag serializeNBT(HolderLookup.Provider levelRegistryAccess) {
        CompoundTag tag = new CompoundTag();
        tag.putString("Type", ID.toString());
        tag.putLong("Amount", this.getStackAmount());
        return tag;
    }

    @Override
    public IStackType<SourceType> deserializeNBT(CompoundTag nbt, HolderLookup.Provider levelRegistryAccess) {
        return new SourceStackType(nbt.getLong("Amount"));
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void render(GuiGraphics gui, int x, int y) {
        if (((SourceType)this.stack).isEmpty()) {
            return;
        }
        PoseStack poseStack = gui.pose();
        poseStack.pushPose();
        int tintColor = -1;
        TextureAtlasSprite sprite = IngredientRenderer.ARS_SOURCE.sprite();
        IngredientRenderer.drawTiledSprite(gui, 16, 16, tintColor, 16L, sprite, x, y);
        poseStack.popPose();
        String countText = this.getCountText(this.getStackAmount());
        float scale = 0.666f;
        PoseStack poseStackText = gui.pose();
        poseStackText.pushPose();
        poseStackText.translate(0.0f, 0.0f, 200.0f);
        poseStackText.scale(scale, scale, scale);
        RenderSystem.disableBlend();
        int X = (int)(((float)(x + -1) + 16.0f + 2.0f - (float)Minecraft.getInstance().font.width(countText) * 0.666f) * 1.0f / 0.666f);
        int Y = (int)(((float)(y + -1) + 16.0f - 3.33f) * 1.0f / 0.666f);
        if (!((SourceType)this.stack).isEmpty()) {
            gui.drawString(Minecraft.getInstance().font, countText, X, Y, 0xFFFFFF);
        }
        poseStackText.popPose();
    }
}

