/*
 * Decompiled with CFR 0.152.
 */
package com.wintercogs.beyonddimensions.Block.Custom;

import com.mojang.logging.LogUtils;
import com.wintercogs.beyonddimensions.Block.Custom.BaseMachineBlock;
import com.wintercogs.beyonddimensions.BlockEntity.Custom.NetInterfaceBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class NetInterfaceBlock
extends BaseMachineBlock {
    private static final Logger LOGGER = LogUtils.getLogger();

    public NetInterfaceBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    @Override
    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        super.useWithoutItem(state, level, pos, player, hitResult);
        if (!level.isClientSide() && !player.isShiftKeyDown()) {
            player.openMenu((MenuProvider)((NetInterfaceBlockEntity)level.getBlockEntity(pos)), pos);
        }
        return InteractionResult.SUCCESS_NO_ITEM_USED;
    }

    protected void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean movedByPiston) {
        if (!state.is(newState.getBlock())) {
            BlockEntity blockEntity = level.getBlockEntity(pos);
            if (blockEntity instanceof NetInterfaceBlockEntity) {
                NetInterfaceBlockEntity blockEntity2 = (NetInterfaceBlockEntity)blockEntity;
                level.updateNeighbourForOutputSignal(pos, (Block)this);
                blockEntity2.dropContent();
            }
            super.onRemove(state, level, pos, newState, movedByPiston);
        }
    }

    public void onNeighborChange(BlockState state, LevelReader level, BlockPos pos, BlockPos neighbor) {
        super.onNeighborChange(state, level, pos, neighbor);
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof NetInterfaceBlockEntity) {
            NetInterfaceBlockEntity blockEntity2 = (NetInterfaceBlockEntity)blockEntity;
            blockEntity2.setNeedsCapabilityUpdate();
        }
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos blockPos, BlockState blockState) {
        return new NetInterfaceBlockEntity(blockPos, blockState);
    }
}

