/*
 * Decompiled with CFR 0.152.
 */
package com.wintercogs.beyonddimensions.BlockEntity.Custom;

import com.wintercogs.beyonddimensions.Api.DataBase.Handler.ItemStackTypedHandler;
import com.wintercogs.beyonddimensions.Api.DataBase.Handler.StackTypedHandler;
import com.wintercogs.beyonddimensions.Api.DataBase.Stack.EnergyStackType;
import com.wintercogs.beyonddimensions.Api.DataBase.Stack.FluidStackType;
import com.wintercogs.beyonddimensions.Api.DataBase.Stack.IStackType;
import com.wintercogs.beyonddimensions.Api.DataBase.Stack.ItemStackType;
import com.wintercogs.beyonddimensions.Api.DataBase.Storage.UnifiedStorage;
import com.wintercogs.beyonddimensions.Api.Util.CombinedItemHandlerWrapper;
import com.wintercogs.beyonddimensions.Block.Custom.NetFurnaceBlock;
import com.wintercogs.beyonddimensions.BlockEntity.Custom.BaseMachineBlockEntity;
import com.wintercogs.beyonddimensions.BlockEntity.Custom.NetedBlockEntity;
import com.wintercogs.beyonddimensions.BlockEntity.ModBlockEntities;
import com.wintercogs.beyonddimensions.DataComponents.ModDataComponents;
import com.wintercogs.beyonddimensions.Item.Custom.MatterCompressionBall;
import com.wintercogs.beyonddimensions.Item.ModItems;
import com.wintercogs.beyonddimensions.Machine.AutoSortMode;
import com.wintercogs.beyonddimensions.Machine.PopMode;
import com.wintercogs.beyonddimensions.Machine.ReceiveMode;
import com.wintercogs.beyonddimensions.Menu.NetFurnaceMenu;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.item.crafting.SmeltingRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.Nullable;

public class NetFurnaceBlockEntity
extends BaseMachineBlockEntity
implements MenuProvider {
    private static final int capacity = 9;
    private static final int filterCapacity = 8;
    private static final int fuelCapacity = 1;
    public PopMode popMode = PopMode.STOP;
    public ReceiveMode receiveMode = ReceiveMode.STOP;
    public AutoSortMode sortMode = AutoSortMode.STOP;
    private int sortCursor = 0;
    private List<RecipeManager.CachedCheck<SingleRecipeInput, SmeltingRecipe>> quickChecks = new ArrayList<RecipeManager.CachedCheck>(Collections.nCopies(9, RecipeManager.createCheck((RecipeType)RecipeType.SMELTING)));
    private List<Integer> litTime = new ArrayList<Integer>(Collections.nCopies(9, 0));
    private List<Integer> litDuration = new ArrayList<Integer>(Collections.nCopies(9, 0));
    private List<Integer> cookTime = new ArrayList<Integer>(Collections.nCopies(9, 0));
    private List<Integer> cookTimeTotal = new ArrayList<Integer>(Collections.nCopies(9, 0));
    private final StackTypedHandler inputFilterSlots = new StackTypedHandler(8){

        @Override
        public void onChange() {
            if (!NetFurnaceBlockEntity.this.level.isClientSide()) {
                NetFurnaceBlockEntity.this.level.blockEntityChanged(NetFurnaceBlockEntity.this.worldPosition);
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean isStackValid(int slot, IStackType stack) {
            if (!(stack instanceof ItemStackType)) return false;
            ItemStackType itemInput = (ItemStackType)stack;
            if (!NetFurnaceBlockEntity.this.quickChecks.get(slot).getRecipeFor((RecipeInput)new SingleRecipeInput(itemInput.copyStack()), NetFurnaceBlockEntity.this.level).isPresent()) return false;
            return true;
        }
    };
    private final StackTypedHandler fuelFilterSlots = new StackTypedHandler(8){

        @Override
        public void onChange() {
            if (!NetFurnaceBlockEntity.this.level.isClientSide()) {
                NetFurnaceBlockEntity.this.level.blockEntityChanged(NetFurnaceBlockEntity.this.worldPosition);
            }
        }

        @Override
        public boolean isStackValid(int slot, IStackType stack) {
            ItemStackType itemFuel;
            FluidStackType fluidStack;
            return stack instanceof EnergyStackType || stack instanceof FluidStackType && (fluidStack = (FluidStackType)stack).copyStack().getFluid() == Fluids.LAVA || stack instanceof ItemStackType && (itemFuel = (ItemStackType)stack).getStack().getBurnTime(RecipeType.SMELTING) > 0;
        }
    };
    private final StackTypedHandler inputStorageSlots = new StackTypedHandler(9){

        @Override
        public void onChange() {
            if (!NetFurnaceBlockEntity.this.level.isClientSide()) {
                NetFurnaceBlockEntity.this.level.blockEntityChanged(NetFurnaceBlockEntity.this.worldPosition);
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean isStackValid(int slot, IStackType stack) {
            if (!(stack instanceof ItemStackType)) return false;
            ItemStackType itemInput = (ItemStackType)stack;
            if (!NetFurnaceBlockEntity.this.quickChecks.get(slot).getRecipeFor((RecipeInput)new SingleRecipeInput(itemInput.copyStack()), NetFurnaceBlockEntity.this.level).isPresent()) return false;
            return true;
        }
    };
    private final StackTypedHandler outputStorageSlots = new StackTypedHandler(9){

        @Override
        public void onChange() {
            if (!NetFurnaceBlockEntity.this.level.isClientSide()) {
                NetFurnaceBlockEntity.this.level.blockEntityChanged(NetFurnaceBlockEntity.this.worldPosition);
            }
        }
    };
    private final StackTypedHandler fuelStorageSlots = new StackTypedHandler(1){

        @Override
        public void onChange() {
            if (!NetFurnaceBlockEntity.this.level.isClientSide()) {
                NetFurnaceBlockEntity.this.level.blockEntityChanged(NetFurnaceBlockEntity.this.worldPosition);
            }
        }

        @Override
        public boolean isStackValid(int slot, IStackType stack) {
            ItemStackType itemFuel;
            FluidStackType fluidStack;
            return stack instanceof EnergyStackType || stack instanceof FluidStackType && (fluidStack = (FluidStackType)stack).copyStack().getFluid() == Fluids.LAVA || stack instanceof ItemStackType && (itemFuel = (ItemStackType)stack).getStack().getBurnTime(RecipeType.SMELTING) > 0;
        }
    };
    private final StackTypedHandler fuelReturnSlots = new StackTypedHandler(1){

        @Override
        public void onChange() {
            if (!NetFurnaceBlockEntity.this.level.isClientSide()) {
                NetFurnaceBlockEntity.this.level.blockEntityChanged(NetFurnaceBlockEntity.this.worldPosition);
            }
        }
    };

    public int getCapacity() {
        return 9;
    }

    public int getFilterCapacity() {
        return 8;
    }

    public int getFuelCapacity() {
        return 1;
    }

    public List<Integer> getLitTime() {
        return this.litTime;
    }

    public void setLitTime(List<Integer> litTime) {
        this.litTime = litTime;
    }

    public List<Integer> getLitDuration() {
        return this.litDuration;
    }

    public void setLitDuration(List<Integer> litDuration) {
        this.litDuration = litDuration;
    }

    public List<Integer> getCookTime() {
        return this.cookTime;
    }

    public void setCookTime(List<Integer> cookTime) {
        this.cookTime = cookTime;
    }

    public List<Integer> getCookTimeTotal() {
        return this.cookTimeTotal;
    }

    public void setCookTimeTotal(List<Integer> cookTimeTotal) {
        this.cookTimeTotal = cookTimeTotal;
    }

    public StackTypedHandler getInputFilterSlots() {
        return this.inputFilterSlots;
    }

    public StackTypedHandler getFuelFilterSlots() {
        return this.fuelFilterSlots;
    }

    public StackTypedHandler getInputStorageSlots() {
        return this.inputStorageSlots;
    }

    public StackTypedHandler getOutputStorageSlots() {
        return this.outputStorageSlots;
    }

    public StackTypedHandler getFuelStorageSlots() {
        return this.fuelStorageSlots;
    }

    public StackTypedHandler getFuelReturnSlots() {
        return this.fuelReturnSlots;
    }

    public NetFurnaceBlockEntity(BlockPos pos, BlockState blockState) {
        super(ModBlockEntities.NET_FURNACE_BLOCK_ENTITY.get(), pos, blockState);
    }

    public static void registerCapability(RegisterCapabilitiesEvent event) {
        event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, ModBlockEntities.NET_FURNACE_BLOCK_ENTITY.get(), (be, side) -> {
            ItemStackTypedHandler inputStorage = new ItemStackTypedHandler(be.inputStorageSlots){

                @Override
                public ItemStack extractItem(int slot, int count, boolean sim) {
                    return ItemStack.EMPTY;
                }
            };
            ItemStackTypedHandler fuelStorage = new ItemStackTypedHandler(be.fuelStorageSlots){

                @Override
                public ItemStack extractItem(int slot, int count, boolean sim) {
                    return ItemStack.EMPTY;
                }
            };
            ItemStackTypedHandler outputStorage = new ItemStackTypedHandler(be.outputStorageSlots){

                @Override
                public ItemStack insertItem(int slot, ItemStack itemStack, boolean sim) {
                    return itemStack;
                }
            };
            ItemStackTypedHandler fuelReturn = new ItemStackTypedHandler(be.fuelReturnSlots){

                @Override
                public ItemStack insertItem(int slot, ItemStack itemStack, boolean sim) {
                    return itemStack;
                }
            };
            return new CombinedItemHandlerWrapper(inputStorage, fuelStorage, outputStorage, fuelReturn);
        });
    }

    @Override
    public int getTicksPerWork() {
        return 1;
    }

    @Override
    public boolean shouldWork() {
        this.litTime.replaceAll(i -> Math.max(0, i - 1));
        if (this.litTime.stream().allMatch(t -> t <= 0)) {
            this.setLit(false);
        } else {
            this.setLit(true);
        }
        this.level.blockEntityChanged(this.worldPosition);
        return super.shouldWork() && (!this.inputStorageSlots.isEmpty() || !this.inputFilterSlots.isEmpty() || !this.outputStorageSlots.isEmpty() || !this.fuelReturnSlots.isEmpty() || !this.fuelStorageSlots.isEmpty() || !this.fuelFilterSlots.isEmpty());
    }

    @Override
    public void workStart() {
        super.workStart();
        if (this.getNet() != null) {
            Object amounts;
            UnifiedStorage storage = this.getNet().getUnifiedStorage();
            block0: for (int inputSlot = 0; inputSlot < 9; ++inputSlot) {
                if (!this.inputStorageSlots.getStackBySlot(inputSlot).isEmpty()) continue;
                for (IStackType filterStack : this.inputFilterSlots.getStorage()) {
                    IStackType extracted;
                    IStackType remaining;
                    ItemStackType filterItem;
                    if (!this.inputStorageSlots.getStackBySlot(inputSlot).isEmpty()) continue block0;
                    if (!(filterStack instanceof ItemStackType) || (filterItem = (ItemStackType)filterStack).isEmpty() || (remaining = this.inputStorageSlots.insert(inputSlot, extracted = storage.extract(filterItem.copyWithCount(filterItem.getVanillaMaxStackSize()), false), false)).isEmpty()) continue;
                    storage.insert(remaining, false);
                }
            }
            if (this.sortMode == AutoSortMode.OPEN) {
                IStackType[] stacks = new IStackType[9];
                amounts = new long[9];
                HashMap<IStackType, List> groupSlots = new HashMap<IStackType, List>();
                HashMap<IStackType, Long> groupTotal = new HashMap<IStackType, Long>();
                ArrayList<Integer> emptySlots = new ArrayList<Integer>();
                for (int i = 0; i < 9; ++i) {
                    IStackType s;
                    stacks[i] = s = this.inputStorageSlots.getStackBySlot(i);
                    if (s == null || s.isEmpty()) {
                        emptySlots.add(i);
                        amounts[i] = 0L;
                        continue;
                    }
                    long amt = s.getStackAmount();
                    amounts[i] = amt;
                    groupSlots.computeIfAbsent(s, k -> new ArrayList()).add(i);
                    groupTotal.put(s, groupTotal.getOrDefault(s, 0L) + amt);
                }
                block3: for (Map.Entry entry : groupSlots.entrySet()) {
                    IStackType type = (IStackType)entry.getKey();
                    List typedSlots = (List)entry.getValue();
                    long total = (Long)groupTotal.get(type);
                    int k2 = (int)Math.min(total, (long)(typedSlots.size() + emptySlots.size()));
                    while (typedSlots.size() < k2 && !emptySlots.isEmpty()) {
                        int idx = (Integer)emptySlots.remove(emptySlots.size() - 1);
                        typedSlots.add(idx);
                        stacks[idx] = type;
                        amounts[idx] = 0L;
                    }
                    long base = total / (long)k2;
                    int extra = (int)(total % (long)k2);
                    int surplusPtr = 0;
                    int deficitPtr = 0;
                    while (true) {
                        long deficit;
                        reference var21_31;
                        long move;
                        IStackType moved;
                        long target;
                        int idx;
                        if (surplusPtr < k2 && amounts[idx = ((Integer)typedSlots.get(surplusPtr)).intValue()] <= (target = base + (long)(surplusPtr < extra ? 1 : 0))) {
                            ++surplusPtr;
                            continue;
                        }
                        while (deficitPtr < k2 && amounts[idx = ((Integer)typedSlots.get(deficitPtr)).intValue()] >= (target = base + (long)(deficitPtr < extra ? 1 : 0))) {
                            ++deficitPtr;
                        }
                        if (surplusPtr >= k2 || deficitPtr >= k2) continue block3;
                        int from = (Integer)typedSlots.get(surplusPtr);
                        int to = (Integer)typedSlots.get(deficitPtr);
                        IStackType leftover = this.inputStorageSlots.insert(to, moved = this.inputStorageSlots.extract(from, move = Math.min((long)(var21_31 = amounts[from] - (base + (long)(surplusPtr < extra ? 1 : 0))), deficit = base + (long)(deficitPtr < extra ? 1 : 0) - amounts[to]), false), false);
                        if (!leftover.isEmpty()) {
                            this.inputStorageSlots.insert(from, leftover, false);
                            continue block3;
                        }
                        Object object = amounts;
                        int n = from;
                        object[n] = object[n] - move;
                        Object object2 = amounts;
                        int n2 = to;
                        object2[n2] = object2[n2] + move;
                    }
                }
            }
            block7: for (int fuelSlot = 0; fuelSlot < 1; ++fuelSlot) {
                if (!this.fuelStorageSlots.getStackBySlot(fuelSlot).isEmpty()) continue;
                amounts = this.fuelFilterSlots.getStorage().iterator();
                while (amounts.hasNext()) {
                    IStackType filterStack;
                    filterStack = (IStackType)amounts.next();
                    if (filterStack.isEmpty()) continue;
                    if (!this.fuelStorageSlots.getStackBySlot(fuelSlot).isEmpty()) continue block7;
                    IStackType extracted = storage.extract(filterStack.copyWithCount(filterStack.getVanillaMaxStackSize()), false);
                    IStackType remaining = this.fuelStorageSlots.insert(fuelSlot, extracted, false);
                    if (remaining.isEmpty()) continue;
                    storage.insert(remaining, false);
                }
            }
        }
        for (int litSlot = 0; litSlot < 9; ++litSlot) {
            if (this.litTime.get(litSlot) > 0 || this.inputStorageSlots.getStackBySlot(litSlot).isEmpty()) continue;
            for (IStackType fuelStack : this.fuelStorageSlots.getStorage()) {
                ItemStackType fuelItem;
                int burnTime;
                FluidStackType fuelFluid;
                if (fuelStack.isEmpty()) continue;
                if (fuelStack instanceof EnergyStackType) {
                    EnergyStackType fuelEnergy = (EnergyStackType)fuelStack;
                    int burnTime2 = (int)Math.min(fuelEnergy.getStackAmount(), 20000L);
                    if (burnTime2 <= 0) continue;
                    this.fuelStorageSlots.extract(fuelEnergy.copyWithCount(burnTime2), false);
                    this.litTime.set(litSlot, burnTime2);
                    this.litDuration.set(litSlot, burnTime2);
                    continue;
                }
                if (fuelStack instanceof FluidStackType && (fuelFluid = (FluidStackType)fuelStack).copyStack().getFluid() == Fluids.LAVA) {
                    int burnNum = (int)Math.min(fuelFluid.getStackAmount(), 1000L);
                    int burnTime3 = burnNum * 20;
                    if (burnTime3 <= 0) continue;
                    this.fuelStorageSlots.extract(fuelFluid.copyWithCount(burnNum), false);
                    this.litTime.set(litSlot, burnTime3);
                    this.litDuration.set(litSlot, burnTime3);
                    continue;
                }
                if (!(fuelStack instanceof ItemStackType) || (burnTime = (fuelItem = (ItemStackType)fuelStack).getStack().getBurnTime(RecipeType.SMELTING)) <= 0) continue;
                ItemStack returnItem = fuelItem.copyStack().getCraftingRemainingItem();
                if (returnItem.isEmpty()) {
                    this.fuelStorageSlots.extract(fuelItem.copyWithCount(1L), false);
                    this.litTime.set(litSlot, burnTime);
                    this.litDuration.set(litSlot, burnTime);
                    continue;
                }
                if (this.fuelReturnSlots.insert(new ItemStackType(returnItem), true).isEmpty()) {
                    this.fuelReturnSlots.insert(new ItemStackType(returnItem), false);
                    this.fuelStorageSlots.extract(fuelItem.copyWithCount(1L), false);
                    this.litTime.set(litSlot, burnTime);
                    this.litDuration.set(litSlot, burnTime);
                    continue;
                }
                this.litTime.set(litSlot, 0);
                this.litDuration.set(litSlot, 0);
            }
        }
    }

    @Override
    public void workContent() {
        super.workContent();
        for (int inputSlot = 0; inputSlot < 9; ++inputSlot) {
            ItemStackType inputItem;
            if (this.litTime.get(inputSlot) <= 0) continue;
            IStackType iStackType = this.inputStorageSlots.getStackBySlot(inputSlot);
            if (iStackType instanceof ItemStackType && !(inputItem = (ItemStackType)iStackType).isEmpty()) {
                RecipeHolder recipeHolder = this.quickChecks.get(inputSlot).getRecipeFor((RecipeInput)new SingleRecipeInput(inputItem.getStack()), this.level).orElse(null);
                if (recipeHolder != null) {
                    this.cookTimeTotal.set(inputSlot, ((SmeltingRecipe)recipeHolder.value()).getCookingTime());
                    if (this.cookTime.get(inputSlot) >= this.cookTimeTotal.get(inputSlot)) {
                        ItemStackType resultItem = new ItemStackType(((SmeltingRecipe)recipeHolder.value()).getResultItem((HolderLookup.Provider)this.level.registryAccess()));
                        if (!this.outputStorageSlots.insert(inputSlot, resultItem, true).isEmpty()) continue;
                        this.outputStorageSlots.insert(inputSlot, resultItem, false);
                        this.inputStorageSlots.extract(inputSlot, 1L, false);
                        this.cookTime.set(inputSlot, 0);
                        this.cookTimeTotal.set(inputSlot, ((SmeltingRecipe)recipeHolder.value()).getCookingTime());
                        continue;
                    }
                    this.cookTime.set(inputSlot, this.cookTime.get(inputSlot) + 1);
                    continue;
                }
                this.cookTime.set(inputSlot, 0);
                this.cookTimeTotal.set(inputSlot, 0);
                continue;
            }
            this.cookTime.set(inputSlot, 0);
            this.cookTimeTotal.set(inputSlot, 0);
        }
    }

    @Override
    public void workEnd() {
        IStackType extracted;
        IStackType extracted2;
        super.workEnd();
        ArrayList<IItemHandler> otherStroages = new ArrayList<IItemHandler>();
        if (this.popMode == PopMode.OPEN) {
            for (Direction dir : Direction.values()) {
                IItemHandler otherStorage;
                BlockPos targetPos = this.getBlockPos().relative(dir);
                BlockEntity neighbor = this.level.getBlockEntity(targetPos);
                if (neighbor == null || neighbor instanceof NetedBlockEntity || (otherStorage = (IItemHandler)this.level.getCapability(Capabilities.ItemHandler.BLOCK, targetPos, (Object)dir.getOpposite())) == null) continue;
                otherStroages.add(otherStorage);
            }
        }
        for (int outputSlot = 0; outputSlot < 9; ++outputSlot) {
            UnifiedStorage storage;
            IStackType remaining;
            IStackType outputStack = this.outputStorageSlots.getStackBySlot(outputSlot);
            if (outputStack == null || outputStack.isEmpty()) continue;
            for (IItemHandler otherStorage : otherStroages) {
                for (int otherSlot = 0; otherSlot < otherStorage.getSlots(); ++otherSlot) {
                    extracted2 = this.outputStorageSlots.extract(outputSlot, outputStack.getVanillaMaxStackSize(), false);
                    int remaining2 = otherStorage.insertItem(otherSlot, (ItemStack)extracted2.copyStack(), false).getCount();
                    if (remaining2 <= 0) continue;
                    this.outputStorageSlots.insert(outputSlot, extracted2.copyWithCount(remaining2), false);
                }
            }
            if (this.receiveMode != ReceiveMode.OPEN || this.getNet() == null || (remaining = (storage = this.getNet().getUnifiedStorage()).insert(outputSlot, extracted = this.outputStorageSlots.extract(outputSlot, outputStack.getStackAmount(), false), false)).isEmpty()) continue;
            this.outputStorageSlots.insert(outputSlot, remaining, false);
        }
        for (int returnSlot = 0; returnSlot < 1; ++returnSlot) {
            IStackType remaining;
            IStackType returnStack = this.fuelReturnSlots.getStackBySlot(returnSlot);
            if (returnStack == null || returnStack.isEmpty()) continue;
            Object storage = otherStroages.iterator();
            while (storage.hasNext()) {
                IItemHandler otherStorage;
                otherStorage = (IItemHandler)storage.next();
                for (int otherSlot = 0; otherSlot < otherStorage.getSlots(); ++otherSlot) {
                    extracted2 = this.fuelReturnSlots.extract(returnSlot, returnStack.getVanillaMaxStackSize(), false);
                    int remaining3 = otherStorage.insertItem(otherSlot, (ItemStack)extracted2.copyStack(), false).getCount();
                    if (remaining3 <= 0) continue;
                    this.fuelReturnSlots.insert(returnSlot, extracted2.copyWithCount(remaining3), false);
                }
            }
            if (this.receiveMode != ReceiveMode.OPEN || this.getNet() == null || (remaining = ((UnifiedStorage)(storage = this.getNet().getUnifiedStorage())).insert(returnSlot, extracted = this.fuelReturnSlots.extract(returnSlot, returnStack.getStackAmount(), false), false)).isEmpty()) continue;
            this.fuelReturnSlots.insert(returnSlot, remaining, false);
        }
        for (int fuelSlot = 0; fuelSlot < 1; ++fuelSlot) {
            UnifiedStorage storage;
            IStackType remaining;
            IStackType fuelStack = this.fuelStorageSlots.getStackBySlot(fuelSlot);
            if (fuelStack == null || fuelStack.isEmpty() || !(fuelStack instanceof EnergyStackType) && !(fuelStack instanceof FluidStackType) || this.receiveMode != ReceiveMode.OPEN || this.getNet() == null || this.fuelFilterSlots.hasStackType(fuelStack) || (remaining = (storage = this.getNet().getUnifiedStorage()).insert(fuelSlot, extracted = this.fuelStorageSlots.extract(fuelSlot, fuelStack.getStackAmount(), false), false)).isEmpty()) continue;
            this.fuelStorageSlots.insert(fuelSlot, remaining, false);
        }
    }

    public void dropContent() {
        ItemStackType itemStackType;
        ArrayList dropList = new ArrayList();
        for (IStackType stack : this.inputStorageSlots.getStorage()) {
            if (stack.isEmpty()) continue;
            if (stack instanceof ItemStackType) {
                itemStackType = (ItemStackType)stack;
                if (itemStackType.getStack().getItem() instanceof MatterCompressionBall) {
                    Block.popResource((Level)this.level, (BlockPos)this.getBlockPos(), (ItemStack)itemStackType.copyStack());
                    continue;
                }
                dropList.add(stack.copy());
                continue;
            }
            dropList.add(stack.copy());
        }
        for (IStackType stack : this.outputStorageSlots.getStorage()) {
            if (stack.isEmpty()) continue;
            if (stack instanceof ItemStackType) {
                itemStackType = (ItemStackType)stack;
                if (itemStackType.getStack().getItem() instanceof MatterCompressionBall) {
                    Block.popResource((Level)this.level, (BlockPos)this.getBlockPos(), (ItemStack)itemStackType.copyStack());
                    continue;
                }
                dropList.add(stack.copy());
                continue;
            }
            dropList.add(stack.copy());
        }
        for (IStackType stack : this.fuelStorageSlots.getStorage()) {
            if (stack.isEmpty()) continue;
            if (stack instanceof ItemStackType) {
                itemStackType = (ItemStackType)stack;
                if (itemStackType.getStack().getItem() instanceof MatterCompressionBall) {
                    Block.popResource((Level)this.level, (BlockPos)this.getBlockPos(), (ItemStack)itemStackType.copyStack());
                    continue;
                }
                dropList.add(stack.copy());
                continue;
            }
            dropList.add(stack.copy());
        }
        for (IStackType stack : this.fuelReturnSlots.getStorage()) {
            if (stack.isEmpty()) continue;
            if (stack instanceof ItemStackType) {
                itemStackType = (ItemStackType)stack;
                if (itemStackType.getStack().getItem() instanceof MatterCompressionBall) {
                    Block.popResource((Level)this.level, (BlockPos)this.getBlockPos(), (ItemStack)itemStackType.copyStack());
                    continue;
                }
                dropList.add(stack.copy());
                continue;
            }
            dropList.add(stack.copy());
        }
        ItemStack ball = new ItemStack((ItemLike)ModItems.MATTER_COMPRESS_BALL.get(), 1);
        if (!dropList.isEmpty()) {
            ball.set(ModDataComponents.ISTACK_SLOTS, dropList);
            Block.popResource((Level)this.level, (BlockPos)this.getBlockPos(), (ItemStack)ball);
        }
    }

    @Override
    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.inputFilterSlots.deserializeNBT(registries, tag.getCompound("input_filter_slots"));
        this.fuelFilterSlots.deserializeNBT(registries, tag.getCompound("fuel_filter_slots"));
        this.inputStorageSlots.deserializeNBT(registries, tag.getCompound("input_storage_slots"));
        this.outputStorageSlots.deserializeNBT(registries, tag.getCompound("output_storage_slots"));
        this.fuelStorageSlots.deserializeNBT(registries, tag.getCompound("fuel_storage_slots"));
        this.fuelReturnSlots.deserializeNBT(registries, tag.getCompound("fuel_return_slots"));
        this.litTime = Arrays.stream(tag.getIntArray("lit_time")).boxed().collect(Collectors.toList());
        this.litDuration = Arrays.stream(tag.getIntArray("lit_duration")).boxed().collect(Collectors.toList());
        this.cookTime = Arrays.stream(tag.getIntArray("cook_time")).boxed().collect(Collectors.toList());
        this.cookTimeTotal = Arrays.stream(tag.getIntArray("cook_time_total")).boxed().collect(Collectors.toList());
        this.popMode = PopMode.valueOf(tag.getString("pop_mode"));
        this.receiveMode = ReceiveMode.valueOf(tag.getString("receive_mode"));
        this.sortMode = tag.contains("sort_mode") ? AutoSortMode.valueOf(tag.getString("sort_mode")) : AutoSortMode.STOP;
    }

    @Override
    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        tag.put("input_filter_slots", (Tag)this.inputFilterSlots.serializeNBT(registries));
        tag.put("fuel_filter_slots", (Tag)this.fuelFilterSlots.serializeNBT(registries));
        tag.put("input_storage_slots", (Tag)this.inputStorageSlots.serializeNBT(registries));
        tag.put("output_storage_slots", (Tag)this.outputStorageSlots.serializeNBT(registries));
        tag.put("fuel_storage_slots", (Tag)this.fuelStorageSlots.serializeNBT(registries));
        tag.put("fuel_return_slots", (Tag)this.fuelReturnSlots.serializeNBT(registries));
        tag.putIntArray("lit_time", this.litTime);
        tag.putIntArray("lit_duration", this.litDuration);
        tag.putIntArray("cook_time", this.cookTime);
        tag.putIntArray("cook_time_total", this.cookTimeTotal);
        tag.putString("pop_mode", this.popMode.name());
        tag.putString("receive_mode", this.receiveMode.name());
        tag.putString("sort_mode", this.sortMode.name());
    }

    public void setLit(boolean lit) {
        if (this.level == null || this.level.isClientSide()) {
            return;
        }
        BlockState state = this.getBlockState();
        if ((Boolean)state.getValue((Property)NetFurnaceBlock.LIT) != lit) {
            this.level.setBlock(this.worldPosition, (BlockState)state.setValue((Property)NetFurnaceBlock.LIT, (Comparable)Boolean.valueOf(lit)), 2);
            NetFurnaceBlockEntity.setChanged((Level)this.level, (BlockPos)this.worldPosition, (BlockState)state);
        }
    }

    public Component getDisplayName() {
        return Component.translatable((String)"menu.title.beyonddimensions.furnace_menu");
    }

    @Nullable
    public AbstractContainerMenu createMenu(int containerId, Inventory inventory, Player player) {
        return new NetFurnaceMenu(containerId, inventory, this);
    }
}

