/*
 * Decompiled with CFR 0.152.
 */
package com.wintercogs.beyonddimensions.Integration.Botania.Block;

import com.mojang.blaze3d.systems.RenderSystem;
import com.wintercogs.beyonddimensions.Api.DataBase.Storage.ManaUnifiedStorageHandler;
import com.wintercogs.beyonddimensions.Api.Util.CapCtx;
import com.wintercogs.beyonddimensions.BlockEntity.Custom.NetedBlockEntity;
import com.wintercogs.beyonddimensions.BlockEntity.ModBlockEntities;
import com.wintercogs.beyonddimensions.Unit.BDMath;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import org.apache.commons.lang3.mutable.MutableInt;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.UnknownNullability;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.BotaniaAPIClient;
import vazkii.botania.api.BotaniaForgeCapabilities;
import vazkii.botania.api.BotaniaForgeClientCapabilities;
import vazkii.botania.api.block.WandHUD;
import vazkii.botania.api.block.Wandable;
import vazkii.botania.api.internal.ManaBurst;
import vazkii.botania.api.internal.VanillaPacketDispatcher;
import vazkii.botania.api.mana.ManaBlockType;
import vazkii.botania.api.mana.ManaCollector;
import vazkii.botania.api.mana.ManaItem;
import vazkii.botania.api.mana.ManaNetworkAction;
import vazkii.botania.api.mana.ManaPool;
import vazkii.botania.api.mana.ManaReceiver;
import vazkii.botania.api.mana.spark.SparkAttachable;
import vazkii.botania.client.core.helper.RenderHelper;
import vazkii.botania.client.fx.WispParticleData;
import vazkii.botania.client.gui.HUDHandler;
import vazkii.botania.common.block.BotaniaBlocks;
import vazkii.botania.common.block.block_entity.mana.BellowsBlockEntity;
import vazkii.botania.common.handler.ManaNetworkHandler;
import vazkii.botania.common.item.BotaniaItems;
import vazkii.botania.common.item.ManaTabletItem;
import vazkii.botania.xplat.XplatAbstractions;

public class ManaPoolPathwayBlockEntity
extends NetedBlockEntity
implements ManaCollector,
ManaPool,
SparkAttachable,
Wandable {
    private ManaUnifiedStorageHandler handler = null;
    private boolean isOutPutting = true;
    private final Int2ObjectMap<MutableInt> chargingParticles = new Int2ObjectOpenHashMap();
    private final Int2ObjectMap<MutableInt> drainingParticles = new Int2ObjectOpenHashMap();
    private static final float CHARGING_GRAVITY = 0.003f;

    public ManaPoolPathwayBlockEntity(BlockPos pos, BlockState blockState) {
        super(ModBlockEntities.MANA_POOL_PATHWAY_BLOCK_ENTITY.get(), pos, blockState);
        this.refreshHandler();
    }

    public static void registerCapability(RegisterCapabilitiesEvent event) {
        event.registerBlockEntity(BotaniaForgeCapabilities.MANA_RECEIVER, ModBlockEntities.MANA_POOL_PATHWAY_BLOCK_ENTITY.get(), (be, side) -> {
            if (be instanceof ManaPoolPathwayBlockEntity) {
                ManaPoolPathwayBlockEntity pool = (ManaPoolPathwayBlockEntity)((Object)be);
                return pool;
            }
            return null;
        });
        event.registerBlockEntity(BotaniaForgeCapabilities.SPARK_ATTACHABLE, ModBlockEntities.MANA_POOL_PATHWAY_BLOCK_ENTITY.get(), (be, side) -> {
            if (be instanceof ManaPoolPathwayBlockEntity) {
                ManaPoolPathwayBlockEntity pool = (ManaPoolPathwayBlockEntity)((Object)be);
                return pool;
            }
            return null;
        });
        event.registerBlockEntity(BotaniaForgeClientCapabilities.BLOCK_WAND_HUD, ModBlockEntities.MANA_POOL_PATHWAY_BLOCK_ENTITY.get(), (be, side) -> {
            if (be instanceof ManaPoolPathwayBlockEntity) {
                ManaPoolPathwayBlockEntity pool = (ManaPoolPathwayBlockEntity)((Object)be);
                return new WandHud(pool);
            }
            return null;
        });
        event.registerBlockEntity(BotaniaForgeCapabilities.WANDABLE, ModBlockEntities.MANA_POOL_PATHWAY_BLOCK_ENTITY.get(), (be, side) -> {
            if (be instanceof ManaPoolPathwayBlockEntity) {
                ManaPoolPathwayBlockEntity pool = (ManaPoolPathwayBlockEntity)((Object)be);
                return pool;
            }
            return null;
        });
    }

    public static void clientTick(Level level, BlockPos pos, BlockState state, ManaPoolPathwayBlockEntity be) {
        double particleChance = 0.9;
        if (Math.random() > particleChance) {
            WispParticleData data = WispParticleData.wisp((float)((float)Math.random() / 3.0f), (float)0.0f, (float)0.7764706f, (float)1.0f, (float)2.0f);
            level.addParticle((ParticleOptions)data, (double)pos.getX() + 0.3 + Math.random() * 0.5, (double)pos.getY() + 0.6 + Math.random() * 0.25, (double)pos.getZ() + Math.random(), 0.0, (double)((float)Math.random() / 25.0f), 0.0);
        }
        ManaPoolPathwayBlockEntity.displayChargingParticles(level, pos, be, be.chargingParticles, true);
        ManaPoolPathwayBlockEntity.displayChargingParticles(level, pos, be, be.drainingParticles, false);
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, ManaPoolPathwayBlockEntity be) {
        be.initManaCapAndNetwork();
        List items = level.getEntitiesOfClass(ItemEntity.class, new AABB(pos));
        for (ItemEntity item : items) {
            int manaVal;
            if (!item.isAlive()) continue;
            ItemStack stack = item.getItem();
            ManaItem mana = XplatAbstractions.INSTANCE.findManaItem(stack);
            if (stack.isEmpty() || mana == null || (!be.isOutPutting || !mana.canReceiveManaFromPool((BlockEntity)be)) && (be.isOutPutting || !mana.canExportManaToPool((BlockEntity)be))) continue;
            int transfRate = Integer.MAX_VALUE;
            if (be.isOutPutting) {
                if (be.getCurrentMana() <= 0 || mana.getMana() >= mana.getMaxMana()) continue;
                manaVal = Math.min(transfRate, Math.min(be.getCurrentMana(), mana.getMaxMana() - mana.getMana()));
                mana.addMana(manaVal);
                be.receiveMana(-manaVal);
                continue;
            }
            if (mana.getMana() <= 0 || be.isFull()) continue;
            manaVal = Math.min(transfRate, Math.min(BDMath.clampLongToInt(be.getActualMaxMana() - be.getActualCurrentMana()), mana.getMana()));
            if (manaVal == 0 && be.level.getBlockState(pos.below()).is(BotaniaBlocks.manaVoid)) {
                manaVal = Math.min(transfRate, mana.getMana());
            }
            mana.addMana(-manaVal);
            be.receiveMana(manaVal);
        }
    }

    private static void displayChargingParticles(Level level, BlockPos worldPosition, ManaPoolPathwayBlockEntity be, Int2ObjectMap<MutableInt> particles, boolean charging) {
        int bellowCount = charging ? ManaPoolPathwayBlockEntity.getBellowCount(level, worldPosition, be) : 0;
        float relativeMana = (float)be.getCurrentMana() / (float)be.getMaxMana();
        ObjectIterator particlesIterator = particles.int2ObjectEntrySet().iterator();
        while (particlesIterator.hasNext()) {
            Int2ObjectMap.Entry entry = (Int2ObjectMap.Entry)particlesIterator.next();
            int ticksRemaining = ((MutableInt)entry.getValue()).decrementAndGet();
            if (ticksRemaining % 2 == 0) {
                int encodedPos = entry.getIntKey();
                Vec3 itemPosRelBase = ManaPoolPathwayBlockEntity.decodeRelativeItemPosition(encodedPos, relativeMana);
                if (charging) {
                    for (int i = 0; i <= bellowCount; ++i) {
                        Vec3 itemPosRel = ManaPoolPathwayBlockEntity.randomizeItemPos(itemPosRelBase);
                        Vec3 poolPosRel = new Vec3(0.1 + 0.8 * Math.random(), 0.1 + 0.4 * (double)relativeMana, 0.1 + 0.8 * Math.random());
                        ManaPoolPathwayBlockEntity.addManaFlowParticle(level, worldPosition, poolPosRel, itemPosRel);
                    }
                } else {
                    Vec3 itemPosRel = ManaPoolPathwayBlockEntity.randomizeItemPos(itemPosRelBase);
                    Vec3 poolPosRel = new Vec3(0.05 + 0.9 * Math.random(), 0.35 * (double)relativeMana, 0.05 + 0.9 * Math.random());
                    ManaPoolPathwayBlockEntity.addManaFlowParticle(level, worldPosition, itemPosRel, poolPosRel);
                }
            }
            if (ticksRemaining > 0) continue;
            particlesIterator.remove();
        }
    }

    private static int getBellowCount(Level level, BlockPos worldPosition, ManaPoolPathwayBlockEntity be) {
        int bellowCount = 0;
        for (Direction dir : Direction.Plane.HORIZONTAL) {
            BellowsBlockEntity bellows;
            BlockEntity tile = level.getBlockEntity(worldPosition.relative(dir));
            if (!(tile instanceof BellowsBlockEntity) || (bellows = (BellowsBlockEntity)tile).getLinkedTile() != be) continue;
            ++bellowCount;
        }
        return bellowCount;
    }

    private static Vec3 decodeRelativeItemPosition(int param, float relativeMana) {
        int compressedX = param & 7;
        int compressedY = param >> 3 & 3;
        int compressedZ = param >> 5 & 7;
        double relX = (double)compressedX / 7.0;
        double relY = 1.0 - 0.875 / (double)(1 << compressedY);
        double relZ = (double)compressedZ / 7.0;
        return new Vec3(relX, Math.max(relY, 0.5 * (double)relativeMana), relZ);
    }

    private static Vec3 randomizeItemPos(Vec3 itemPosRelBase) {
        return itemPosRelBase.add(0.1 * Math.random() - 0.05, 0.1 * Math.random() + 0.25, 0.1 * Math.random() - 0.05);
    }

    private static void addManaFlowParticle(Level level, BlockPos worldPosition, Vec3 startPos, Vec3 endPos) {
        double maxHeight = Math.max(startPos.y, endPos.y) - endPos.y + 0.05 * Math.random();
        Vec3 horizontalDiff = new Vec3(endPos.x - startPos.x, 0.0, endPos.z - startPos.z);
        double horizontalDistance = horizontalDiff.horizontalDistance();
        Vec3 horizontalDir = horizontalDiff.scale(1.0 / horizontalDistance);
        double startHeight = startPos.y - endPos.y;
        double vY0Squared = (double)0.006f * (maxHeight - startHeight);
        double vY0 = Math.sqrt(vY0Squared);
        double lifetime = (vY0 + Math.sqrt(vY0Squared + (double)0.006f * startHeight)) / (double)0.003f;
        double vX0 = horizontalDistance / lifetime;
        Vec3 v0 = horizontalDir.scale(vX0).with(Direction.Axis.Y, vY0);
        WispParticleData data = WispParticleData.wisp((float)0.1f, (float)0.0f, (float)0.7764706f, (float)1.0f, (float)((float)(0.025 * lifetime)), (float)0.003f).withNoClip(true);
        level.addParticle((ParticleOptions)data, (double)worldPosition.getX() + startPos.x, (double)worldPosition.getY() + startPos.y, (double)worldPosition.getZ() + startPos.z, v0.x, v0.y, v0.z);
    }

    private void initManaCapAndNetwork() {
        if (!ManaNetworkHandler.instance.isPoolIn(this.level, (ManaPool)this) && !this.isRemoved()) {
            BotaniaAPI.instance().getManaNetworkInstance().fireManaNetworkEvent((ManaReceiver)this, ManaBlockType.POOL, ManaNetworkAction.ADD);
        }
    }

    public boolean refreshHandler() {
        if (this.getNet() != null && this.handler != null && this.getNet().getUnifiedStorage() == this.handler.getStorage()) {
            return true;
        }
        if (this.getNet() != null) {
            this.handler = new ManaUnifiedStorageHandler(this.getNet().getUnifiedStorage(), new CapCtx(this.level, this.getBlockPos(), null, this));
            return true;
        }
        return false;
    }

    public long getActualCurrentMana() {
        if (this.refreshHandler()) {
            return this.handler.getActualCurrentMana();
        }
        return 0L;
    }

    public long getActualMaxMana() {
        if (this.refreshHandler()) {
            return this.handler.getActualMaxMana();
        }
        return 0L;
    }

    public void onClientDisplayTick() {
    }

    public float getManaYieldMultiplier(ManaBurst burst) {
        return 1.0f;
    }

    public boolean isOutputtingPower() {
        return this.isOutPutting;
    }

    public int getMaxMana() {
        if (this.refreshHandler()) {
            return this.handler.getMaxMana();
        }
        return 0;
    }

    public Optional<DyeColor> getColor() {
        return Optional.empty();
    }

    public void setColor(Optional<DyeColor> color) {
    }

    public @UnknownNullability Level getManaReceiverLevel() {
        return this.level;
    }

    public BlockPos getManaReceiverPos() {
        return this.getBlockPos();
    }

    public int getCurrentMana() {
        if (this.refreshHandler()) {
            return this.handler.getCurrentMana();
        }
        return 0;
    }

    public boolean isFull() {
        if (this.refreshHandler()) {
            return this.handler.isFull();
        }
        return true;
    }

    public void receiveMana(int mana) {
        if (this.refreshHandler()) {
            this.handler.receiveMana(mana);
        }
    }

    public boolean canReceiveManaFromBursts() {
        return true;
    }

    public boolean canAttachSpark(ItemStack stack) {
        if (this.refreshHandler()) {
            return this.handler.canAttachSpark(stack);
        }
        return false;
    }

    public int getAvailableSpaceForMana() {
        if (this.refreshHandler()) {
            return this.handler.getAvailableSpaceForMana();
        }
        return 0;
    }

    public boolean areIncomingTransfersDone() {
        if (this.refreshHandler()) {
            return this.handler.areIncomingTransfersDone();
        }
        return false;
    }

    public boolean onUsedByWand(@Nullable Player player, ItemStack stack, Direction side) {
        if (player == null || player.isShiftKeyDown() && !this.level.isClientSide()) {
            this.isOutPutting = !this.isOutPutting;
            VanillaPacketDispatcher.dispatchTEToNearbyPlayers((BlockEntity)this);
        }
        return true;
    }

    @Override
    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        tag.putBoolean("out_putting", this.isOutPutting);
    }

    @Override
    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.isOutPutting = tag.getBoolean("out_putting");
    }

    public void setRemoved() {
        super.setRemoved();
        BotaniaAPI.instance().getManaNetworkInstance().fireManaNetworkEvent((ManaReceiver)this, ManaBlockType.POOL, ManaNetworkAction.REMOVE);
    }

    public static class WandHud
    implements WandHUD {
        private final ManaPoolPathwayBlockEntity pool;

        public WandHud(ManaPoolPathwayBlockEntity pool) {
            this.pool = pool;
        }

        @OnlyIn(value=Dist.CLIENT)
        public void renderHUD(GuiGraphics gui, Minecraft mc) {
            ItemStack poolStack = new ItemStack((ItemLike)this.pool.getBlockState().getBlock());
            String name = poolStack.getHoverName().getString();
            int centerX = mc.getWindow().getGuiScaledWidth() / 2;
            int centerY = mc.getWindow().getGuiScaledHeight() / 2;
            int width = Math.max(102, mc.font.width(name)) + 4;
            RenderHelper.renderHUDBox((GuiGraphics)gui, (int)(centerX - width / 2), (int)(centerY + 8), (int)(centerX + width / 2), (int)(centerY + 48));
            BotaniaAPIClient.instance().drawSimpleManaHUD(gui, 38399, 1, 1, name);
            RenderSystem.enableBlend();
            RenderSystem.blendFunc((int)770, (int)771);
            int arrowU = this.pool.isOutPutting ? 22 : 0;
            int arrowV = 38;
            RenderHelper.drawTexturedModalRect((GuiGraphics)gui, (ResourceLocation)HUDHandler.manaBar, (int)(centerX - 11), (int)(centerY + 30), (int)arrowU, (int)arrowV, (int)22, (int)15);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            ItemStack tablet = new ItemStack((ItemLike)BotaniaItems.manaTablet);
            ManaTabletItem.setStackCreative((ItemStack)tablet);
            gui.renderItem(tablet, centerX - 31, centerY + 30);
            gui.renderItem(poolStack, centerX + 15, centerY + 30);
            RenderSystem.disableBlend();
        }
    }
}

