/*
 * Decompiled with CFR 0.152.
 */
package com.wintercogs.beyonddimensions.Item.Custom;

import com.wintercogs.beyonddimensions.Api.DataBase.DimensionsNet;
import com.wintercogs.beyonddimensions.Api.DataBase.Stack.FluidStackType;
import com.wintercogs.beyonddimensions.Api.DataBase.Stack.IStackType;
import com.wintercogs.beyonddimensions.Api.DataBase.Storage.UnifiedStorage;
import com.wintercogs.beyonddimensions.DataComponents.ModDataComponents;
import com.wintercogs.beyonddimensions.Fluid.ModFluids;
import com.wintercogs.beyonddimensions.Machine.XpTransferSpeedMode;
import com.wintercogs.beyonddimensions.Unit.BDMath;
import com.wintercogs.beyonddimensions.Unit.XpUtil;
import java.util.List;
import java.util.Locale;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.fluids.FluidStack;

public class XpExchangeItem
extends Item {
    public XpExchangeItem(Item.Properties properties) {
        super(properties.stacksTo(1).component(ModDataComponents.XP_TRANSFER_SPEED_MODE, (Object)XpTransferSpeedMode.SLOW));
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
        tooltipComponents.add((Component)Component.translatable((String)"tooltip.beyonddimensions.item.xp_exchange"));
    }

    public static int getConversionRate() {
        return 20;
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand usedHand) {
        super.use(level, player, usedHand);
        ItemStack itemstack = player.getItemInHand(usedHand);
        if (usedHand != InteractionHand.MAIN_HAND) {
            return InteractionResultHolder.fail((Object)itemstack);
        }
        if (level.isClientSide() && player.isShiftKeyDown()) {
            return InteractionResultHolder.fail((Object)itemstack);
        }
        if (!level.isClientSide()) {
            if (player.isShiftKeyDown()) {
                XpExchangeItem.cycleMode(itemstack, player, level);
            } else {
                DimensionsNet net = DimensionsNet.getNetFromPlayer(player);
                if (net != null) {
                    int conversionRate = XpExchangeItem.getConversionRate();
                    double currentLevel = XpUtil.levelAsDouble(player);
                    int wantConversionLevel = XpExchangeItem.getXpLevelPerAction(itemstack);
                    UnifiedStorage storage = net.getUnifiedStorage();
                    long needRemovePlayerXp = XpUtil.xpBetweenLevels(Math.max(currentLevel - (double)wantConversionLevel, 0.0), currentLevel);
                    int actualRemovePlayerXp = BDMath.clampLongToInt(needRemovePlayerXp);
                    long actualInsertFluid = (long)actualRemovePlayerXp * (long)conversionRate;
                    IStackType remaining = storage.insert(new FluidStackType(new FluidStack(ModFluids.XP_FLUID.source(), 1), actualInsertFluid), false);
                    if (!remaining.isEmpty()) {
                        int needReturnXp = BDMath.clampLongToInt(remaining.getStackAmount() / 20L);
                        actualRemovePlayerXp -= needReturnXp;
                    }
                    player.giveExperiencePoints(-actualRemovePlayerXp);
                }
            }
        }
        return InteractionResultHolder.sidedSuccess((Object)itemstack, (boolean)level.isClientSide());
    }

    public static int getXpLevelPerAction(ItemStack stack) {
        if (stack.getItem() instanceof XpExchangeItem) {
            XpTransferSpeedMode xpMode = (XpTransferSpeedMode)((Object)stack.getOrDefault(ModDataComponents.XP_TRANSFER_SPEED_MODE, (Object)XpTransferSpeedMode.SLOW));
            return switch (xpMode) {
                default -> throw new MatchException(null, null);
                case XpTransferSpeedMode.SLOW -> 1;
                case XpTransferSpeedMode.MID -> 10;
                case XpTransferSpeedMode.HIGH -> 30;
                case XpTransferSpeedMode.HIGHEST -> 100;
            };
        }
        return 0;
    }

    private static void cycleMode(ItemStack stack, Player player, Level level) {
        XpTransferSpeedMode cur = (XpTransferSpeedMode)((Object)stack.getOrDefault(ModDataComponents.XP_TRANSFER_SPEED_MODE, (Object)XpTransferSpeedMode.SLOW));
        XpTransferSpeedMode next = cur.next();
        stack.set(ModDataComponents.XP_TRANSFER_SPEED_MODE, (Object)next);
        player.sendSystemMessage((Component)Component.translatable((String)("msg.beyonddimensions.xp_mode.switch." + next.name().toLowerCase(Locale.ENGLISH))));
        level.playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.ENCHANTMENT_TABLE_USE, SoundSource.PLAYERS, 0.8f, 1.0f);
    }
}

