/*
 * Decompiled with CFR 0.152.
 */
package com.wintercogs.beyonddimensions.Api.DataBase.Stack;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.wintercogs.beyonddimensions.Api.DataBase.LongType.SourceType;
import com.wintercogs.beyonddimensions.Api.DataBase.Stack.IStackType;
import com.wintercogs.beyonddimensions.Api.DataBase.Stack.LongStackType;
import com.wintercogs.beyonddimensions.Render.IngredientRenderer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class SourceStackType
extends LongStackType<SourceType> {
    public static final ResourceLocation ID = ResourceLocation.m_214293_((String)"beyonddimensions", (String)"stack_type/source");
    public static final SourceStackType EMPTY = new SourceStackType();

    public SourceStackType() {
        this.stack = new SourceType(0L);
    }

    public SourceStackType(SourceType stack) {
        this.stack = stack;
    }

    public SourceStackType(long stackSize) {
        this.stack = new SourceType(stackSize);
    }

    @Override
    public ResourceLocation getTypeID() {
        return ID;
    }

    @Override
    public String getModId() {
        return "ars_nouveau";
    }

    @Override
    public IStackType<SourceType> fromObject(Object key, long amount, CompoundTag dataComponentPatch) {
        if (key instanceof SourceType) {
            return new SourceStackType(amount);
        }
        return null;
    }

    @Override
    public IStackType<SourceType> getEmpty() {
        return new SourceStackType();
    }

    @Override
    public Object getSource() {
        return new SourceType(0L);
    }

    @Override
    public SourceType getEmptyStack() {
        return new SourceType(0L);
    }

    @Override
    public IStackType<SourceType> copy() {
        SourceStackType copy = new SourceStackType(((SourceType)this.stack).getStackCount());
        copy.NeedRecalHash = this.NeedRecalHash;
        copy.hashCodeCache = this.hashCodeCache;
        return copy;
    }

    @Override
    public IStackType<SourceType> copyWithCount(long count) {
        SourceStackType copy = new SourceStackType(count);
        copy.NeedRecalHash = this.NeedRecalHash;
        copy.hashCodeCache = this.hashCodeCache;
        return copy;
    }

    @Override
    public IStackType<SourceType> split(long amount) {
        if (amount <= 0L) {
            return new SourceStackType();
        }
        long splitAmount = Math.min(amount, ((SourceType)this.stack).getStackCount());
        ((SourceType)this.stack).shrink(splitAmount);
        return new SourceStackType(splitAmount);
    }

    @Override
    public boolean hasTag(TagKey<?> tagKey) {
        return false;
    }

    @Override
    public long getVanillaMaxStackSize() {
        return 1000000L;
    }

    @Override
    public void serialize(FriendlyByteBuf buf) {
        buf.m_130085_(this.getTypeId());
        buf.m_130103_(((SourceType)this.stack).getStackCount());
    }

    @Override
    public IStackType<SourceType> deserialize(FriendlyByteBuf buf, ResourceLocation typeId) {
        if (!typeId.equals((Object)this.getTypeId())) {
            return null;
        }
        long count = buf.m_130258_();
        return new SourceStackType(count);
    }

    @Override
    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        tag.m_128359_("Type", ID.toString());
        tag.m_128356_("Amount", this.getStackAmount());
        return tag;
    }

    @Override
    public IStackType<SourceType> deserializeNBT(CompoundTag nbt) {
        return new SourceStackType(nbt.m_128454_("Amount"));
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void render(GuiGraphics gui, int x, int y) {
        if (((SourceType)this.stack).isEmpty()) {
            return;
        }
        PoseStack poseStack = gui.m_280168_();
        poseStack.m_85836_();
        int tintColor = -1;
        TextureAtlasSprite sprite = IngredientRenderer.ARS_SOURCE.m_119204_();
        IngredientRenderer.drawTiledSprite(gui, 16, 16, tintColor, 16L, sprite, x, y);
        poseStack.m_85849_();
        String countText = this.getCountText(this.getStackAmount());
        float scale = 0.666f;
        PoseStack poseStackText = gui.m_280168_();
        poseStackText.m_85836_();
        poseStackText.m_252880_(0.0f, 0.0f, 200.0f);
        poseStackText.m_85841_(scale, scale, scale);
        RenderSystem.disableBlend();
        int X = (int)(((float)(x + -1) + 16.0f + 2.0f - (float)Minecraft.m_91087_().f_91062_.m_92895_(countText) * 0.666f) * 1.0f / 0.666f);
        int Y = (int)(((float)(y + -1) + 16.0f - 3.33f) * 1.0f / 0.666f);
        if (!((SourceType)this.stack).isEmpty()) {
            gui.m_280488_(Minecraft.m_91087_().f_91062_, countText, X, Y, 0xFFFFFF);
        }
        poseStackText.m_85849_();
    }
}

