/*
 * Decompiled with CFR 0.152.
 */
package com.wintercogs.beyonddimensions.GUI.SharedWidget;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.logging.LogUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarratedElementType;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.slf4j.Logger;

@OnlyIn(value=Dist.CLIENT)
public class ScrollBar
extends AbstractWidget {
    private final Logger LOGGER = LogUtils.getLogger();
    protected ResourceLocation SPRITE;
    protected int maxScrollLength = 0;
    public int currentPosition = 0;
    public int maxPosition = 0;
    private double dragHold = 0.0;
    private boolean isDragging = false;
    private int startY;

    public ScrollBar(int x, int y, int width, int height, ResourceLocation sprite, int maxScrollLength, int currentPosition, int maxPosition, Component message) {
        super(x, y, width, height, message);
        this.SPRITE = sprite;
        this.maxScrollLength = maxScrollLength;
        this.currentPosition = currentPosition;
        this.maxPosition = maxPosition;
        this.startY = this.m_252907_();
    }

    public void updateScrollPosition(int currentPosition, int maxPosition) {
        this.currentPosition = currentPosition;
        this.maxPosition = maxPosition;
    }

    public int customDragAction(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (button != 0) {
            return 0;
        }
        if (this.maxPosition != 0 && this.isDragging) {
            this.dragHold += dragY;
            double scrollhold = (double)this.maxScrollLength / (double)this.maxPosition / 1.5;
            if (this.dragHold > scrollhold || this.dragHold < -scrollhold) {
                double drag = this.dragHold;
                this.dragHold = 0.0;
                if (drag > 0.0) {
                    return -1;
                }
                return 1;
            }
            return 0;
        }
        return 0;
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (this.f_93623_ && this.f_93624_) {
            boolean flag;
            if (this.m_7972_(button) && (flag = this.m_93680_(mouseX, mouseY))) {
                this.m_7435_(Minecraft.m_91087_().m_91106_());
                this.m_5716_(mouseX, mouseY);
                this.LOGGER.info("\u70b9\u51fb\u4e8b\u4ef6\u6355\u83b7");
                this.isDragging = true;
                return true;
            }
            return false;
        }
        return false;
    }

    public void m_7691_(double mouseX, double mouseY) {
        this.LOGGER.info("\u91ca\u653e\u4e8b\u4ef6\u6355\u83b7");
        this.isDragging = false;
    }

    protected void m_7212_(double mouseX, double mouseY, double dragX, double dragY) {
    }

    protected void m_87963_(GuiGraphics guiGraphics, int i, int i1, float v) {
        int scrollerOffset = this.maxPosition != 0 ? (int)((float)this.maxScrollLength * ((float)this.currentPosition / (float)this.maxPosition)) : 0;
        this.m_253211_(this.startY + scrollerOffset);
        guiGraphics.m_280246_(1.0f, 1.0f, 1.0f, this.f_93625_);
        RenderSystem.enableBlend();
        RenderSystem.enableDepthTest();
        guiGraphics.m_280163_(this.SPRITE, this.m_252754_(), this.m_252907_(), 0.0f, 0.0f, this.m_5711_(), this.m_93694_(), this.f_93618_, this.f_93619_);
        guiGraphics.m_280246_(1.0f, 1.0f, 1.0f, 1.0f);
    }

    protected void m_168797_(NarrationElementOutput narrationElementOutput) {
        narrationElementOutput.m_169146_(NarratedElementType.TITLE, (Component)this.m_5646_());
        if (this.f_93623_) {
            if (this.m_93696_()) {
                narrationElementOutput.m_169146_(NarratedElementType.USAGE, (Component)Component.m_237115_((String)"beyonddimensions.scrollbar.usage.focused"));
            } else {
                narrationElementOutput.m_169146_(NarratedElementType.USAGE, (Component)Component.m_237115_((String)"beyonddimensions.scrollbar.usage.hovered"));
            }
        }
    }
}

