/*
 * Decompiled with CFR 0.152.
 */
package com.wintercogs.beyonddimensions.Menu.Slot;

import com.wintercogs.beyonddimensions.Api.DataBase.Handler.IStackTypedHandler;
import com.wintercogs.beyonddimensions.Api.DataBase.Stack.FluidStackType;
import com.wintercogs.beyonddimensions.Api.DataBase.Stack.IStackType;
import com.wintercogs.beyonddimensions.Api.DataBase.Stack.ItemStackType;
import com.wintercogs.beyonddimensions.Api.DataBase.Stack.StackCreater;
import com.wintercogs.beyonddimensions.Api.DataBase.StackHandlerWrapper.IStackHandlerWrapper;
import com.wintercogs.beyonddimensions.Api.Registry.CapabilityHelper;
import com.wintercogs.beyonddimensions.Api.Registry.StackHandlerWrapperHelper;
import com.wintercogs.beyonddimensions.Fluid.ModFluids;
import com.wintercogs.beyonddimensions.Item.Custom.XpExchangeItem;
import com.wintercogs.beyonddimensions.Menu.BDBaseMenu;
import com.wintercogs.beyonddimensions.Menu.Slot.AbstractStackTypedSlot;
import com.wintercogs.beyonddimensions.Network.Packet.toClient.OrderedStackTypedSlotPacket;
import com.wintercogs.beyonddimensions.Registry.PacketRegister;
import java.util.function.Function;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.network.PacketDistributor;

public class FlagStackTypedSlot
extends AbstractStackTypedSlot {
    private IStackType lastStack = new ItemStackType();

    public FlagStackTypedSlot(BDBaseMenu menu, IStackTypedHandler storage, int slotIndex, int xPosition, int yPosition) {
        super(menu, storage, slotIndex, xPosition, yPosition);
        this.setFake(true);
    }

    @Override
    public boolean isOrdered() {
        return true;
    }

    @Override
    public void setStackDirectly(IStackType stack) {
        this.storage.setStackDirectly(this.theSlot, new ItemStackType());
        this.storage.insert(this.theSlot, stack, false);
    }

    @Override
    public IStackType safeInsert(IStackType stack) {
        if (stack != null) {
            this.setStackDirectly(stack);
        }
        return stack;
    }

    @Override
    public IStackType safeExtract(IStackType stack) {
        this.setStackDirectly(new ItemStackType());
        return stack;
    }

    @Override
    public void click(IStackType clickStack, int button, Player player) {
        ItemStack carriedItem = this.menu.m_142621_().m_41777_();
        if (clickStack.isEmpty()) {
            if (!carriedItem.m_41619_()) {
                if (button == 0) {
                    ItemStack copy = carriedItem.m_41777_();
                    copy.m_41764_(1);
                    this.setStackDirectly(new ItemStackType(copy));
                } else if (button == 1) {
                    if (carriedItem.m_41720_() instanceof XpExchangeItem) {
                        this.setStackDirectly(new FluidStackType(new FluidStack((Fluid)ModFluids.XP_FLUID.source().get(), 1), 1L));
                    } else {
                        ItemStack copy = carriedItem.m_41777_();
                        copy.m_41764_(1);
                        CapabilityHelper.ItemCapabilityMap.forEach((typeId, cap) -> {
                            Function<?, IStackHandlerWrapper<?>> handlerGetter;
                            IStackHandlerWrapper<?> stackHandlerWrapper;
                            LazyOptional handler = copy.getCapability(cap);
                            if (handler.isPresent() && (stackHandlerWrapper = (handlerGetter = StackHandlerWrapperHelper.stackWrappers.get(typeId)).apply(handler.resolve().get())).getSlots() > 0) {
                                for (int index = 0; index < stackHandlerWrapper.getSlots(); ++index) {
                                    IStackType<?> stack = StackCreater.Create(typeId, stackHandlerWrapper.getStackInSlot(0), 1L);
                                    if (stack == null || stack.isEmpty()) continue;
                                    this.setStackDirectly(stack);
                                    break;
                                }
                            }
                        });
                    }
                }
            }
        } else if (carriedItem.m_41619_()) {
            this.setStackDirectly(new ItemStackType());
        } else {
            this.setStackDirectly(new ItemStackType());
        }
    }

    @Override
    public void quickMove(IStackType clickStack, int button, Player player) {
        this.click(clickStack, button, player);
    }

    @Override
    public void updateChange() {
        IStackType currentStack = this.storage.getStackBySlot(this.getSlotIndex());
        if (currentStack == null) {
            this.lastStack = new ItemStackType();
            PacketRegister.INSTANCE.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)this.menu.player), (Object)new OrderedStackTypedSlotPacket(this.f_40219_, this.theSlot, this.lastStack, 0L));
        } else if (!(currentStack.isEmpty() && this.lastStack.isEmpty() || this.lastStack.getStackAmount() == currentStack.getStackAmount() && this.lastStack.getTypeId().equals((Object)currentStack.getTypeId()) && this.lastStack.isSameTypeSameComponents(currentStack))) {
            this.lastStack = currentStack;
            PacketRegister.INSTANCE.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)this.menu.player), (Object)new OrderedStackTypedSlotPacket(this.f_40219_, this.theSlot, this.lastStack, this.lastStack.getStackAmount()));
        }
    }

    @Override
    public void loadChange(int where, IStackType newStack, long newAmount) {
        this.storage.setStackDirectly(where, newStack);
    }
}

