/*
 * Decompiled with CFR 0.152.
 */
package com.wintercogs.beyonddimensions.Network.Packet.ClientOrServer;

import com.wintercogs.beyonddimensions.Menu.BDBaseMenu;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;

public record QuickDataTagPacket(CompoundTag tag) {
    private void handleServer(NetworkEvent.Context context) {
        ServerPlayer player = context.getSender();
        AbstractContainerMenu abstractContainerMenu = player.f_36096_;
        if (abstractContainerMenu instanceof BDBaseMenu) {
            BDBaseMenu menu = (BDBaseMenu)abstractContainerMenu;
            menu.readQuickDataTag(this.tag());
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void handleClient(NetworkEvent.Context context) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        AbstractContainerMenu abstractContainerMenu = player.f_36096_;
        if (abstractContainerMenu instanceof BDBaseMenu) {
            BDBaseMenu menu = (BDBaseMenu)abstractContainerMenu;
            menu.readQuickDataTag(this.tag());
        }
    }

    public static void handle(QuickDataTagPacket packet, Supplier<NetworkEvent.Context> cxt) {
        if (packet != null) {
            NetworkEvent.Context context = cxt.get();
            NetworkDirection direction = context.getDirection();
            if (direction == NetworkDirection.PLAY_TO_CLIENT) {
                context.enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> packet.handleClient(context)));
                context.setPacketHandled(true);
            } else if (direction == NetworkDirection.PLAY_TO_SERVER) {
                context.enqueueWork(() -> packet.handleServer(context));
                context.setPacketHandled(true);
            }
        }
    }

    public static void encode(QuickDataTagPacket packet, FriendlyByteBuf buf) {
        buf.m_130079_(packet.tag);
    }

    public static QuickDataTagPacket decode(FriendlyByteBuf buf) {
        CompoundTag tag = buf.m_130260_();
        return new QuickDataTagPacket(tag);
    }
}

