/*
 * Decompiled with CFR 0.152.
 */
package com.wintercogs.beyonddimensions.Integration.JEI;

import com.wintercogs.beyonddimensions.DataBase.Stack.IStackType;
import com.wintercogs.beyonddimensions.DataBase.Stack.ItemStackType;
import com.wintercogs.beyonddimensions.Menu.DimensionsCraftMenu;
import com.wintercogs.beyonddimensions.Network.Packet.toServer.RecipeFillC2SPacket;
import com.wintercogs.beyonddimensions.Registry.PacketRegister;
import com.wintercogs.beyonddimensions.Registry.UIRegister;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import mezz.jei.api.constants.RecipeTypes;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.ingredient.IRecipeSlotView;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.transfer.IRecipeTransferError;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandler;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;

public class RecipeTransferHandler
implements IRecipeTransferHandler<DimensionsCraftMenu, CraftingRecipe> {
    public Class<? extends DimensionsCraftMenu> getContainerClass() {
        return DimensionsCraftMenu.class;
    }

    public Optional<MenuType<DimensionsCraftMenu>> getMenuType() {
        return Optional.of(UIRegister.Dimensions_Craft_Menu.get());
    }

    public RecipeType<CraftingRecipe> getRecipeType() {
        return RecipeTypes.CRAFTING;
    }

    public IRecipeTransferError transferRecipe(DimensionsCraftMenu container, CraftingRecipe recipe, IRecipeSlotsView recipeSlots, Player player, boolean maxTransfer, boolean doTransfer) {
        boolean bl;
        ArrayList<Ingredient> ingredients = new ArrayList<Ingredient>();
        for (IRecipeSlotView slotView : recipeSlots.getSlotViews(RecipeIngredientRole.INPUT)) {
            if (slotView.getRole() != RecipeIngredientRole.INPUT) continue;
            Ingredient merged = Ingredient.m_43921_((Stream)slotView.getIngredients((IIngredientType)VanillaTypes.ITEM_STACK));
            ingredients.add(merged != null ? merged : Ingredient.f_43901_);
        }
        ArrayList<ItemStack> inputElements = new ArrayList<ItemStack>();
        List<Slot> craftingSlots = this.getInputSources(container);
        List<IStackType> storageSlots = container.storage.getStorage();
        ArrayList<ItemStack> availableItems = new ArrayList<ItemStack>();
        for (Slot slot : craftingSlots) {
            if (!slot.m_6657_()) continue;
            availableItems.add(slot.m_7993_().m_41777_());
        }
        for (IStackType iStackType : storageSlots) {
            ItemStackType itemStackType;
            ItemStack stack;
            if (!(iStackType instanceof ItemStackType) || (stack = (itemStackType = (ItemStackType)iStackType).getStack()).m_41619_()) continue;
            availableItems.add(stack.m_41777_());
        }
        ArrayList<ItemStack> virtualInventory = new ArrayList<ItemStack>();
        for (ItemStack stack : availableItems) {
            virtualInventory.add(stack.m_41777_());
        }
        boolean bl2 = true;
        block4: for (Ingredient ingredient : ingredients) {
            if (ingredient.m_43947_()) {
                inputElements.add(ItemStack.f_41583_);
                continue;
            }
            int required = 1;
            ArrayList<ItemStack> matching = new ArrayList<ItemStack>();
            for (ItemStack stack : virtualInventory) {
                if (stack.m_41619_() || !ingredient.test(stack)) continue;
                matching.add(stack);
            }
            int available = matching.stream().mapToInt(ItemStack::m_41613_).sum();
            if (available >= required) {
                ItemStack merged = matching.isEmpty() ? ItemStack.f_41583_ : new ItemStack((ItemLike)((ItemStack)matching.get(0)).m_41720_(), required);
                inputElements.add(merged);
                int remaining = required;
                for (ItemStack stack : matching) {
                    int deduct = Math.min(remaining, stack.m_41613_());
                    stack.m_41774_(deduct);
                    if ((remaining -= deduct) > 0) continue;
                    continue block4;
                }
                continue;
            }
            bl = false;
            break;
        }
        if (!bl) {
            if (doTransfer) {
                player.m_5661_((Component)Component.m_237115_((String)"beyonddimensions.message.insufficient_materials"), true);
            }
            return new IRecipeTransferError(){

                public IRecipeTransferError.Type getType() {
                    return IRecipeTransferError.Type.USER_FACING;
                }
            };
        }
        if (doTransfer) {
            PacketRegister.INSTANCE.sendToServer((Object)new RecipeFillC2SPacket(inputElements));
        }
        return null;
    }

    private List<Slot> getInputSources(DimensionsCraftMenu menu) {
        ArrayList<Slot> slots = new ArrayList<Slot>();
        for (int i = menu.craftSlotStartIndex; i < menu.craftSlotEndIndex; ++i) {
            slots.add(menu.m_38853_(i));
        }
        return slots;
    }
}

