/*
 * Decompiled with CFR 0.152.
 */
package com.wintercogs.beyonddimensions.Network.Packet.toClient;

import com.wintercogs.beyonddimensions.Menu.NetEnergyMenu;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;

public record EnergyStoragePacket(long energyStored, long energyCap) {
    @OnlyIn(value=Dist.CLIENT)
    private void handle(NetworkEvent.Context context) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        AbstractContainerMenu abstractContainerMenu = player.f_36096_;
        if (abstractContainerMenu instanceof NetEnergyMenu) {
            NetEnergyMenu menu = (NetEnergyMenu)abstractContainerMenu;
            menu.m_150444_();
            menu.loadStorage(this.energyCap(), this.energyStored());
            return;
        }
    }

    public static void handle(EnergyStoragePacket packet, Supplier<NetworkEvent.Context> cxt) {
        if (packet != null) {
            NetworkEvent.Context context = cxt.get();
            context.enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> packet.handle(context)));
            context.setPacketHandled(true);
        }
    }

    public static void encode(EnergyStoragePacket packet, FriendlyByteBuf buf) {
        buf.writeLong(packet.energyStored());
        buf.writeLong(packet.energyCap());
    }

    public static EnergyStoragePacket decode(FriendlyByteBuf buf) {
        long energyStored = buf.readLong();
        long energyCap = buf.readLong();
        return new EnergyStoragePacket(energyStored, energyCap);
    }
}

