/*
 * Decompiled with CFR 0.152.
 */
package com.wintercogs.beyonddimensions.Network.Packet.toServer;

import com.wintercogs.beyonddimensions.DataBase.Stack.IStackType;
import com.wintercogs.beyonddimensions.Menu.NetInterfaceBaseMenu;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraftforge.network.NetworkEvent;

public record FlagSlotSetPacket(int index, IStackType clickStack, IStackType flagStack) {
    private void handle(NetworkEvent.Context context) {
        ServerPlayer player = context.getSender();
        AbstractContainerMenu abstractContainerMenu = player.f_36096_;
        if (abstractContainerMenu instanceof NetInterfaceBaseMenu) {
            NetInterfaceBaseMenu menu = (NetInterfaceBaseMenu)abstractContainerMenu;
            menu.setFlagSlot(this.index(), this.clickStack(), this.flagStack());
            menu.m_38946_();
            return;
        }
    }

    public static void handle(FlagSlotSetPacket packet, Supplier<NetworkEvent.Context> cxt) {
        if (packet != null) {
            NetworkEvent.Context context = cxt.get();
            context.enqueueWork(() -> packet.handle(context));
            context.setPacketHandled(true);
        }
    }

    public static void encode(FlagSlotSetPacket packet, FriendlyByteBuf buf) {
        buf.writeInt(packet.index);
        IStackType clickType = packet.clickStack();
        clickType.serialize(buf);
        IStackType flagType = packet.flagStack();
        flagType.serialize(buf);
    }

    public static FlagSlotSetPacket decode(FriendlyByteBuf buf) {
        int slotIndex = buf.readInt();
        IStackType clickType = IStackType.deserializeCommon(buf);
        IStackType flagType = IStackType.deserializeCommon(buf);
        return new FlagSlotSetPacket(slotIndex, clickType, flagType);
    }
}

