/*
 * Decompiled with CFR 0.152.
 */
package com.wintercogs.beyonddimensions.Api.DataBase.Stack;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.wintercogs.beyonddimensions.Api.DataBase.Stack.IStackType;
import com.wintercogs.beyonddimensions.Render.IngredientRenderer;
import com.wintercogs.beyonddimensions.Unit.StringFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import mekanism.api.MekanismAPI;
import mekanism.api.chemical.Chemical;
import mekanism.api.chemical.ChemicalStack;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.ModList;
import net.neoforged.neoforge.client.ClientTooltipFlag;
import org.apache.commons.lang3.text.WordUtils;
import org.jetbrains.annotations.Nullable;

public final class ChemicalStackType
implements IStackType<ChemicalStack> {
    public static final ResourceLocation ID = ResourceLocation.fromNamespaceAndPath((String)"beyonddimensions", (String)"stack_type/chemical");
    private static final long CUSTOM_MAX_STACK_SIZE = Long.MAX_VALUE;
    public static final MapCodec<ChemicalStackType> TYPE_CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ChemicalStack.OPTIONAL_CODEC.fieldOf("internal_stack").forGetter(ChemicalStackType::getStack)).apply((Applicative)instance, ChemicalStackType::new));
    public static final Codec<ChemicalStackType> CODEC = TYPE_CODEC.codec();
    private ChemicalStack stack;
    private int hashCodeCache = 0;
    private boolean NeedRecalHash = true;

    public ChemicalStackType() {
        this.stack = ChemicalStack.EMPTY;
    }

    public ChemicalStackType(ChemicalStack stack) {
        this.stack = stack;
    }

    @Override
    public MapCodec<ChemicalStackType> codec() {
        return TYPE_CODEC;
    }

    @Override
    public IStackType<ChemicalStack> fromObject(Object key, long amount, DataComponentPatch dataComponentPatch) {
        if (key instanceof Chemical) {
            Chemical chemical = (Chemical)key;
            ChemicalStack chemicalStack = new ChemicalStack(chemical, amount);
            return new ChemicalStackType(chemicalStack);
        }
        return null;
    }

    @Override
    public ResourceLocation getTypeId() {
        return ID;
    }

    @Override
    public IStackType<ChemicalStack> getEmpty() {
        return new ChemicalStackType();
    }

    @Override
    public ChemicalStack getStack() {
        return this.stack;
    }

    @Override
    public void setStack(ChemicalStack stack) {
        this.stack = stack.copy();
        this.NeedRecalHash = true;
    }

    @Override
    public Class<ChemicalStack> getStackClass() {
        return ChemicalStack.class;
    }

    @Override
    public Class<?> getSourceClass() {
        return Chemical.class;
    }

    @Override
    public Object getSource() {
        return ChemicalStack.EMPTY.getChemical();
    }

    @Override
    public String getModId() {
        return MekanismAPI.CHEMICAL_REGISTRY.getKey((Object)this.stack.getChemical()).getNamespace();
    }

    @Override
    public boolean isEmpty() {
        return this.stack.isEmpty();
    }

    @Override
    public boolean isEmptyStack() {
        return this.stack.isEmpty();
    }

    @Override
    public ChemicalStack getEmptyStack() {
        return ChemicalStack.EMPTY;
    }

    @Override
    public ChemicalStack copyStack() {
        return this.stack.copy();
    }

    @Override
    public ChemicalStack copyStackWithCount(long count) {
        return this.stack.copyWithAmount(count);
    }

    @Override
    public IStackType<ChemicalStack> copy() {
        ChemicalStackType copy = new ChemicalStackType(this.stack.copy());
        copy.NeedRecalHash = this.NeedRecalHash;
        copy.hashCodeCache = this.hashCodeCache;
        return copy;
    }

    @Override
    public IStackType<ChemicalStack> copyWithCount(long count) {
        ChemicalStackType copy = new ChemicalStackType(this.stack.copyWithAmount(count));
        copy.NeedRecalHash = this.NeedRecalHash;
        copy.hashCodeCache = this.hashCodeCache;
        return copy;
    }

    @Override
    public long getStackAmount() {
        return this.stack.getAmount();
    }

    @Override
    public void setStackAmount(long amount) {
        this.stack.setAmount(amount);
    }

    @Override
    public void grow(long amount) {
        this.setStackAmount(this.getStackAmount() + amount);
    }

    @Override
    public void shrink(long amount) {
        this.grow(-amount);
    }

    @Override
    public long getVanillaMaxStackSize() {
        return 64000L;
    }

    @Override
    public long getCustomMaxStackSize() {
        return Long.MAX_VALUE;
    }

    @Override
    public ChemicalStack splitStack(long amount) {
        if (amount <= 0L) {
            return ChemicalStack.EMPTY;
        }
        long splitAmount = Math.min(amount, this.stack.getAmount());
        ChemicalStack split = this.stack.copy();
        split.setAmount(splitAmount);
        this.stack.shrink(splitAmount);
        return split;
    }

    @Override
    public IStackType<ChemicalStack> split(long amount) {
        if (amount <= 0L) {
            return new ChemicalStackType();
        }
        long splitAmount = Math.min(amount, this.stack.getAmount());
        ChemicalStack split = this.stack.copy();
        split.setAmount(splitAmount);
        this.stack.shrink(splitAmount);
        return new ChemicalStackType(split);
    }

    @Override
    public boolean isSame(IStackType<?> other) {
        if (!other.getTypeId().equals((Object)this.getTypeId())) {
            return false;
        }
        return ChemicalStack.isSameChemical((ChemicalStack)this.stack, (ChemicalStack)((ChemicalStack)other.getStack()));
    }

    @Override
    public boolean isSameTypeSameComponents(IStackType<?> other) {
        if (!other.getTypeId().equals((Object)this.getTypeId())) {
            return false;
        }
        return ChemicalStack.isSameChemical((ChemicalStack)this.stack, (ChemicalStack)((ChemicalStack)other.getStack()));
    }

    @Override
    public void serialize(RegistryFriendlyByteBuf buf) {
        buf.writeResourceLocation(this.getTypeId());
        boolean hasItem = !this.stack.isEmpty();
        buf.writeBoolean(hasItem);
        if (hasItem) {
            buf.writeVarLong(this.stack.getAmount());
            ChemicalStack copy = this.stack.copyWithAmount(1L);
            ChemicalStack.OPTIONAL_STREAM_CODEC.encode((Object)buf, (Object)copy);
        }
    }

    @Override
    public IStackType<ChemicalStack> deserialize(RegistryFriendlyByteBuf buf, ResourceLocation typeId) {
        if (!typeId.equals((Object)this.getTypeId())) {
            return null;
        }
        boolean hasItem = buf.readBoolean();
        if (!hasItem) {
            return new ChemicalStackType(ChemicalStack.EMPTY);
        }
        long count = buf.readVarLong();
        ChemicalStack stack = ((ChemicalStack)ChemicalStack.OPTIONAL_STREAM_CODEC.decode((Object)buf)).copyWithAmount(count);
        return new ChemicalStackType(stack);
    }

    @Override
    public CompoundTag serializeNBT(HolderLookup.Provider levelRegistryAccess) {
        CompoundTag tag = new CompoundTag();
        tag.putString("Type", ID.toString());
        tag.putLong("Amount", this.getStackAmount());
        tag.put("Stack", this.stack.copyWithAmount(1L).saveOptional(levelRegistryAccess));
        return tag;
    }

    @Override
    public IStackType<ChemicalStack> deserializeNBT(CompoundTag nbt, HolderLookup.Provider levelRegistryAccess) {
        ChemicalStackType stack = new ChemicalStackType(ChemicalStack.parseOptional((HolderLookup.Provider)levelRegistryAccess, (CompoundTag)nbt.getCompound("Stack")));
        stack.setStackAmount(nbt.getLong("Amount"));
        return stack;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void render(GuiGraphics gui, int x, int y) {
        ResourceLocation fluidStill;
        Optional<TextureAtlasSprite> fluidStillSprite;
        PoseStack poseStack = gui.pose();
        poseStack.pushPose();
        Chemical chemical = this.stack.getChemical();
        if (!chemical.isEmptyType() && (fluidStillSprite = Optional.ofNullable(fluidStill = chemical.getIcon()).map(f -> (TextureAtlasSprite)Minecraft.getInstance().getTextureAtlas(InventoryMenu.BLOCK_ATLAS).apply(f)).filter(s -> s.atlasLocation() != MissingTextureAtlasSprite.getLocation())).isPresent()) {
            int fluidColor = chemical.getTint();
            IngredientRenderer.drawTiledSprite(gui, 16, 16, fluidColor, 16L, fluidStillSprite.get(), x, y);
        }
        poseStack.popPose();
        String countText = this.getCountText(this.stack.getAmount());
        float scale = 0.666f;
        PoseStack poseStackText = gui.pose();
        poseStackText.pushPose();
        poseStackText.translate(0.0f, 0.0f, 200.0f);
        poseStackText.scale(scale, scale, scale);
        RenderSystem.disableBlend();
        int X = (int)(((float)(x + -1) + 16.0f + 2.0f - (float)Minecraft.getInstance().font.width(countText) * 0.666f) * 1.0f / 0.666f);
        int Y = (int)(((float)(y + -1) + 16.0f - 3.33f) * 1.0f / 0.666f);
        gui.drawString(Minecraft.getInstance().font, countText, X, Y, 0xFFFFFF);
        poseStackText.popPose();
    }

    @Override
    public String getCountText(long count) {
        if (count <= 0L) {
            return "";
        }
        return StringFormat.formatBucket(count);
    }

    @Override
    public Component getDisplayName() {
        return this.stack.getTextComponent();
    }

    @Override
    public List<Component> getTooltipLines(Item.TooltipContext tooltipContext, @Nullable Player player, TooltipFlag tooltipFlag) {
        if (this.stack.isEmpty()) {
            return List.of(Component.empty());
        }
        ArrayList<Component> tooltips = new ArrayList<Component>();
        Chemical chemical = this.stack.getChemical();
        Component displayName = this.getDisplayName();
        tooltips.add(displayName);
        ResourceLocation resourceLocation = MekanismAPI.CHEMICAL_REGISTRY.getKey((Object)chemical);
        if (resourceLocation != null) {
            Optional container;
            if (tooltipFlag.isAdvanced()) {
                MutableComponent advancedId = Component.literal((String)resourceLocation.toString()).withStyle(ChatFormatting.DARK_GRAY);
                tooltips.add((Component)advancedId);
            }
            MutableComponent modName = (container = ModList.get().getModContainerById(resourceLocation.getNamespace())).isPresent() ? Component.literal((String)((ModContainer)container.get()).getModInfo().getDisplayName()).withStyle(ChatFormatting.BLUE).withStyle(ChatFormatting.ITALIC) : ((container = ModList.get().getModContainerById(resourceLocation.getNamespace().replace('_', '-'))).isPresent() ? Component.literal((String)((ModContainer)container.get()).getModInfo().getDisplayName()).withStyle(ChatFormatting.BLUE).withStyle(ChatFormatting.ITALIC) : Component.literal((String)WordUtils.capitalizeFully((String)resourceLocation.getNamespace().replace('_', ' '))).withStyle(ChatFormatting.BLUE).withStyle(ChatFormatting.ITALIC));
            tooltips.add((Component)modName);
        }
        tooltips.add((Component)Component.translatable((String)"istack.beyonddimensions.storage_num.fluid", (Object[])new Object[]{this.getStackAmount()}));
        return tooltips;
    }

    @Override
    public Optional<TooltipComponent> getTooltipImage() {
        return Optional.empty();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void renderTooltip(GuiGraphics gui, Font font, int mouseX, int mouseY) {
        Minecraft minecraft = Minecraft.getInstance();
        gui.renderTooltip(minecraft.font, this.getTooltipLines(Item.TooltipContext.of((Level)minecraft.level), (Player)minecraft.player, ClientTooltipFlag.of((TooltipFlag)(minecraft.options.advancedItemTooltips ? TooltipFlag.Default.ADVANCED : TooltipFlag.Default.NORMAL))), this.getTooltipImage(), ItemStack.EMPTY, mouseX, mouseY);
    }

    public boolean equals(Object other) {
        if (other instanceof ChemicalStackType) {
            ChemicalStackType otherStack = (ChemicalStackType)other;
            return this.isSameTypeSameComponents(otherStack);
        }
        return false;
    }

    public int hashCode() {
        if (this.NeedRecalHash) {
            int code = 1;
            this.hashCodeCache = code = 31 * code + this.stack.getChemical().hashCode();
            this.NeedRecalHash = false;
        }
        return this.hashCodeCache;
    }
}

