/*
 * Decompiled with CFR 0.152.
 */
package com.wintercogs.beyonddimensions.Api.DataBase.Stack;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.wintercogs.beyonddimensions.Api.DataBase.LongType.LongType;
import com.wintercogs.beyonddimensions.Api.DataBase.Stack.IStackType;
import com.wintercogs.beyonddimensions.Render.IngredientRenderer;
import com.wintercogs.beyonddimensions.Unit.BDMath;
import com.wintercogs.beyonddimensions.Unit.StringFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.client.ClientTooltipFlag;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;
import org.apache.commons.lang3.text.WordUtils;
import org.jetbrains.annotations.Nullable;

public abstract class LongStackType<T extends LongType<T>>
implements IStackType<T> {
    private static final long CUSTOM_MAX_STACK_SIZE = Long.MAX_VALUE;
    protected T stack;
    protected int hashCodeCache = 0;
    protected boolean NeedRecalHash = true;

    public abstract ResourceLocation getTypeID();

    @Override
    public ResourceLocation getTypeId() {
        return this.getTypeID();
    }

    @Override
    public T getStack() {
        return this.stack;
    }

    @Override
    public void setStack(T stack) {
        this.stack = ((LongType)stack).copy();
        this.NeedRecalHash = true;
    }

    @Override
    public Class<T> getStackClass() {
        return this.stack.getClass();
    }

    @Override
    public Class<?> getSourceClass() {
        return this.stack.getClass();
    }

    @Override
    public String getModId() {
        return "beyonddimensions";
    }

    @Override
    public boolean isEmpty() {
        return ((LongType)this.stack).isEmpty();
    }

    @Override
    public boolean isEmptyStack() {
        return ((LongType)this.stack).isEmpty();
    }

    @Override
    public T copyStack() {
        return (T)((LongType)this.stack).copy();
    }

    @Override
    public T copyStackWithCount(long count) {
        return (T)((LongType)this.stack).copyWithAmount(count);
    }

    @Override
    public long getStackAmount() {
        return ((LongType)this.stack).getStackCount();
    }

    @Override
    public void setStackAmount(long amount) {
        ((LongType)this.stack).setStackCount(amount);
    }

    @Override
    public void grow(long amount) {
        ((LongType)this.stack).grow(amount);
    }

    @Override
    public void shrink(long amount) {
        ((LongType)this.stack).shrink(amount);
    }

    @Override
    public long getVanillaMaxStackSize() {
        return Long.MAX_VALUE;
    }

    @Override
    public long getCustomMaxStackSize() {
        return Long.MAX_VALUE;
    }

    @Override
    public T splitStack(long amount) {
        if (amount <= 0L) {
            return (T)((LongType)this.stack).getEmpty();
        }
        int splitAmount = BDMath.clampLongToInt(Math.min(amount, ((LongType)this.stack).getStackCount()));
        LongType split = ((LongType)this.stack).copy();
        split.setStackCount(splitAmount);
        this.shrink(splitAmount);
        return (T)split;
    }

    @Override
    public boolean isSame(IStackType<?> other) {
        if (!other.getTypeId().equals((Object)this.getTypeId())) {
            return false;
        }
        return ((LongType)this.stack).isSame((LongType)other.getStack());
    }

    @Override
    public boolean isSameTypeSameComponents(IStackType<?> other) {
        if (!other.getTypeId().equals((Object)this.getTypeId())) {
            return false;
        }
        return ((LongType)this.stack).isSame((LongType)other.getStack());
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void render(GuiGraphics gui, int x, int y) {
        IClientFluidTypeExtensions renderProperties;
        ResourceLocation fluidStill;
        Optional<TextureAtlasSprite> fluidStillSprite;
        if (((LongType)this.stack).isEmpty()) {
            return;
        }
        PoseStack poseStack = gui.pose();
        poseStack.pushPose();
        FlowingFluid fluid = Fluids.WATER;
        if (!fluid.isSame(Fluids.EMPTY) && (fluidStillSprite = Optional.ofNullable(fluidStill = (renderProperties = IClientFluidTypeExtensions.of((Fluid)fluid)).getStillTexture()).map(f -> (TextureAtlasSprite)Minecraft.getInstance().getTextureAtlas(InventoryMenu.BLOCK_ATLAS).apply(f)).filter(s -> s.atlasLocation() != MissingTextureAtlasSprite.getLocation())).isPresent()) {
            int fluidColor = -16711936;
            IngredientRenderer.drawTiledSprite(gui, 16, 16, fluidColor, 16L, fluidStillSprite.get(), x, y);
        }
        poseStack.popPose();
        String countText = this.getCountText(this.getStackAmount());
        float scale = 0.666f;
        PoseStack poseStackText = gui.pose();
        poseStackText.pushPose();
        poseStackText.translate(0.0f, 0.0f, 200.0f);
        poseStackText.scale(scale, scale, scale);
        RenderSystem.disableBlend();
        int X = (int)(((float)(x + -1) + 16.0f + 2.0f - (float)Minecraft.getInstance().font.width(countText) * 0.666f) * 1.0f / 0.666f);
        int Y = (int)(((float)(y + -1) + 16.0f - 3.33f) * 1.0f / 0.666f);
        if (!((LongType)this.stack).isEmpty()) {
            gui.drawString(Minecraft.getInstance().font, countText, X, Y, 0xFFFFFF);
        }
        poseStackText.popPose();
    }

    @Override
    public String getCountText(long count) {
        if (count < 0L) {
            return "";
        }
        return StringFormat.formatCount(count);
    }

    @Override
    public Component getDisplayName() {
        return ((LongType)this.stack).getName();
    }

    @Override
    public List<Component> getTooltipLines(Item.TooltipContext tooltipContext, @Nullable Player player, TooltipFlag tooltipFlag) {
        if (((LongType)this.stack).isEmpty()) {
            return List.of(Component.empty());
        }
        ArrayList<Component> tooltips = new ArrayList<Component>();
        Component displayName = this.getDisplayName();
        tooltips.add(displayName);
        MutableComponent modName = Component.literal((String)WordUtils.capitalizeFully((String)"beyonddimensions".replace('_', ' '))).withStyle(ChatFormatting.BLUE).withStyle(ChatFormatting.ITALIC);
        tooltips.add((Component)modName);
        tooltips.add((Component)Component.translatable((String)"istack.beyonddimensions.storage_num.long_type", (Object[])new Object[]{this.getStackAmount()}));
        return tooltips;
    }

    @Override
    public Optional<TooltipComponent> getTooltipImage() {
        return Optional.empty();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void renderTooltip(GuiGraphics gui, Font font, int mouseX, int mouseY) {
        Minecraft minecraft = Minecraft.getInstance();
        gui.renderTooltip(minecraft.font, this.getTooltipLines(Item.TooltipContext.of((Level)minecraft.level), (Player)minecraft.player, ClientTooltipFlag.of((TooltipFlag)(minecraft.options.advancedItemTooltips ? TooltipFlag.Default.ADVANCED : TooltipFlag.Default.NORMAL))), this.getTooltipImage(), ItemStack.EMPTY, mouseX, mouseY);
    }

    public boolean equals(Object other) {
        if (other instanceof LongStackType) {
            LongStackType otherStack = (LongStackType)other;
            return this.isSameTypeSameComponents(otherStack);
        }
        return false;
    }

    public int hashCode() {
        if (this.NeedRecalHash) {
            this.hashCodeCache = ((LongType)this.stack).hashCode();
            this.NeedRecalHash = false;
        }
        return this.hashCodeCache;
    }
}

