/*
 * Decompiled with CFR 0.152.
 */
package com.wintercogs.beyonddimensions.Api.DataBase.Storage;

import com.wintercogs.beyonddimensions.Api.DataBase.DimensionsNet;
import com.wintercogs.beyonddimensions.Api.DataBase.Handler.IStackTypedHandler;
import com.wintercogs.beyonddimensions.Api.DataBase.Stack.EnergyStackType;
import com.wintercogs.beyonddimensions.Api.DataBase.Stack.IStackType;
import com.wintercogs.beyonddimensions.Api.DataBase.Stack.ItemStackType;
import com.wintercogs.beyonddimensions.Api.DataBase.Stack.StackCreater;
import com.wintercogs.beyonddimensions.Api.Registry.StackTypeRegistry;
import com.wintercogs.beyonddimensions.Api.Util.HashBPlusList;
import com.wintercogs.beyonddimensions.BeyondDimensions;
import com.wintercogs.beyonddimensions.DataComponents.ModDataComponents;
import com.wintercogs.beyonddimensions.Item.Custom.MatterCompressionBall;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;

public class UnifiedStorage
implements IStackTypedHandler {
    private DimensionsNet net;
    private final HashBPlusList<IStackType> storage = new HashBPlusList(64, 128);
    private HashBPlusList<IStackType> backupStorage = new HashBPlusList(64, 128);
    private final Map<ResourceLocation, List<Integer>> typeIdIndex = new HashMap<ResourceLocation, List<Integer>>();
    public static final Map<ResourceLocation, Function<UnifiedStorage, Object>> typedHandlerMap = new HashMap<ResourceLocation, Function<UnifiedStorage, Object>>();
    public long slotCapacity = Long.MAX_VALUE;
    public int slotMaxSize = Integer.MAX_VALUE;

    public UnifiedStorage(DimensionsNet net) {
        this.net = net;
    }

    @Override
    public void onChange() {
        this.net.setDirty();
    }

    @Override
    public Object getTypedHandler(ResourceLocation typeId) {
        return typedHandlerMap.get(typeId).apply(this);
    }

    @Override
    public int getSlots() {
        return this.storage.size();
    }

    @Override
    public IStackType getStackBySlot(int slot) {
        return IStackTypedHandler.super.getStackBySlot(slot);
    }

    @Override
    public List<IStackType> getStorage() {
        return Collections.unmodifiableList(this.storage);
    }

    @Override
    public void clearStorage() {
        this.storage.clear();
        this.typeIdIndex.clear();
        this.onChange();
    }

    @Override
    public boolean hasStackType(IStackType other) {
        return this.storage.contains(other);
    }

    @Override
    public void setStackDirectly(int slot, IStackType stack) {
        if (!this.storage.contains(stack)) {
            ResourceLocation newTypeId = stack.getTypeId();
            ResourceLocation oldTypeId = this.getStorage().get(slot).getTypeId();
            this.storage.set(slot, stack.copy());
            this.typeIdIndex.computeIfAbsent(oldTypeId, k -> new ArrayList()).remove((Object)slot);
            this.typeIdIndex.computeIfAbsent(newTypeId, k -> new ArrayList()).add(slot);
            this.onChange();
        }
    }

    @Override
    public void addStackDirectly(IStackType stack) {
        if (!this.storage.contains(stack)) {
            ResourceLocation newTypeId = stack.getTypeId();
            int slot = this.storage.size();
            this.storage.add(stack.copy());
            this.typeIdIndex.computeIfAbsent(newTypeId, k -> new ArrayList()).add(slot);
            this.onChange();
        }
    }

    @Override
    public IStackType getStackByStack(IStackType stackType) {
        return this.storage.get(stackType);
    }

    @Override
    public long getSlotCapacity(int slot) {
        if (this.net.deleted) {
            return 0L;
        }
        return this.slotCapacity;
    }

    @Override
    public boolean isStackValid(int slot, IStackType stack) {
        return true;
    }

    @Override
    public boolean isEmpty() {
        return this.storage.isEmpty();
    }

    @Override
    public IStackType insert(int slot, IStackType stack, boolean simulate) {
        return this.insert(stack, simulate);
    }

    @Override
    public IStackType insert(IStackType stack, boolean simulate) {
        ItemStackType itemStackType;
        if (stack.isEmpty()) {
            return StackCreater.CreateEmpty(stack.getTypeId());
        }
        if (stack instanceof ItemStackType && (itemStackType = (ItemStackType)stack).getStack().getItem() instanceof MatterCompressionBall) {
            return this.unzipMatterBall(itemStackType, simulate);
        }
        long remaining = stack.getStackAmount();
        long canInsert = Math.min(this.getSlotCapacity(0), stack.getCustomMaxStackSize());
        if (this.storage.contains(stack)) {
            IStackType existing = this.storage.get(stack);
            long actualInsert = Math.min(remaining, canInsert -= existing.getStackAmount());
            remaining -= actualInsert;
            if (!simulate) {
                existing.grow(actualInsert);
                this.onChange();
            }
            return stack.copyWithCount(remaining);
        }
        if (this.storage.size() < this.slotMaxSize) {
            long actualInsert = Math.min(remaining, canInsert);
            remaining -= actualInsert;
            if (!simulate) {
                IStackType newStack = stack.copyWithCount(actualInsert);
                this.storage.add(newStack);
                int newIndex = this.storage.size() - 1;
                this.typeIdIndex.computeIfAbsent(stack.getTypeId(), k -> new ArrayList()).add(newIndex);
                this.onChange();
            }
        }
        return stack.copyWithCount(remaining);
    }

    protected IStackType unzipMatterBall(ItemStackType stack, boolean simulate) {
        ItemStack ballStack = stack.copyStack();
        if (!(stack.getStack().getItem() instanceof MatterCompressionBall)) {
            return stack;
        }
        if (ballStack.has(ModDataComponents.ISTACK_SLOTS)) {
            long ballNum = stack.getStackAmount();
            ArrayList<IStackType> newBallStorage = new ArrayList<IStackType>();
            List ballStorage = (List)ballStack.get(ModDataComponents.ISTACK_SLOTS);
            for (IStackType stackType : ballStorage) {
                stackType.setStackAmount(stackType.getStackAmount() * ballNum);
                newBallStorage.add(this.insert(stackType, true));
            }
            boolean newBallStorageIsEmpty = true;
            for (IStackType stackType : newBallStorage) {
                if (stackType.isEmpty()) continue;
                newBallStorageIsEmpty = false;
            }
            if (newBallStorageIsEmpty) {
                if (simulate) {
                    return new ItemStackType();
                }
                for (IStackType stackType : ballStorage) {
                    stackType.setStackAmount(stackType.getStackAmount() * ballNum);
                    this.insert(stackType, false);
                }
                return new ItemStackType();
            }
            return stack;
        }
        return new ItemStackType();
    }

    @Override
    public IStackType extract(IStackType stack, boolean simulate) {
        if (stack.isEmpty()) {
            return stack.getEmpty();
        }
        List<Integer> indices = this.typeIdIndex.get(stack.getTypeId());
        if (this.storage.contains(stack)) {
            int storageIndex = this.storage.indexOf(stack);
            IStackType existing = this.storage.get(stack);
            long extracted = Math.min(stack.getStackAmount(), existing.getStackAmount());
            IStackType sim = existing.copy();
            IStackType result = sim.split(extracted);
            if (!simulate) {
                existing.shrink(extracted);
                if (existing.getStackAmount() <= 0L) {
                    this.storage.remove(storageIndex);
                    indices.remove((Object)storageIndex);
                    this.updateIndicesAfterRemoval(storageIndex);
                    if (indices.isEmpty()) {
                        this.typeIdIndex.remove(stack.getTypeId());
                    }
                }
                this.onChange();
            }
            return result;
        }
        return stack.getEmpty();
    }

    private void updateIndicesAfterRemoval(int removedIndex) {
        for (List<Integer> indexList : this.typeIdIndex.values()) {
            for (int i = 0; i < indexList.size(); ++i) {
                int currentIndex = indexList.get(i);
                if (currentIndex <= removedIndex) continue;
                indexList.set(i, currentIndex - 1);
            }
        }
    }

    public void rebuildAllIndices() {
        this.typeIdIndex.clear();
        for (int i = 0; i < this.storage.size(); ++i) {
            IStackType stack = this.storage.get((IStackType)i);
            if (stack == null || stack.isEmpty()) continue;
            ResourceLocation typeId = stack.getTypeId();
            this.typeIdIndex.computeIfAbsent(typeId, k -> new ArrayList()).add(i);
        }
    }

    @Override
    public IStackType extract(int slot, long amount, boolean simulate) {
        if (slot < 0 || slot >= this.storage.size()) {
            return null;
        }
        IStackType existing = this.storage.get((IStackType)slot);
        if (existing.isEmpty()) {
            return existing.getEmpty();
        }
        long extracted = Math.min(amount, existing.getStackAmount());
        IStackType sim = existing.copy();
        IStackType result = sim.split(extracted);
        if (!simulate) {
            existing.shrink(extracted);
            if (existing.getStackAmount() <= 0L) {
                ResourceLocation typeId = existing.getTypeId();
                this.storage.remove(slot);
                List<Integer> indices = this.typeIdIndex.get(typeId);
                if (indices != null) {
                    indices.remove((Object)slot);
                    if (indices.isEmpty()) {
                        this.typeIdIndex.remove(typeId);
                    }
                }
                this.updateIndicesAfterRemoval(slot);
                this.onChange();
            }
        }
        return result;
    }

    public CompoundTag serializeNBT(HolderLookup.Provider provider) {
        try {
            CompoundTag tag = new CompoundTag();
            tag.putLong("slotCapacity", this.slotCapacity);
            tag.putInt("slotMaxSize", this.slotMaxSize);
            ListTag stacksTag = new ListTag();
            for (IStackType stack : this.storage) {
                if (stack.isEmpty()) continue;
                CompoundTag stackTag = new CompoundTag();
                stackTag.put("TypedStack", (Tag)stack.serializeNBT(provider));
                stackTag.putString("Type", stack.getTypeId().toString());
                stacksTag.add((Object)stackTag);
            }
            tag.put("Stacks", (Tag)stacksTag);
            this.backupStorage = UnifiedStorage.deepClone(this.storage);
            return tag;
        }
        catch (Exception ex) {
            BeyondDimensions.LOGGER.error("{}\u53f7\u7ef4\u5ea6\u7f51\u7edc\u4fdd\u5b58\u5931\u8d25\uff0c\u5c1d\u8bd5\u4f7f\u7528\u6700\u8fd1\u7684\u5907\u4efd\u5e76\u6253\u5370\u9519\u8bef\u4fe1\u606f", (Object)this.net.getId(), (Object)ex);
            this.storage.clear();
            if (this.backupStorage != null) {
                for (IStackType s : this.backupStorage) {
                    this.storage.add(s.copy());
                }
            }
            CompoundTag tag = new CompoundTag();
            tag.putLong("slotCapacity", this.slotCapacity);
            tag.putInt("slotMaxSize", this.slotMaxSize);
            ListTag stacksTag = new ListTag();
            for (IStackType stack : this.storage) {
                if (stack.isEmpty()) continue;
                CompoundTag stackTag = new CompoundTag();
                stackTag.put("TypedStack", (Tag)stack.serializeNBT(provider));
                stackTag.putString("Type", stack.getTypeId().toString());
                stacksTag.add((Object)stackTag);
            }
            tag.put("Stacks", (Tag)stacksTag);
            return tag;
        }
    }

    public void deserializeNBT(HolderLookup.Provider provider, CompoundTag tag) {
        this.storage.clear();
        this.typeIdIndex.clear();
        this.slotCapacity = tag.contains("slotCapacity") ? tag.getLong("slotCapacity") : Long.MAX_VALUE;
        this.slotMaxSize = tag.contains("slotMaxSize") ? tag.getInt("slotMaxSize") : Integer.MAX_VALUE;
        ListTag stacksTag = tag.getList("Stacks", 10);
        for (Tag t : stacksTag) {
            CompoundTag stackTag = (CompoundTag)t;
            ResourceLocation typeId = ResourceLocation.parse((String)stackTag.getString("Type"));
            IStackType stackEmpty = StackTypeRegistry.getType(typeId).copy();
            IStackType stackActual = stackEmpty.deserializeNBT(stackTag.getCompound("TypedStack"), provider);
            if (stackActual.isEmpty()) continue;
            this.insert(stackActual, false);
        }
        this.backupStorage = UnifiedStorage.deepClone(this.storage);
    }

    public Map<ResourceLocation, List<Integer>> getTypeIdIndexMap() {
        return this.typeIdIndex;
    }

    public Optional<List<Integer>> getTypeIdIndexList(ResourceLocation typeId) {
        return Optional.ofNullable(this.typeIdIndex.get(typeId)).filter(list -> !list.isEmpty());
    }

    public long getEnergyStored() {
        IStackType stack = this.getStackByStack(EnergyStackType.EMPTY);
        if (stack != null) {
            return stack.getStackAmount();
        }
        return 0L;
    }

    public boolean isFullSlotsSize() {
        return this.storage.size() >= this.slotMaxSize;
    }

    public void setSlotCapacity(long capacity) {
        this.slotCapacity = capacity;
    }

    public void setSlotMaxSize(int maxSize) {
        this.slotMaxSize = maxSize;
    }

    private static HashBPlusList<IStackType> deepClone(HashBPlusList<IStackType> origin) {
        HashBPlusList<IStackType> clone = new HashBPlusList<IStackType>(64, 128);
        for (IStackType s : origin) {
            clone.add(s.copy());
        }
        return clone;
    }
}

