/*
 * Decompiled with CFR 0.152.
 */
package com.wintercogs.beyonddimensions.BlockEntity.Custom;

import com.wintercogs.beyonddimensions.Api.DataBase.DimensionsNet;
import com.wintercogs.beyonddimensions.Api.DataBase.Stack.EnergyStackType;
import com.wintercogs.beyonddimensions.Api.DataBase.Storage.EnergyUnifiedStorageHandler;
import com.wintercogs.beyonddimensions.BlockEntity.Custom.BaseMachineBlockEntity;
import com.wintercogs.beyonddimensions.BlockEntity.Custom.NetedBlockEntity;
import com.wintercogs.beyonddimensions.BlockEntity.ModBlockEntities;
import com.wintercogs.beyonddimensions.Machine.PopMode;
import com.wintercogs.beyonddimensions.Menu.NetEnergyMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.energy.EnergyStorage;
import net.neoforged.neoforge.energy.IEnergyStorage;
import org.jetbrains.annotations.Nullable;

public class NetEnergyPathwayBlockEntity
extends BaseMachineBlockEntity
implements MenuProvider {
    public PopMode popMode = PopMode.STOP;
    private final Direction[] directions = Direction.values();

    public NetEnergyPathwayBlockEntity(BlockPos pos, BlockState blockState) {
        super(ModBlockEntities.NET_ENERGY_PATHWAY_BLOCK_ENTITY.get(), pos, blockState);
    }

    public static void registerCapability(RegisterCapabilitiesEvent event) {
        event.registerBlockEntity(Capabilities.EnergyStorage.BLOCK, ModBlockEntities.NET_ENERGY_PATHWAY_BLOCK_ENTITY.get(), (be, side) -> {
            if (be.popMode == PopMode.OPEN) {
                return new EnergyStorage(0);
            }
            if (be.getNetId() < 0) {
                return new EnergyStorage(0);
            }
            DimensionsNet net = be.getNet();
            if (net != null) {
                return new EnergyUnifiedStorageHandler(net.getUnifiedStorage());
            }
            return new EnergyStorage(0);
        });
    }

    @Override
    public boolean shouldWork() {
        return super.shouldWork() && this.getNet() != null;
    }

    @Override
    public int getTicksPerWork() {
        return 1;
    }

    @Override
    public void workContent() {
        super.workContent();
        if (this.popMode == PopMode.OPEN) {
            this.popEnergy();
        }
    }

    private void popEnergy() {
        DimensionsNet net = this.getNet();
        if (net == null) {
            return;
        }
        for (Direction dir : this.directions) {
            IEnergyStorage otherStorage;
            BlockPos targetPos = this.getBlockPos().relative(dir);
            BlockEntity neighbor = this.level.getBlockEntity(targetPos);
            if (neighbor == null || neighbor instanceof NetedBlockEntity || (otherStorage = (IEnergyStorage)this.level.getCapability(Capabilities.EnergyStorage.BLOCK, targetPos, (Object)dir.getOpposite())) == null) continue;
            int maxExtract = (int)Math.min(net.getUnifiedStorage().getEnergyStored(), Integer.MAX_VALUE);
            int receive = otherStorage.receiveEnergy(maxExtract, false);
            net.getUnifiedStorage().extract(new EnergyStackType(receive), false);
        }
    }

    @Override
    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        String popModeNew = tag.getString("popMode");
        this.popMode = !popModeNew.isEmpty() ? PopMode.valueOf(popModeNew) : (tag.getBoolean("popMode") ? PopMode.OPEN : PopMode.STOP);
    }

    @Override
    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        tag.putString("popMode", this.popMode.name());
    }

    public Component getDisplayName() {
        return Component.translatable((String)"menu.title.beyonddimensions.net_energy_menu");
    }

    @Nullable
    public AbstractContainerMenu createMenu(int containerId, Inventory inventory, Player player) {
        return new NetEnergyMenu(containerId, player.getInventory(), this);
    }
}

