/*
 * Decompiled with CFR 0.152.
 */
package com.wintercogs.beyonddimensions.GUI;

import com.mojang.blaze3d.systems.RenderSystem;
import com.wintercogs.beyonddimensions.GUI.BDBaseGUI;
import com.wintercogs.beyonddimensions.GUI.SharedWidget.RightTabButton;
import com.wintercogs.beyonddimensions.Machine.PopMode;
import com.wintercogs.beyonddimensions.Machine.RedStoneControlMode;
import com.wintercogs.beyonddimensions.Menu.NetEnergyMenu;
import com.wintercogs.beyonddimensions.Unit.StringFormat;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;

public class NetEnergyGUI
extends BDBaseGUI<NetEnergyMenu> {
    private static final ResourceLocation GUI_TEXTURE = ResourceLocation.parse((String)"beyonddimensions:textures/gui/net_energy_storage.png");
    public RightTabButton popButton;
    public RightTabButton controlModeButton;

    public NetEnergyGUI(NetEnergyMenu container, Inventory playerInventory, Component title) {
        super(container, playerInventory, title);
    }

    protected void init() {
        this.imageWidth = 176;
        this.imageHeight = 175;
        this.leftPos = (this.width - this.imageWidth) / 2;
        this.topPos = (this.height - this.imageHeight) / 2;
        this.popButton = new RightTabButton(this.leftPos + 176, this.topPos + 6, 23, 26, this.leftPos + 176 + 2, this.topPos + 6 + 5, 16, 16, button -> {
            this.popButton.toggleState();
            ((NetEnergyMenu)this.menu).be.popMode = (PopMode)this.popButton.currentState;
            ((NetEnergyMenu)this.menu).writeAndSendQuickData();
        }){

            @Override
            protected void initButton() {
                this.iconMap.put(PopMode.OPEN, ResourceLocation.tryBuild((String)"beyonddimensions", (String)"widget/popmode_up"));
                this.iconMap.put(PopMode.STOP, ResourceLocation.tryBuild((String)"beyonddimensions", (String)"widget/popmode_down"));
                this.tooltipMap.put(PopMode.OPEN, Tooltip.create((Component)Component.translatable((String)"tooltip.button.beyonddimensions.popmode_on")));
                this.tooltipMap.put(PopMode.STOP, Tooltip.create((Component)Component.translatable((String)"tooltip.button.beyonddimensions.popmode_off")));
                for (Enum state : this.iconMap.keySet()) {
                    this.states.add(state);
                }
                this.setState(((NetEnergyMenu)((NetEnergyGUI)NetEnergyGUI.this).menu).be.popMode);
            }
        };
        this.addRenderableWidget((GuiEventListener)this.popButton);
        this.controlModeButton = new RightTabButton(this.leftPos + 176, this.topPos + 36, 23, 26, this.leftPos + 176 + 2, this.topPos + 36 + 5, 16, 16, button -> {
            this.controlModeButton.toggleState();
            ((NetEnergyMenu)this.menu).be.controlMode = (RedStoneControlMode)this.controlModeButton.currentState;
            ((NetEnergyMenu)this.menu).writeAndSendQuickData();
        }){

            @Override
            protected void initButton() {
                this.iconMap.put(RedStoneControlMode.IGNORE, ResourceLocation.tryBuild((String)"beyonddimensions", (String)"widget/control_mode_ignore"));
                this.iconMap.put(RedStoneControlMode.NOT_WORKING, ResourceLocation.tryBuild((String)"beyonddimensions", (String)"widget/control_mode_not_working"));
                this.iconMap.put(RedStoneControlMode.POWERED, ResourceLocation.tryBuild((String)"beyonddimensions", (String)"widget/control_mode_powered"));
                this.iconMap.put(RedStoneControlMode.UNPOWERED, ResourceLocation.tryBuild((String)"beyonddimensions", (String)"widget/control_mode_unpowered"));
                this.tooltipMap.put(RedStoneControlMode.IGNORE, Tooltip.create((Component)Component.translatable((String)"tooltip.button.beyonddimensions.control_mode_ignore")));
                this.tooltipMap.put(RedStoneControlMode.NOT_WORKING, Tooltip.create((Component)Component.translatable((String)"tooltip.button.beyonddimensions.control_mode_not_working")));
                this.tooltipMap.put(RedStoneControlMode.POWERED, Tooltip.create((Component)Component.translatable((String)"tooltip.button.beyonddimensions.control_mode_powered")));
                this.tooltipMap.put(RedStoneControlMode.UNPOWERED, Tooltip.create((Component)Component.translatable((String)"tooltip.button.beyonddimensions.control_mode_unpowered")));
                for (Enum state : this.iconMap.keySet()) {
                    this.states.add(state);
                }
                this.setState(((NetEnergyMenu)((NetEnergyGUI)NetEnergyGUI.this).menu).be.controlMode);
            }
        };
        this.addRenderableWidget((GuiEventListener)this.controlModeButton);
    }

    @Override
    protected void containerTick() {
        super.containerTick();
        if (this.popButton.currentState != ((NetEnergyMenu)this.menu).be.popMode) {
            this.popButton.setState(((NetEnergyMenu)this.menu).be.popMode);
        }
        if (this.controlModeButton.currentState != ((NetEnergyMenu)this.menu).be.controlMode) {
            this.controlModeButton.setState(((NetEnergyMenu)this.menu).be.controlMode);
        }
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTick, int mouseX, int mouseY) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)GUI_TEXTURE);
        guiGraphics.blit(GUI_TEXTURE, this.leftPos, this.topPos, 0, 0, this.imageWidth, this.imageHeight);
    }

    @Override
    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        this.popButton.render(guiGraphics, mouseX, mouseY, partialTicks);
        this.renderEnergyBar(guiGraphics, this.leftPos + 8, this.topPos + 35);
    }

    protected void renderLabels(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        guiGraphics.drawString(this.font, this.title, this.titleLabelX, this.titleLabelY, 0x404040, false);
        guiGraphics.drawString(this.font, this.playerInventoryTitle, this.inventoryLabelX, this.inventoryLabelY + 10, 0x404040, false);
        guiGraphics.drawString(this.font, StringFormat.formatCount(((NetEnergyMenu)this.menu).lastEnergyStored) + "/" + StringFormat.formatCount(((NetEnergyMenu)this.menu).lastEnergyCapacity), this.inventoryLabelX, this.inventoryLabelY - 20, 0x404040, false);
        guiGraphics.drawString(this.font, StringFormat.formatChange(((NetEnergyMenu)this.menu).lastEnergySpeedState) + " FE/t", this.inventoryLabelX, this.inventoryLabelY - 10, 0x404040, false);
    }

    protected void renderEnergyBar(GuiGraphics guiGraphics, int xStart, int yStart) {
        int areaWidth = 160;
        int areaHeight = 16;
        boolean stripeWidth = true;
        float[] brightnessFactors = new float[areaHeight];
        for (int y = 0; y < areaHeight; ++y) {
            float normalizedY = ((float)y - (float)areaHeight / 2.0f) / ((float)areaHeight / 2.0f);
            brightnessFactors[y] = 1.0f - normalizedY * normalizedY;
        }
        for (int i = 0; i < areaWidth; ++i) {
            int color = i / 1 % 2 == 0 ? -12582912 : -14680064;
            int width = Math.min(1, areaWidth - i);
            guiGraphics.fill(xStart + i, yStart, xStart + i + width, yStart + areaHeight, color);
        }
        float energyRatio = (float)((NetEnergyMenu)this.menu).lastEnergyStored / (float)((NetEnergyMenu)this.menu).lastEnergyCapacity;
        int filledWidth = (int)(energyRatio * (float)areaWidth);
        for (int i = 0; i < filledWidth; ++i) {
            int baseColor = i / 1 % 2 == 0 ? -65536 : -8388608;
            int drawWidth = Math.min(1, filledWidth - i);
            int alpha = baseColor >> 24 & 0xFF;
            int red = baseColor >> 16 & 0xFF;
            int green = baseColor >> 8 & 0xFF;
            int blue = baseColor & 0xFF;
            for (int y = 0; y < areaHeight; ++y) {
                int adjustedAlpha = (int)((float)alpha * brightnessFactors[y]);
                int adjustedColor = adjustedAlpha << 24 | red << 16 | green << 8 | blue;
                guiGraphics.fill(xStart + i, yStart + y, xStart + i + drawWidth, yStart + y + 1, adjustedColor);
            }
        }
    }

    @Override
    public Font getFont() {
        return this.font;
    }
}

