/*
 * Decompiled with CFR 0.152.
 */
package com.wintercogs.beyonddimensions.Menu;

import com.wintercogs.beyonddimensions.Api.DataBase.DimensionsNet;
import com.wintercogs.beyonddimensions.Api.DataBase.Storage.UnifiedStorage;
import com.wintercogs.beyonddimensions.BlockEntity.Custom.NetEnergyPathwayBlockEntity;
import com.wintercogs.beyonddimensions.Machine.PopMode;
import com.wintercogs.beyonddimensions.Machine.RedStoneControlMode;
import com.wintercogs.beyonddimensions.Menu.BDBaseMenu;
import java.util.function.Supplier;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.neoforged.neoforge.common.extensions.IMenuTypeExtension;
import net.neoforged.neoforge.registries.DeferredRegister;

public class NetEnergyMenu
extends BDBaseMenu {
    public NetEnergyPathwayBlockEntity be;
    public long lastEnergyCapacity = 0L;
    public long lastEnergyStored = 0L;
    public long lastEnergySpeedState = 0L;
    public static final DeferredRegister<MenuType<?>> MENU_TYPES = DeferredRegister.create((ResourceKey)Registries.MENU, (String)"beyonddimensions");
    public static final Supplier<MenuType<NetEnergyMenu>> Net_Energy_Menu = MENU_TYPES.register("net_energy_menu", () -> IMenuTypeExtension.create(NetEnergyMenu::new));

    public NetEnergyMenu(int id, Inventory playerInventory, FriendlyByteBuf data) {
        this(id, playerInventory, (NetEnergyPathwayBlockEntity)playerInventory.player.level().getBlockEntity(data.readBlockPos()));
    }

    public NetEnergyMenu(int id, Inventory playerInventory, NetEnergyPathwayBlockEntity be) {
        super(Net_Energy_Menu.get(), id, playerInventory);
        this.be = be;
        this.inventoryStartIndex = this.slots.size();
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 9; ++col) {
                this.addSlot(new Slot((Container)playerInventory, col + row * 9 + 9, 8 + col * 18, 93 + row * 18));
            }
        }
        for (int col = 0; col < 9; ++col) {
            this.addSlot(new Slot((Container)playerInventory, col, 8 + col * 18, 151));
        }
        this.inventoryEndIndex = this.slots.size();
    }

    @Override
    protected boolean shouldSendQuickData() {
        DimensionsNet netCache = this.be.getNet();
        if (netCache != null) {
            UnifiedStorage storage = netCache.getUnifiedStorage();
            if (this.lastEnergyStored != storage.getEnergyStored() || this.lastEnergyCapacity != storage.getSlotCapacity(0) || this.lastEnergySpeedState != storage.getEnergyStored() - this.lastEnergyStored) {
                this.lastEnergySpeedState = storage.getEnergyStored() - this.lastEnergyStored;
                this.lastEnergyStored = storage.getEnergyStored();
                this.lastEnergyCapacity = storage.getSlotCapacity(0);
                return true;
            }
        } else if (this.lastEnergyStored != 0L || this.lastEnergyCapacity != 0L || this.lastEnergySpeedState != 0L) {
            this.lastEnergySpeedState = 0L;
            this.lastEnergyStored = 0L;
            this.lastEnergyCapacity = 0L;
            return true;
        }
        return false;
    }

    @Override
    protected void writeQuickDataTag(CompoundTag tag) {
        super.writeQuickDataTag(tag);
        tag.putString("popMode", this.be.popMode.name());
        tag.putString("controlMode", this.be.controlMode.name());
        tag.putLong("lastEnergyCapacity", this.lastEnergyCapacity);
        tag.putLong("lastEnergySpeedState", this.lastEnergySpeedState);
        tag.putLong("lastEnergyStored", this.lastEnergyStored);
    }

    @Override
    public void readQuickDataTag(CompoundTag tag) {
        super.readQuickDataTag(tag);
        if (this.player.level().isClientSide()) {
            this.lastEnergyStored = tag.getLong("lastEnergyStored");
            this.lastEnergyCapacity = tag.getLong("lastEnergyCapacity");
            this.lastEnergySpeedState = tag.getLong("lastEnergySpeedState");
        } else {
            this.be.popMode = PopMode.valueOf(tag.getString("popMode"));
            this.be.controlMode = RedStoneControlMode.valueOf(tag.getString("controlMode"));
            this.player.level().blockEntityChanged(this.be.getBlockPos());
            this.player.level().invalidateCapabilities(this.be.getBlockPos());
            this.player.level().sendBlockUpdated(this.be.getBlockPos(), this.be.getBlockState(), this.be.getBlockState(), 2);
        }
    }

    @Override
    public boolean stillValid(Player player) {
        return this.be != null && !this.be.isRemoved();
    }
}

