/*
 * Decompiled with CFR 0.152.
 */
package com.wintercogs.beyonddimensions.DataBase.Handler;

import com.wintercogs.beyonddimensions.DataBase.Handler.StackTypedHandler;
import com.wintercogs.beyonddimensions.DataBase.Stack.FluidStackType;
import com.wintercogs.beyonddimensions.DataBase.Stack.IStackType;
import javax.annotation.Nullable;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;

public class FluidStackTypedHandler
implements IFluidHandler {
    private StackTypedHandler handlerStorage;

    public FluidStackTypedHandler(StackTypedHandler handlerStorage) {
        this.handlerStorage = handlerStorage;
    }

    public IFluidTankProperties[] getTankProperties() {
        return this.handlerStorage.getTypeIdIndexList(FluidStackType.ID).map(slots -> {
            IFluidTankProperties[] tankProperties = new IFluidTankProperties[slots.size()];
            for (int i = 0; i < slots.size(); ++i) {
                tankProperties[i] = new TankProperties(i, this);
            }
            return tankProperties;
        }).orElse(new IFluidTankProperties[0]);
    }

    public int fill(FluidStack fluidStack, boolean doAction) {
        boolean sim;
        boolean bl = sim = !doAction;
        if (fluidStack.amount <= 0) {
            return 0;
        }
        int allAmount = fluidStack.amount;
        int remaining = (int)this.handlerStorage.insert(new FluidStackType(fluidStack.copy()), sim).getStackAmount();
        return allAmount - remaining;
    }

    public FluidStack drain(FluidStack fluidStack, boolean doAction) {
        boolean sim = !doAction;
        return ((FluidStackType)this.handlerStorage.extract(new FluidStackType(fluidStack.copy()), sim)).copyStack();
    }

    public FluidStack drain(int count, boolean doAction) {
        return this.handlerStorage.getTypeIdIndexList(FluidStackType.ID).map(slots -> (Integer)slots.get(0)).filter(actualIndex -> actualIndex >= 0).map(this.handlerStorage::getStackBySlot).map(stack -> stack.copy()).map(stack -> this.handlerStorage.extract((IStackType)stack, !doAction)).map(extracts -> ((FluidStackType)extracts).copyStack()).orElse(new FluidStackType().getStack());
    }

    public static class TankProperties
    implements IFluidTankProperties {
        int tank;
        FluidStackTypedHandler handler;

        public TankProperties(int tank, FluidStackTypedHandler handler) {
            this.tank = tank;
            this.handler = handler;
        }

        @Nullable
        public FluidStack getContents() {
            return this.handler.handlerStorage.getTypeIdIndexList(FluidStackType.ID).filter(slots -> this.tank >= 0 && this.tank < slots.size()).map(slots -> (Integer)slots.get(this.tank)).filter(actualIndex -> actualIndex >= 0).map(this.handler.handlerStorage::getStackBySlot).map(obj -> (FluidStack)obj.getStack()).orElse(new FluidStackType().getStack());
        }

        public int getCapacity() {
            return 64000;
        }

        public boolean canFill() {
            return true;
        }

        public boolean canDrain() {
            return true;
        }

        public boolean canFillFluidType(FluidStack fluidStack) {
            return true;
        }

        public boolean canDrainFluidType(FluidStack fluidStack) {
            return true;
        }
    }
}

