/*
 * Decompiled with CFR 0.152.
 */
package com.wintercogs.beyonddimensions.DataBase.Stack;

import com.wintercogs.beyonddimensions.Registry.StackTypeRegistry;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public interface IStackType<T> {
    public IStackType<T> fromObject(Object var1, long var2, int var4, NBTTagCompound var5);

    public ResourceLocation getTypeId();

    public IStackType<T> getEmpty();

    public T getStack();

    public void setStack(T var1);

    public Class<T> getStackClass();

    public Class<?> getSourceClass();

    public Object getSource();

    public boolean isEmpty();

    public boolean isEmptyStack();

    public T getEmptyStack();

    public T copyStack();

    public T copyStackWithCount(long var1);

    public IStackType<T> copy();

    public IStackType<T> copyWithCount(long var1);

    public long getStackAmount();

    public void setStackAmount(long var1);

    public void grow(long var1);

    public void shrink(long var1);

    public long getVanillaMaxStackSize();

    public long getCustomMaxStackSize();

    public T splitStack(long var1);

    public IStackType<T> split(long var1);

    public boolean isSame(IStackType<T> var1);

    public boolean isSameTypeSameComponents(IStackType<T> var1);

    public void serialize(PacketBuffer var1);

    public IStackType<T> deserialize(PacketBuffer var1, ResourceLocation var2);

    public static IStackType deserializeCommon(PacketBuffer buf) {
        ResourceLocation typeId = buf.func_192575_l();
        for (IStackType<?> stacktype : StackTypeRegistry.getAllTypes()) {
            IStackType<?> stack = stacktype.deserialize(buf, typeId);
            if (stack == null) continue;
            return stack;
        }
        return null;
    }

    public NBTTagCompound serializeNBT();

    public IStackType<T> deserializeNBT(NBTTagCompound var1);

    @SideOnly(value=Side.CLIENT)
    public void render(int var1, int var2);

    public String getCountText(long var1);

    public String getDisplayName();

    public List<String> getTooltipLines(@Nullable EntityPlayer var1, ITooltipFlag var2);

    @SideOnly(value=Side.CLIENT)
    public void renderTooltip(int var1, int var2);
}

