/*
 * Decompiled with CFR 0.152.
 */
package com.wintercogs.beyonddimensions.DataBase.Stack;

import com.wintercogs.beyonddimensions.DataBase.Stack.IStackType;
import com.wintercogs.beyonddimensions.Unit.BDMath;
import com.wintercogs.beyonddimensions.Unit.StringFormat;
import java.io.IOException;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.client.config.GuiUtils;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemStackType
implements IStackType<ItemStack> {
    public static final ResourceLocation ID = new ResourceLocation("beyonddimensions", "stack_type/item");
    private static final long CUSTOM_MAX_STACK_SIZE = Long.MAX_VALUE;
    private ItemStack stack;
    private long stackSize;
    private int hashCodeCache = 0;
    private boolean NeedRecalHash = true;

    public ItemStackType() {
        this.stack = ItemStack.field_190927_a;
        this.stackSize = 0L;
    }

    public ItemStackType(ItemStack stack) {
        this.stack = stack;
        this.stackSize = stack.func_190916_E();
    }

    public ItemStackType(ItemStack stack, long stackSize) {
        this.stack = stack;
        this.stackSize = stackSize;
    }

    @Override
    public IStackType<ItemStack> fromObject(Object key, long amount, int meta, NBTTagCompound dataComponentPatch) {
        Object object = key;
        if (object instanceof Item) {
            Item item = (Item)object;
            ItemStack itemStack = new ItemStack(item, 1, meta, dataComponentPatch);
            return new ItemStackType(itemStack, amount);
        }
        return null;
    }

    @Override
    public ItemStack getStack() {
        this.stack.func_190920_e(BDMath.clampLongToInt(this.stackSize));
        return this.stack;
    }

    @Override
    public void setStack(ItemStack stack) {
        this.stack = stack.func_77946_l();
        this.stackSize = stack.func_190916_E();
        this.NeedRecalHash = true;
    }

    @Override
    public ResourceLocation getTypeId() {
        return ID;
    }

    @Override
    public IStackType<ItemStack> getEmpty() {
        return new ItemStackType();
    }

    @Override
    public Class<ItemStack> getStackClass() {
        return ItemStack.class;
    }

    @Override
    public Class<?> getSourceClass() {
        return Item.class;
    }

    @Override
    public Object getSource() {
        return ItemStack.field_190927_a.func_77973_b();
    }

    @Override
    public boolean isEmpty() {
        return this.stack.func_190926_b() || this.stackSize <= 0L;
    }

    @Override
    public boolean isEmptyStack() {
        return this.stack.func_190926_b();
    }

    @Override
    public ItemStack getEmptyStack() {
        return ItemStack.field_190927_a;
    }

    @Override
    public ItemStack copyStack() {
        ItemStack copy = this.stack.func_77946_l();
        copy.func_190920_e(BDMath.clampLongToInt(this.stackSize));
        return copy;
    }

    @Override
    public ItemStack copyStackWithCount(long count) {
        ItemStack copy = this.stack.func_77946_l();
        copy.func_190920_e(BDMath.clampLongToInt(count));
        return copy;
    }

    @Override
    public IStackType<ItemStack> copy() {
        ItemStackType copy = new ItemStackType(this.stack.func_77946_l(), this.stackSize);
        copy.NeedRecalHash = this.NeedRecalHash;
        copy.hashCodeCache = this.hashCodeCache;
        return copy;
    }

    @Override
    public IStackType<ItemStack> copyWithCount(long count) {
        ItemStackType copy = new ItemStackType(this.stack.func_77946_l(), count);
        copy.NeedRecalHash = this.NeedRecalHash;
        copy.hashCodeCache = this.hashCodeCache;
        return copy;
    }

    @Override
    public long getStackAmount() {
        return this.stackSize;
    }

    @Override
    public void setStackAmount(long amount) {
        this.stackSize = amount;
    }

    @Override
    public void grow(long amount) {
        this.setStackAmount(this.getStackAmount() + amount);
    }

    @Override
    public void shrink(long amount) {
        this.grow(-amount);
    }

    @Override
    public long getVanillaMaxStackSize() {
        return Math.min((long)this.stack.func_77976_d(), this.getCustomMaxStackSize());
    }

    @Override
    public long getCustomMaxStackSize() {
        return Long.MAX_VALUE;
    }

    @Override
    public ItemStack splitStack(long amount) {
        if (amount <= 0L) {
            return ItemStack.field_190927_a;
        }
        int splitAmount = BDMath.clampLongToInt(Math.min(amount, this.stackSize));
        ItemStack split = this.stack.func_77946_l();
        split.func_190920_e(splitAmount);
        this.shrink(splitAmount);
        return split;
    }

    @Override
    public IStackType<ItemStack> split(long amount) {
        if (amount <= 0L) {
            return new ItemStackType();
        }
        long splitAmount = Math.min(amount, this.stackSize);
        ItemStack split = this.stack.func_77946_l();
        this.shrink(splitAmount);
        return new ItemStackType(split, splitAmount);
    }

    @Override
    public boolean isSame(IStackType<ItemStack> other) {
        if (!other.getTypeId().equals((Object)this.getTypeId())) {
            return false;
        }
        return ItemStack.func_179545_c((ItemStack)this.stack, (ItemStack)other.getStack());
    }

    @Override
    public boolean isSameTypeSameComponents(IStackType<ItemStack> other) {
        if (!other.getTypeId().equals((Object)this.getTypeId())) {
            return false;
        }
        return ItemStack.func_179545_c((ItemStack)this.stack, (ItemStack)other.getStack()) && ItemStack.func_77970_a((ItemStack)this.stack, (ItemStack)other.getStack()) || this.isEmpty() && other.isEmpty();
    }

    @Override
    public void serialize(PacketBuffer buf) {
        buf.func_192572_a(this.getTypeId());
        boolean hasItem = !this.stack.func_190926_b();
        buf.writeBoolean(hasItem);
        if (hasItem) {
            buf.func_179254_b(this.stackSize);
            ItemStack copy = this.stack.func_77946_l();
            copy.func_190920_e(1);
            buf.func_150788_a(copy);
        }
    }

    public ItemStackType deserialize(PacketBuffer buf, ResourceLocation typeId) {
        if (!typeId.equals((Object)this.getTypeId())) {
            return null;
        }
        boolean hasItem = buf.readBoolean();
        if (!hasItem) {
            return new ItemStackType(ItemStack.field_190927_a);
        }
        long count = buf.func_179260_f();
        ItemStack stack = null;
        try {
            stack = buf.func_150791_c();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return new ItemStackType(stack, count);
    }

    @Override
    public NBTTagCompound serializeNBT() {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74772_a("Amount", this.getStackAmount());
        ItemStack copy = this.stack.func_77946_l();
        copy.func_190920_e(1);
        tag.func_74782_a("Stack", (NBTBase)copy.func_77955_b(new NBTTagCompound()));
        return tag;
    }

    public ItemStackType deserializeNBT(NBTTagCompound nbt) {
        ItemStackType stack = new ItemStackType(new ItemStack(nbt.func_74775_l("Stack")));
        stack.setStackAmount(nbt.func_74763_f("Amount"));
        return stack;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void render(int x, int y) {
        Minecraft mc = Minecraft.func_71410_x();
        RenderHelper.func_74520_c();
        this.stack.func_190920_e(1);
        mc.func_175599_af().func_180450_b(this.stack, x, y);
        mc.func_175599_af().func_180453_a(mc.field_71466_p, this.stack, x, y, "");
        RenderHelper.func_74518_a();
        String countText = this.getCountText(this.getStackAmount());
        float scale = 0.666f;
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)200.0f);
        GlStateManager.func_179152_a((float)scale, (float)scale, (float)1.0f);
        int textWidth = mc.field_71466_p.func_78256_a(countText);
        int X = (int)(((float)(x + -2) + 16.0f + 2.0f - (float)textWidth * 0.666f) * 1.0f / 0.666f);
        int Y = (int)(((float)(y + -1) + 16.0f - 3.33f) * 1.0f / 0.666f);
        if (!this.stack.func_190926_b()) {
            mc.field_71466_p.func_175063_a(countText, (float)X, (float)Y, 0xFFFFFF);
        }
        GlStateManager.func_179121_F();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    @Override
    public String getCountText(long count) {
        if (count < 0L) {
            return "";
        }
        return StringFormat.formatCount(count);
    }

    @Override
    public String getDisplayName() {
        return this.stack.func_82833_r();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public List<String> getTooltipLines(@Nullable EntityPlayer player, ITooltipFlag tooltipFlag) {
        List tooltips = this.stack.func_82840_a(player, tooltipFlag);
        tooltips.add(I18n.func_135052_a((String)"stack.beyonddimensions.stored", (Object[])new Object[]{this.getStackAmount()}));
        return tooltips;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderTooltip(int mouseX, int mouseY) {
        Minecraft mc = Minecraft.func_71410_x();
        List<String> tooltip = this.getTooltipLines((EntityPlayer)mc.field_71439_g, (ITooltipFlag)(mc.field_71474_y.field_82882_x ? ITooltipFlag.TooltipFlags.ADVANCED : ITooltipFlag.TooltipFlags.NORMAL));
        GuiUtils.drawHoveringText(tooltip, (int)mouseX, (int)mouseY, (int)mc.field_71443_c, (int)mc.field_71440_d, (int)-1, (FontRenderer)mc.field_71466_p);
    }

    public boolean equals(Object other) {
        Object object = other;
        if (object instanceof ItemStackType) {
            ItemStackType otherStack = (ItemStackType)object;
            return this.isSameTypeSameComponents(otherStack);
        }
        return false;
    }

    public int hashCode() {
        if (this.NeedRecalHash) {
            if (this.stack != null) {
                int i = 31 + this.stack.func_77973_b().hashCode();
                this.hashCodeCache = this.stack.func_77942_o() ? i * 31 + this.stack.func_77978_p().hashCode() : i;
            } else {
                this.hashCodeCache = 0;
            }
            this.NeedRecalHash = false;
        }
        return this.hashCodeCache;
    }
}

