/*
 * Decompiled with CFR 0.152.
 */
package com.wintercogs.beyonddimensions.DataBase.StackHandlerWrapper;

import com.wintercogs.beyonddimensions.DataBase.Stack.FluidStackType;
import com.wintercogs.beyonddimensions.DataBase.StackHandlerWrapper.IStackHandlerWrapper;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class FluidHandlerWrapper
implements IStackHandlerWrapper<FluidStack> {
    private final IFluidHandler fluidHandler;

    public FluidHandlerWrapper(Object fluidHandler) {
        this.fluidHandler = (IFluidHandler)fluidHandler;
    }

    @Override
    public ResourceLocation getTypeId() {
        return FluidStackType.ID;
    }

    @Override
    public int getSlots() {
        return this.fluidHandler.getTankProperties().length;
    }

    @Override
    public FluidStack getStackInSlot(int slot) {
        return this.fluidHandler.getTankProperties()[slot].getContents();
    }

    @Override
    public long getCapacity(int slot) {
        return this.fluidHandler.getTankProperties()[slot].getCapacity();
    }

    @Override
    public boolean isStackValid(EnumFacing facing, int slot, FluidStack stack) {
        return this.fluidHandler.getTankProperties()[slot].canFillFluidType(stack);
    }

    @Override
    public long insert(EnumFacing facing, int slot, FluidStack stack, boolean sim) {
        return this.insert((EnumFacing)null, stack, sim);
    }

    @Override
    public long insert(EnumFacing facing, FluidStack stack, boolean sim) {
        int currentNum = stack.amount;
        int insert = this.fluidHandler.fill(stack, !sim);
        return currentNum - insert;
    }

    @Override
    public long extract(EnumFacing facing, int slot, long amount, boolean sim) {
        for (int i = 0; i < this.getSlots(); ++i) {
            FluidStack stack = this.getStackInSlot(i);
            if (stack.amount <= 0) continue;
            return this.fluidHandler.drain((FluidStack)new FluidStack((FluidStack)stack, (int)((int)Math.min((long)amount, (long)Integer.MAX_VALUE))), (boolean)(!sim ? true : false)).amount;
        }
        return 0L;
    }

    @Override
    public long extract(EnumFacing facing, FluidStack stack, boolean sim) {
        return this.fluidHandler.drain((FluidStack)stack, (boolean)(!sim ? true : false)).amount;
    }
}

