/*
 * Decompiled with CFR 0.152.
 */
package com.wintercogs.beyonddimensions.DataBase.Storage;

import com.wintercogs.beyonddimensions.DataBase.Stack.FluidStackType;
import com.wintercogs.beyonddimensions.DataBase.Stack.IStackType;
import com.wintercogs.beyonddimensions.DataBase.Storage.UnifiedStorage;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;

public class FluidUnifiedStorageHandler
implements IFluidHandler {
    private UnifiedStorage storage;

    public FluidUnifiedStorageHandler(UnifiedStorage storage) {
        this.storage = storage;
    }

    public IFluidTankProperties[] getTankProperties() {
        return this.storage.getTypeIdIndexList(FluidStackType.ID).map(slots -> {
            IFluidTankProperties[] tankProperties = new IFluidTankProperties[slots.size()];
            for (int i = 0; i < slots.size() + 1; ++i) {
                tankProperties[i] = new TankProperties(i, this);
            }
            return tankProperties;
        }).orElse(new IFluidTankProperties[]{new TankProperties(0, this)});
    }

    public int fill(FluidStack fluidStack, boolean doAction) {
        boolean sim;
        boolean bl = sim = !doAction;
        if (fluidStack.amount <= 0) {
            return 0;
        }
        int allAmount = fluidStack.amount;
        int remaining = (int)this.storage.insert(new FluidStackType(fluidStack.copy()), sim).getStackAmount();
        return allAmount - remaining;
    }

    public FluidStack drain(FluidStack fluidStack, boolean doAction) {
        boolean sim = !doAction;
        return ((FluidStackType)this.storage.extract(new FluidStackType(fluidStack.copy()), sim)).copyStack();
    }

    public FluidStack drain(int count, boolean doAction) {
        boolean sim = !doAction;
        return this.storage.getTypeIdIndexList(FluidStackType.ID).flatMap(list -> list.stream().findFirst()).flatMap(actualIndex -> Optional.ofNullable(this.storage.getStackBySlot((int)actualIndex))).map(stack -> stack.copyWithCount(count)).flatMap(copiedStack -> Optional.ofNullable((FluidStackType)this.storage.extract((IStackType)copiedStack, sim))).map(FluidStackType::copyStack).orElse(new FluidStackType().getStack());
    }

    public static class TankProperties
    implements IFluidTankProperties {
        int tank;
        FluidUnifiedStorageHandler handler;

        public TankProperties(int tank, FluidUnifiedStorageHandler handler) {
            this.tank = tank;
            this.handler = handler;
        }

        @Nullable
        public FluidStack getContents() {
            return this.handler.storage.getTypeIdIndexList(FluidStackType.ID).filter(slots -> this.tank >= 0 && this.tank < slots.size()).map(slots -> (Integer)slots.get(this.tank)).filter(actualIndex -> actualIndex >= 0).map(actualIndex -> (FluidStackType)this.handler.storage.getStackBySlot((int)actualIndex)).map(FluidStackType::getStack).orElse(new FluidStackType().getStack());
        }

        public int getCapacity() {
            return Integer.MAX_VALUE;
        }

        public boolean canFill() {
            return true;
        }

        public boolean canDrain() {
            return true;
        }

        public boolean canFillFluidType(FluidStack fluidStack) {
            return true;
        }

        public boolean canDrainFluidType(FluidStack fluidStack) {
            return true;
        }
    }
}

