/*
 * Decompiled with CFR 0.152.
 */
package com.wintercogs.beyonddimensions.Gui;

import com.cleanroommc.modularui.api.IGuiHolder;
import com.cleanroommc.modularui.factory.GuiData;
import com.cleanroommc.modularui.screen.ModularPanel;
import com.cleanroommc.modularui.screen.viewport.LocatedWidget;
import com.cleanroommc.modularui.utils.Alignment;
import com.cleanroommc.modularui.value.sync.GuiSyncManager;
import com.cleanroommc.modularui.value.sync.SyncHandler;
import com.cleanroommc.modularui.widget.sizer.Flex;
import com.cleanroommc.modularui.widgets.ItemSlot;
import com.cleanroommc.modularui.widgets.SlotGroupWidget;
import com.wintercogs.beyonddimensions.DataBase.DimensionsNet;
import com.wintercogs.beyonddimensions.DataBase.Handler.IStackTypedHandler;
import com.wintercogs.beyonddimensions.DataBase.Stack.IStackType;
import com.wintercogs.beyonddimensions.DataBase.Stack.ItemStackType;
import com.wintercogs.beyonddimensions.Gui.Slots.StackTypedSlot;
import com.wintercogs.beyonddimensions.Gui.Sync.ClickActionSync;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import net.minecraft.client.Minecraft;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;

public abstract class BDBaseGUI
implements IGuiHolder<GuiData> {
    protected IStackTypedHandler stackTypedHandler;
    protected IStackTypedHandler viewerStackTypedHandler;
    protected int lines = 6;
    protected int lineData = 0;
    protected int maxLineData = 0;
    protected GuiData guiData;
    protected GuiSyncManager guiSyncManager;
    protected List<StackTypedSlot> slots = new ArrayList<StackTypedSlot>();
    private List<Integer> cacheIndex;

    public ModularPanel buildUI(GuiData guiData, final GuiSyncManager guiSyncManager) {
        this.guiData = guiData;
        this.guiSyncManager = guiSyncManager;
        this.stackTypedHandler = new DimensionsNet().getUnifiedStorage();
        this.viewerStackTypedHandler = new DimensionsNet().getUnifiedStorage();
        if (!guiData.isClient()) {
            this.stackTypedHandler = DimensionsNet.getNetFromPlayer(guiData.getPlayer()).getUnifiedStorage();
        }
        final ClickActionSync clickActionSync = new ClickActionSync(){

            @Override
            public void read(PacketBuffer packetBuffer) throws IOException {
                super.read(packetBuffer);
                if (!guiSyncManager.isClient()) {
                    BDBaseGUI.this.quickMoveHandleInventory(this.slotIndex, this.clickStack, this.button, this.isSlotFake, this.getSyncManager().getPlayer(), BDBaseGUI.this.stackTypedHandler);
                }
            }
        };
        guiSyncManager.syncValue("inventory_listener", (SyncHandler)clickActionSync);
        ModularPanel panel = new ModularPanel("net_base"){

            public boolean onMousePressed(int mouseButton) {
                boolean result = super.onMousePressed(mouseButton);
                if (Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54)) {
                    for (LocatedWidget widget : this.getHovering()) {
                        Object object = widget.getElement();
                        if (!(object instanceof ItemSlot)) continue;
                        ItemSlot slot = (ItemSlot)object;
                        clickActionSync.isSlotFake = slot.getSyncHandler().isPhantom();
                        clickActionSync.clickStack = new ItemStackType((ItemStack)slot.getIngredient());
                        clickActionSync.isShiftDown = true;
                        clickActionSync.button = mouseButton;
                        clickActionSync.slotIndex = slot.getSlot().getSlotIndex();
                        clickActionSync.syncToServer(0, clickActionSync::write);
                    }
                }
                return result;
            }
        };
        panel.flex().startDefaultMode();
        ((Flex)panel.flex().size(176, 230)).align(Alignment.Center);
        panel.flex().endDefaultMode();
        panel.bindPlayerInventory();
        return panel;
    }

    public abstract SlotGroupWidget buildStackTypedSlots(IStackTypedHandler var1);

    public void customClickHandler(int slotIndex, IStackType clickedStack, int button, boolean isFake, EntityPlayer player, boolean shiftDown, IStackTypedHandler storage) {
        if (storage == null) {
            return;
        }
        if (isFake) {
            this.FakeClickHandle(slotIndex, clickedStack, button, isFake, player, storage);
            return;
        }
        if (shiftDown) {
            this.quickMoveHandle(slotIndex, clickedStack, button, isFake, player, storage);
        } else {
            this.clickHandle(slotIndex, clickedStack, button, isFake, player, storage);
        }
    }

    protected abstract void quickMoveHandle(int var1, IStackType var2, int var3, boolean var4, EntityPlayer var5, IStackTypedHandler var6);

    protected abstract void clickHandle(int var1, IStackType var2, int var3, boolean var4, EntityPlayer var5, IStackTypedHandler var6);

    protected abstract void FakeClickHandle(int var1, IStackType var2, int var3, boolean var4, EntityPlayer var5, IStackTypedHandler var6);

    protected abstract void quickMoveHandleInventory(int var1, IStackType var2, int var3, boolean var4, EntityPlayer var5, IStackTypedHandler var6);

    public void updateViewerStorage() {
        this.viewerStackTypedHandler.clearStorage();
        for (IStackType stack : this.stackTypedHandler.getStorage()) {
            this.viewerStackTypedHandler.insert(stack.copy(), false);
        }
        this.buildIndexList(new ArrayList<IStackType>(this.viewerStackTypedHandler.getStorage()), true);
    }

    public void buildIndexList(ArrayList<IStackType> itemStorage, boolean needsUpdateCacheIndex) {
        if (!this.guiData.isClient()) {
            return;
        }
        if (needsUpdateCacheIndex || this.cacheIndex == null) {
            this.cacheIndex = this.buildStorageWithCurrentState(new ArrayList<IStackType>(itemStorage));
        }
        this.updateScrollLineData(this.cacheIndex.size());
        ArrayList<Integer> indexList = new ArrayList<Integer>();
        for (int i = 0; i < this.lines * 9; ++i) {
            if (i + this.lineData * 9 < this.cacheIndex.size()) {
                int index = this.cacheIndex.get(i + this.lineData * 9);
                indexList.add(index);
                continue;
            }
            indexList.add(-1);
        }
        this.loadIndexList(indexList);
    }

    public void loadIndexList(ArrayList<Integer> list) {
        for (int i = 0; i < list.size(); ++i) {
            this.slots.get(i).setSlotIndex(list.get(i));
        }
    }

    public List<Integer> buildStorageWithCurrentState(ArrayList<IStackType> unifiedStorage) {
        ArrayList<IStackType> cache = new ArrayList<IStackType>();
        ArrayList<Integer> cacheIndex = new ArrayList<Integer>();
        for (int i = 0; i < unifiedStorage.size(); ++i) {
            boolean matchesSearch;
            IStackType stack = unifiedStorage.get(i).copy();
            if (stack == null || stack.isEmpty() || !(matchesSearch = this.SeachTextMatch(stack))) continue;
            cache.add(stack);
            cacheIndex.add(i);
        }
        List<Integer> sortedIndices = this.SortIndexList(cache, cacheIndex);
        return sortedIndices;
    }

    @SideOnly(value=Side.CLIENT)
    protected boolean checkTooltipMatches(IStackType stack, String matchText) {
        List<String> toolTips = stack.getTooltipLines((EntityPlayer)Minecraft.func_71410_x().field_71439_g, (ITooltipFlag)(Minecraft.func_71410_x().field_71474_y.field_82882_x ? ITooltipFlag.TooltipFlags.ADVANCED : ITooltipFlag.TooltipFlags.NORMAL));
        return toolTips.stream().anyMatch(tooltip -> tooltip.toLowerCase(Locale.ENGLISH).contains(matchText));
    }

    public void updateScrollLineData(int dataSize) {
        this.maxLineData = dataSize / 9;
        if (dataSize % 9 != 0) {
            ++this.maxLineData;
        }
        this.maxLineData -= this.lines;
        this.maxLineData = Math.max(this.maxLineData, 0);
        this.lineData = Math.max(this.lineData, 0);
        this.lineData = Math.min(this.lineData, this.maxLineData);
    }

    protected abstract boolean SeachTextMatch(IStackType var1);

    protected abstract List<Integer> SortIndexList(List<IStackType> var1, List<Integer> var2);
}

