/*
 * Decompiled with CFR 0.152.
 */
package com.wintercogs.beyonddimensions.Gui;

import com.cleanroommc.modularui.api.drawable.IDrawable;
import com.cleanroommc.modularui.api.widget.IWidget;
import com.cleanroommc.modularui.drawable.UITexture;
import com.cleanroommc.modularui.drawable.keys.LangKey;
import com.cleanroommc.modularui.factory.GuiData;
import com.cleanroommc.modularui.screen.ModularPanel;
import com.cleanroommc.modularui.screen.ModularScreen;
import com.cleanroommc.modularui.value.sync.GuiSyncManager;
import com.cleanroommc.modularui.value.sync.SyncHandler;
import com.cleanroommc.modularui.value.sync.ValueSyncHandler;
import com.cleanroommc.modularui.widget.ScrollWidget;
import com.cleanroommc.modularui.widget.scroll.VerticalScrollData;
import com.cleanroommc.modularui.widget.sizer.Flex;
import com.cleanroommc.modularui.widgets.CycleButtonWidget;
import com.cleanroommc.modularui.widgets.SlotGroupWidget;
import com.cleanroommc.modularui.widgets.textfield.TextFieldWidget;
import com.wintercogs.beyonddimensions.DataBase.ButtonState;
import com.wintercogs.beyonddimensions.DataBase.Handler.IStackTypedHandler;
import com.wintercogs.beyonddimensions.DataBase.Stack.IStackType;
import com.wintercogs.beyonddimensions.Gui.BDDisorderedContainerGUI;
import com.wintercogs.beyonddimensions.Gui.Slots.StackTypedSlot;
import com.wintercogs.beyonddimensions.Gui.Sync.ClickActionSync;
import com.wintercogs.beyonddimensions.Gui.Sync.UnorderdStackTypedHandlerSync;
import com.wintercogs.beyonddimensions.Gui.Widgets.SyncAbleSlotGroupWidget;
import com.wintercogs.beyonddimensions.Unit.TinyPinyinUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.minecraft.network.PacketBuffer;

public class DimensionsNetGUI
extends BDDisorderedContainerGUI {
    private String searchText = "";
    private ButtonState reverseState = ButtonState.DISABLED;
    private ButtonState sortState = ButtonState.SORT_DEFAULT;

    @Override
    public ModularPanel buildUI(GuiData guiData, GuiSyncManager guiSyncManager) {
        ModularPanel panel = super.buildUI(guiData, guiSyncManager);
        TextFieldWidget textFieldWidget = new TextFieldWidget(){

            public void onUpdate() {
                super.onUpdate();
                DimensionsNetGUI.this.searchText = this.getText();
            }
        };
        ((TextFieldWidget)((TextFieldWidget)textFieldWidget.top(5)).leftRel(0.5f)).width(85);
        CycleButtonWidget reverseButton = new CycleButtonWidget(){

            public void next() {
                super.next();
                if (DimensionsNetGUI.this.reverseState == ButtonState.DISABLED) {
                    DimensionsNetGUI.this.reverseState = ButtonState.ENABLED;
                } else {
                    DimensionsNetGUI.this.reverseState = ButtonState.DISABLED;
                }
            }
        };
        reverseButton.length(2).texture(UITexture.fullImage((String)"beyonddimensions", (String)"textures/gui/sprites/widget/sort_reverse.png")).addTooltip(0, (IDrawable)new LangKey("tooltip.beyonddimensions.sort.order")).addTooltip(1, (IDrawable)new LangKey("tooltip.beyonddimensions.sort.reverse"));
        CycleButtonWidget sortMethodButton = new CycleButtonWidget(){

            public void next() {
                super.next();
                if (DimensionsNetGUI.this.sortState == ButtonState.SORT_DEFAULT) {
                    DimensionsNetGUI.this.sortState = ButtonState.SORT_NAME;
                } else if (DimensionsNetGUI.this.sortState == ButtonState.SORT_NAME) {
                    DimensionsNetGUI.this.sortState = ButtonState.SORT_QUANTITY;
                } else {
                    DimensionsNetGUI.this.sortState = ButtonState.SORT_DEFAULT;
                }
            }
        };
        ((CycleButtonWidget)sortMethodButton.left(18)).length(3).texture(UITexture.fullImage((String)"beyonddimensions", (String)"textures/gui/sprites/widget/sort_group.png")).addTooltip(0, (IDrawable)new LangKey("tooltip.beyonddimensions.sort.default")).addTooltip(1, (IDrawable)new LangKey("tooltip.beyonddimensions.sort.name")).addTooltip(2, (IDrawable)new LangKey("tooltip.beyonddimensions.sort.number"));
        ScrollWidget scrollWidget = new ScrollWidget(new VerticalScrollData()){

            public boolean onMouseScroll(ModularScreen.UpOrDown scrollDirection, int amount) {
                super.onMouseScroll(scrollDirection, amount);
                if (scrollDirection.isUp()) {
                    --DimensionsNetGUI.this.lineData;
                } else if (scrollDirection.isDown()) {
                    ++DimensionsNetGUI.this.lineData;
                }
                DimensionsNetGUI.this.buildIndexList(new ArrayList<IStackType>(DimensionsNetGUI.this.viewerStackTypedHandler.getStorage()), false);
                return true;
            }
        };
        ((Flex)scrollWidget.flex().coverChildren()).startDefaultMode().leftRel(0.5f);
        scrollWidget.flex().bottom(95);
        scrollWidget.flex().endDefaultMode();
        scrollWidget.debugName("ScrollWidget");
        ((ModularPanel)((ModularPanel)((ModularPanel)panel.child((IWidget)scrollWidget.child((IWidget)this.buildStackTypedSlots(this.stackTypedHandler)))).child((IWidget)textFieldWidget)).child((IWidget)reverseButton)).child((IWidget)sortMethodButton);
        return panel;
    }

    @Override
    public SlotGroupWidget buildStackTypedSlots(final IStackTypedHandler stackTypedHandler) {
        final SyncAbleSlotGroupWidget slotGroupWidget = new SyncAbleSlotGroupWidget();
        slotGroupWidget.flex().coverChildren();
        slotGroupWidget.debugName("StackTypedSlots");
        slotGroupWidget.syncHandler((SyncHandler)new UnorderdStackTypedHandlerSync(stackTypedHandler));
        ((ValueSyncHandler)slotGroupWidget.getSyncHandler()).setChangeListener(() -> this.updateViewerStorage());
        String key = "StackTypedSlots";
        for (int i = 0; i < this.lines * 9; ++i) {
            ClickActionSync sync = new ClickActionSync(){

                @Override
                public void read(PacketBuffer packetBuffer) throws IOException {
                    super.read(packetBuffer);
                    if (!DimensionsNetGUI.this.guiData.isClient()) {
                        DimensionsNetGUI.this.customClickHandler(this.slotIndex, this.clickStack, this.button, this.isSlotFake, DimensionsNetGUI.this.guiData.getPlayer(), this.isShiftDown, stackTypedHandler);
                        ((ValueSyncHandler)slotGroupWidget.getSyncHandler()).updateCacheFromSource(false);
                    }
                }
            };
            StackTypedSlot slot = new StackTypedSlot(-1, this.viewerStackTypedHandler).syncHandler((SyncHandler)sync);
            slotGroupWidget.child((IWidget)((StackTypedSlot)slot.pos(i % 9 * 18, i / 9 * 18)).debugName("StackTypedSlot_" + i));
            this.slots.add(slot);
        }
        return slotGroupWidget;
    }

    @Override
    protected boolean SeachTextMatch(IStackType stack) {
        boolean matchesSearch;
        if (this.searchText == null || this.searchText.isEmpty()) {
            return true;
        }
        String displayName = stack.getDisplayName().toLowerCase(Locale.ENGLISH);
        String allPinyin = TinyPinyinUtils.getAllPinyin(displayName, false).toLowerCase(Locale.ENGLISH);
        String firstPinyin = TinyPinyinUtils.getFirstPinYin(displayName).toLowerCase(Locale.ENGLISH);
        if (this.searchText == null || this.searchText.isEmpty()) {
            matchesSearch = true;
        } else {
            String lowerSearch = this.searchText.toLowerCase(Locale.ENGLISH);
            int atIndex = lowerSearch.indexOf(64);
            if (atIndex >= 0) {
                String mainPart = atIndex > 0 ? lowerSearch.substring(0, atIndex) : "";
                String tooltipPart = atIndex + 1 < lowerSearch.length() ? lowerSearch.substring(atIndex + 1) : "";
                boolean matchesMain = mainPart.isEmpty() || displayName.contains(mainPart) || allPinyin.contains(mainPart) || firstPinyin.contains(mainPart);
                boolean matchesTooltip = tooltipPart.isEmpty() || this.checkTooltipMatches(stack, tooltipPart);
                matchesSearch = matchesMain && matchesTooltip;
            } else {
                matchesSearch = displayName.contains(lowerSearch) || allPinyin.contains(lowerSearch) || firstPinyin.contains(lowerSearch);
            }
        }
        return matchesSearch;
    }

    @Override
    protected List<Integer> SortIndexList(List<IStackType> stacksSource, List<Integer> indicesSource) {
        ButtonState sortState = this.sortState;
        if (sortState != ButtonState.SORT_DEFAULT) {
            Comparator<IStackType> comparator = sortState == ButtonState.SORT_NAME ? Comparator.comparing(item -> item.getDisplayName()) : Comparator.comparingLong(IStackType::getStackAmount);
            List<IStackType> finalCache = stacksSource;
            List indices = IntStream.range(0, stacksSource.size()).boxed().sorted((a, b) -> comparator.compare((IStackType)finalCache.get((int)a), (IStackType)finalCache.get((int)b))).collect(Collectors.toList());
            ArrayList<Integer> sortedIndices = new ArrayList<Integer>(indicesSource.size());
            Iterator iterator = indices.iterator();
            while (iterator.hasNext()) {
                int index = (Integer)iterator.next();
                sortedIndices.add(indicesSource.get(index));
            }
            indicesSource = sortedIndices;
        }
        if (this.reverseState == ButtonState.ENABLED) {
            Collections.reverse(indicesSource);
        }
        return indicesSource;
    }
}

