/*
 * Decompiled with CFR 0.152.
 */
package com.wintercogs.beyonddimensions.Gui;

import com.cleanroommc.modularui.api.drawable.IDrawable;
import com.cleanroommc.modularui.api.drawable.IKey;
import com.cleanroommc.modularui.api.widget.IWidget;
import com.cleanroommc.modularui.api.widget.Interactable;
import com.cleanroommc.modularui.drawable.keys.LangKey;
import com.cleanroommc.modularui.drawable.keys.StringKey;
import com.cleanroommc.modularui.factory.GuiData;
import com.cleanroommc.modularui.network.NetworkUtils;
import com.cleanroommc.modularui.screen.ModularPanel;
import com.cleanroommc.modularui.value.sync.GuiSyncManager;
import com.cleanroommc.modularui.value.sync.SyncHandler;
import com.cleanroommc.modularui.widget.WidgetTree;
import com.cleanroommc.modularui.widgets.ListWidget;
import com.cleanroommc.modularui.widgets.SlotGroupWidget;
import com.cleanroommc.modularui.widgets.TextWidget;
import com.wintercogs.beyonddimensions.DataBase.DimensionsNet;
import com.wintercogs.beyonddimensions.DataBase.Handler.IStackTypedHandler;
import com.wintercogs.beyonddimensions.DataBase.NetControlAction;
import com.wintercogs.beyonddimensions.DataBase.PlayerPermissionInfo;
import com.wintercogs.beyonddimensions.DataBase.Stack.IStackType;
import com.wintercogs.beyonddimensions.Gui.BDOrderedContainerGUI;
import com.wintercogs.beyonddimensions.Gui.Sync.PlayerPermissionsSync;
import com.wintercogs.beyonddimensions.Gui.Widgets.ClickAbleButton;
import com.wintercogs.beyonddimensions.Gui.Widgets.PermissionsButton;
import com.wintercogs.beyonddimensions.Network.Packet.toServer.NetControlActionPacket;
import com.wintercogs.beyonddimensions.Registry.PacketRegister;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class NetControlGUI
extends BDOrderedContainerGUI {
    public List<PlayerPermissionInfo> permissions = new ArrayList<PlayerPermissionInfo>();
    private PlayerPermissionInfo currentPermission;
    private List<IWidget> needUpdateWidgets = new ArrayList<IWidget>();

    @Override
    public ModularPanel buildUI(GuiData guiData, GuiSyncManager guiSyncManager) {
        DimensionsNet net;
        DimensionsNet net2;
        final ModularPanel panel = super.buildUI(guiData, guiSyncManager);
        this.stackTypedHandler = null;
        this.viewerStackTypedHandler = null;
        ListWidget listWidget = new ListWidget(permission -> {
            Object playerPermissionInfo$temp = permission;
            if (playerPermissionInfo$temp instanceof PlayerPermissionInfo) {
                final PlayerPermissionInfo playerPermissionInfo = (PlayerPermissionInfo)playerPermissionInfo$temp;
                PermissionsButton button = new PermissionsButton(playerPermissionInfo){

                    public Interactable.Result onMousePressed(int mouseButton) {
                        Interactable.Result result = super.onMousePressed(mouseButton);
                        NetControlGUI.this.rebuildCurrentInfo(panel, playerPermissionInfo);
                        return result;
                    }
                };
                button.width(30);
                button.overlay(new IDrawable[]{new StringKey(playerPermissionInfo.getName())});
                return button;
            }
            return null;
        }, widget -> {
            Object permissionsButton$temp = widget;
            if (permissionsButton$temp instanceof PermissionsButton) {
                PermissionsButton permissionsButton = (PermissionsButton)((Object)((Object)permissionsButton$temp));
                return permissionsButton.permission;
            }
            return null;
        });
        if (!guiData.isClient() && (net2 = DimensionsNet.getNetFromPlayer(guiData.getPlayer())) != null) {
            this.permissions = new ArrayList<PlayerPermissionInfo>(net2.getPlayerPermissionInfoMap(guiData.getPlayer().field_70170_p).values());
        }
        PlayerPermissionsSync sync = new PlayerPermissionsSync(this.permissions);
        sync.setChangeListener(() -> {
            this.permissions = sync.getValue();
            int size = listWidget.getValues().size();
            if (size > 0) {
                for (int i = size - 1; i >= 0; --i) {
                    listWidget.remove(i);
                }
            }
            int newSize = this.permissions.size();
            for (int i = 0; i < newSize; ++i) {
                listWidget.add((Object)this.permissions.get(i), i);
            }
            if (this.currentPermission != null) {
                UUID nowPlayer = this.currentPermission.getPlayerId();
                boolean find = false;
                for (PlayerPermissionInfo permission : this.permissions) {
                    if (!permission.getPlayerId().equals(nowPlayer)) continue;
                    this.currentPermission = permission;
                    find = true;
                }
                if (!find) {
                    this.currentPermission = null;
                }
                this.rebuildCurrentInfo(panel, this.currentPermission);
            }
        });
        if (!NetworkUtils.isClient() && (net = DimensionsNet.getNetFromPlayer(guiData.getPlayer())) != null) {
            sync.setNet(net);
            sync.setPlayerMP((EntityPlayerMP)guiData.getPlayer());
        }
        guiSyncManager.syncValue("permissions_sync", (SyncHandler)sync);
        TextWidget nameText = new TextWidget((IKey)new LangKey("text.beyonddimensions.level.name.empty"));
        TextWidget levelText = new TextWidget((IKey)new LangKey("text.beyonddimensions.level.level.empty"));
        this.needUpdateWidgets.add((IWidget)nameText);
        this.needUpdateWidgets.add((IWidget)levelText);
        ((TextWidget)nameText.leftRelAnchor(0.3f, 0.0f)).topRel(0.1f);
        ((TextWidget)levelText.leftRelAnchor(0.3f, 0.0f)).topRel(0.2f);
        ClickAbleButton ownerButton = new ClickAbleButton(){

            public Interactable.Result onMousePressed(int mouseButton) {
                Interactable.Result result = super.onMousePressed(mouseButton);
                if (NetControlGUI.this.currentPermission != null) {
                    PacketRegister.INSTANCE.sendToServer((IMessage)new NetControlActionPacket(NetControlGUI.this.currentPermission.getPlayerId(), NetControlAction.SetOwner));
                }
                return result;
            }
        };
        ClickAbleButton managerButton = new ClickAbleButton(){

            public Interactable.Result onMousePressed(int mouseButton) {
                Interactable.Result result = super.onMousePressed(mouseButton);
                if (NetControlGUI.this.currentPermission != null) {
                    PacketRegister.INSTANCE.sendToServer((IMessage)new NetControlActionPacket(NetControlGUI.this.currentPermission.getPlayerId(), NetControlAction.SetManager));
                }
                return result;
            }
        };
        ClickAbleButton removeManagerButton = new ClickAbleButton(){

            public Interactable.Result onMousePressed(int mouseButton) {
                Interactable.Result result = super.onMousePressed(mouseButton);
                if (NetControlGUI.this.currentPermission != null) {
                    PacketRegister.INSTANCE.sendToServer((IMessage)new NetControlActionPacket(NetControlGUI.this.currentPermission.getPlayerId(), NetControlAction.RemoveManager));
                }
                return result;
            }
        };
        ClickAbleButton removeMemberButton = new ClickAbleButton(){

            public Interactable.Result onMousePressed(int mouseButton) {
                Interactable.Result result = super.onMousePressed(mouseButton);
                if (NetControlGUI.this.currentPermission != null) {
                    PacketRegister.INSTANCE.sendToServer((IMessage)new NetControlActionPacket(NetControlGUI.this.currentPermission.getPlayerId(), NetControlAction.RemovePlayer));
                }
                return result;
            }
        };
        ((ClickAbleButton)((ClickAbleButton)((ClickAbleButton)ownerButton.leftRel(0.5f)).topRel(0.3f)).width(40)).height(32);
        ((ClickAbleButton)((ClickAbleButton)((ClickAbleButton)managerButton.leftRel(0.5f)).topRel(0.5f)).width(40)).height(32);
        ((ClickAbleButton)((ClickAbleButton)((ClickAbleButton)removeManagerButton.leftRel(0.82f)).topRel(0.3f)).width(40)).height(32);
        ((ClickAbleButton)((ClickAbleButton)((ClickAbleButton)removeMemberButton.leftRel(0.82f)).topRel(0.5f)).width(40)).height(32);
        ownerButton.overlay(new IDrawable[]{new LangKey("button.beyonddimensions.level.setowner")});
        managerButton.overlay(new IDrawable[]{new LangKey("button.beyonddimensions.level.setmanager")});
        removeManagerButton.overlay(new IDrawable[]{new LangKey("button.beyonddimensions.level.removemanager")});
        removeMemberButton.overlay(new IDrawable[]{new LangKey("button.beyonddimensions.level.removemember")});
        listWidget.size(32, 142).top(4).left(7);
        return (ModularPanel)((ModularPanel)((ModularPanel)((ModularPanel)((ModularPanel)((ModularPanel)((ModularPanel)panel.child((IWidget)listWidget)).child((IWidget)nameText)).child((IWidget)levelText)).child((IWidget)ownerButton)).child((IWidget)managerButton)).child((IWidget)removeManagerButton)).child((IWidget)removeMemberButton);
    }

    public void rebuildCurrentInfo(ModularPanel panel, PlayerPermissionInfo info) {
        this.currentPermission = info;
        if (this.currentPermission != null) {
            TextWidget nameText = new TextWidget((IKey)new LangKey("text.beyonddimensions.level.name", new Object[]{this.currentPermission.getName()}));
            TextWidget levelText = new TextWidget((IKey)new LangKey("text.beyonddimensions.level.level", new Object[]{this.currentPermission.getLevel().toString()}));
            for (IWidget widget : this.needUpdateWidgets) {
                panel.remove(widget);
            }
            this.needUpdateWidgets.clear();
            this.needUpdateWidgets.add((IWidget)nameText);
            this.needUpdateWidgets.add((IWidget)levelText);
            ((TextWidget)nameText.leftRelAnchor(0.3f, 0.0f)).topRel(0.1f);
            ((TextWidget)levelText.leftRelAnchor(0.3f, 0.0f)).topRel(0.2f);
            panel.child((IWidget)nameText);
            panel.child((IWidget)levelText);
            WidgetTree.resize((IWidget)panel);
        } else {
            TextWidget nameText = new TextWidget((IKey)new LangKey("text.beyonddimensions.level.name.empty"));
            TextWidget levelText = new TextWidget((IKey)new LangKey("text.beyonddimensions.level.level.empty"));
            for (IWidget widget : this.needUpdateWidgets) {
                panel.remove(widget);
            }
            this.needUpdateWidgets.clear();
            this.needUpdateWidgets.add((IWidget)nameText);
            this.needUpdateWidgets.add((IWidget)levelText);
            ((TextWidget)nameText.leftRelAnchor(0.3f, 0.0f)).topRel(0.1f);
            ((TextWidget)levelText.leftRelAnchor(0.3f, 0.0f)).topRel(0.2f);
            panel.child((IWidget)nameText);
            panel.child((IWidget)levelText);
            WidgetTree.resize((IWidget)panel);
        }
    }

    @Override
    public SlotGroupWidget buildStackTypedSlots(IStackTypedHandler stackTypedHandler) {
        return null;
    }

    @Override
    protected boolean SeachTextMatch(IStackType stack) {
        return false;
    }

    @Override
    protected List<Integer> SortIndexList(List<IStackType> stacksSource, List<Integer> indicesSource) {
        return null;
    }

    public static void handlePlayerAction(UUID receiver, NetControlAction action, DimensionsNet net, EntityPlayerMP player) {
        if (action == NetControlAction.SetOwner) {
            if (net.isOwner((EntityPlayer)player) && !player.func_110124_au().equals(receiver)) {
                net.setOwner(receiver);
            }
        } else if (action == NetControlAction.SetManager) {
            if (net.isOwner((EntityPlayer)player) && !net.isManager(receiver)) {
                net.addManager(receiver);
            }
        } else if (action == NetControlAction.RemoveManager) {
            if (net.isOwner((EntityPlayer)player) && net.isManager(receiver) && !net.isOwner(receiver)) {
                net.removeManager(receiver);
            }
        } else if (action == NetControlAction.RemovePlayer) {
            if (net.isManager((EntityPlayer)player) && !net.isManager(receiver)) {
                net.removePlayer(receiver);
            } else if (player.func_110124_au().equals(receiver) && !net.isOwner(receiver)) {
                net.removePlayer(receiver);
            } else if (net.isOwner((EntityPlayer)player) && !player.func_110124_au().equals(receiver)) {
                net.removePlayer(receiver);
            }
        }
    }
}

