/*
 * Decompiled with CFR 0.152.
 */
package com.wintercogs.beyonddimensions.Gui.Slots;

import com.cleanroommc.modularui.api.ITheme;
import com.cleanroommc.modularui.api.widget.Interactable;
import com.cleanroommc.modularui.drawable.GuiDraw;
import com.cleanroommc.modularui.integration.jei.JeiGhostIngredientSlot;
import com.cleanroommc.modularui.integration.jei.JeiIngredientProvider;
import com.cleanroommc.modularui.screen.Tooltip;
import com.cleanroommc.modularui.screen.viewport.GuiContext;
import com.cleanroommc.modularui.theme.WidgetSlotTheme;
import com.cleanroommc.modularui.theme.WidgetTheme;
import com.cleanroommc.modularui.value.sync.SyncHandler;
import com.cleanroommc.modularui.widget.Widget;
import com.wintercogs.beyonddimensions.DataBase.Handler.IStackTypedHandler;
import com.wintercogs.beyonddimensions.DataBase.Stack.IStackType;
import com.wintercogs.beyonddimensions.DataBase.Stack.ItemStackType;
import com.wintercogs.beyonddimensions.Gui.Sync.ClickActionSync;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;

public class StackTypedSlot
extends Widget<StackTypedSlot>
implements Interactable,
JeiGhostIngredientSlot<IStackType<?>>,
JeiIngredientProvider {
    private int slotIndex;
    private IStackTypedHandler stackTypedHandler;
    private boolean fake;

    public StackTypedSlot(int slotIndex, IStackTypedHandler stackTypedHandler) {
        this.slotIndex = slotIndex;
        this.stackTypedHandler = stackTypedHandler;
    }

    public StackTypedSlot(int slotIndex, IStackTypedHandler stackTypedHandler, boolean fake) {
        this.slotIndex = slotIndex;
        this.stackTypedHandler = stackTypedHandler;
        this.fake = fake;
    }

    public IStackType getTypedStackFromUnifiedStorage() {
        IStackType stackType = this.stackTypedHandler.getStackBySlot(this.getSlotIndex());
        if (stackType != null) {
            return stackType.copy();
        }
        return new ItemStackType();
    }

    public int getSlotIndex() {
        return this.slotIndex;
    }

    public void setSlotIndex(int slotIndex) {
        this.slotIndex = slotIndex;
    }

    public boolean isFake() {
        return this.fake;
    }

    public void setFake(boolean fake) {
        this.fake = fake;
    }

    public StackTypedSlot syncHandler(SyncHandler syncHandler) {
        this.setSyncHandler(syncHandler);
        return this;
    }

    public ClickActionSync getClickActionSync() {
        SyncHandler syncHandler = this.getSyncHandler();
        if (syncHandler instanceof ClickActionSync) {
            ClickActionSync sync = (ClickActionSync)syncHandler;
            return sync;
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public void draw(GuiContext context, WidgetTheme widgetTheme) {
        IStackType stackType = this.getTypedStackFromUnifiedStorage();
        if (stackType != null && !stackType.isEmpty()) {
            stackType.render(1, 1);
        }
        if (this.isHovering()) {
            GlStateManager.func_179135_a((boolean)true, (boolean)true, (boolean)true, (boolean)false);
            GuiDraw.drawRect((float)1.0f, (float)1.0f, (float)(this.getArea().w() - 2), (float)(this.getArea().h() - 2), (int)((WidgetSlotTheme)this.getWidgetTheme(context.getTheme())).getSlotHoverColor());
            GlStateManager.func_179135_a((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public Tooltip getTooltip() {
        IStackType stackType = this.stackTypedHandler.getStackBySlot(this.getSlotIndex());
        Tooltip tooltip = new Tooltip().excludeArea(this.getArea());
        if (stackType != null && !stackType.isEmpty()) {
            for (String line : stackType.getTooltipLines((EntityPlayer)Minecraft.func_71410_x().field_71439_g, (ITooltipFlag)(Minecraft.func_71410_x().field_71474_y.field_82882_x ? ITooltipFlag.TooltipFlags.ADVANCED : ITooltipFlag.TooltipFlags.NORMAL))) {
                tooltip.addLine(line);
            }
        }
        return tooltip;
    }

    public WidgetTheme getWidgetTheme(ITheme theme) {
        return theme.getItemSlotTheme();
    }

    public Interactable.Result onMousePressed(int mouseButton) {
        super.onMousePressed(mouseButton);
        if (this.getClickActionSync() != null) {
            ClickActionSync clickActionSync = this.getClickActionSync();
            clickActionSync.isSlotFake = this.isFake();
            clickActionSync.isShiftDown = Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54);
            clickActionSync.clickStack = this.getTypedStackFromUnifiedStorage();
            clickActionSync.button = mouseButton;
            clickActionSync.slotIndex = this.getSlotIndex();
            clickActionSync.syncToServer(0, clickActionSync::write);
            return Interactable.Result.ACCEPT;
        }
        return Interactable.Result.ACCEPT;
    }

    public void setGhostIngredient(IStackType<?> iStackType) {
    }

    @Nullable
    public IStackType<?> castGhostIngredientIfValid(Object o) {
        if (this.isFake() && o instanceof IStackType) {
            return (IStackType)o;
        }
        return null;
    }

    public Object getIngredient() {
        IStackType stackType = this.getTypedStackFromUnifiedStorage();
        if (stackType != null && !stackType.isEmpty()) {
            return stackType;
        }
        return null;
    }
}

