/*
 * Decompiled with CFR 0.152.
 */
package com.wintercogs.beyonddimensions.Gui.Sync;

import com.cleanroommc.modularui.network.NetworkUtils;
import com.cleanroommc.modularui.value.sync.ValueSyncHandler;
import com.wintercogs.beyonddimensions.DataBase.Handler.IStackTypedHandler;
import com.wintercogs.beyonddimensions.DataBase.Stack.IStackType;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import net.minecraft.network.PacketBuffer;

public class UnorderdStackTypedHandlerSync
extends ValueSyncHandler<IStackTypedHandler> {
    private IStackTypedHandler stacks;
    private List<IStackType> lastStacks;

    public UnorderdStackTypedHandlerSync(IStackTypedHandler stacks) {
        this.stacks = stacks;
        this.lastStacks = new ArrayList<IStackType>();
    }

    public void setValue(IStackTypedHandler StackTypeList, boolean setSource, boolean sync) {
        this.stacks = StackTypeList;
        if (setSource) {
            // empty if block
        }
        if (sync && !NetworkUtils.isClient()) {
            this.syncToClient(0, this::write);
        }
        this.onValueChanged();
    }

    public IStackTypedHandler getValue() {
        return this.stacks;
    }

    public boolean updateCacheFromSource(boolean init) {
        if (!NetworkUtils.isClient()) {
            this.syncToClient(0, this::write);
        }
        return true;
    }

    public void write(PacketBuffer packetBuffer) throws IOException {
        ArrayList changedItem = new ArrayList();
        ArrayList<Long> changedCount = new ArrayList<Long>();
        HashMap<IStackType, Long> lastMap = new HashMap<IStackType, Long>();
        for (IStackType iStackType : this.lastStacks) {
            lastMap.put(iStackType, lastMap.getOrDefault(iStackType, 0L) + iStackType.getStackAmount());
        }
        HashMap<IStackType, Long> nowMap = new HashMap<IStackType, Long>();
        for (IStackType iStackType : this.stacks.getStorage()) {
            nowMap.put(iStackType, nowMap.getOrDefault(iStackType, 0L) + iStackType.getStackAmount());
        }
        this.refreshLast();
        HashSet hashSet = new HashSet();
        hashSet.addAll(lastMap.keySet());
        hashSet.addAll(nowMap.keySet());
        for (IStackType key : hashSet) {
            long lastCount = lastMap.getOrDefault(key, 0L);
            long nowCount = nowMap.getOrDefault(key, 0L);
            long delta = nowCount - lastCount;
            if (delta == 0L) continue;
            changedItem.add(key.copy());
            changedCount.add(delta);
        }
        int n = changedItem.size();
        packetBuffer.func_150787_b(n);
        for (int i = 0; i < n; ++i) {
            ((IStackType)changedItem.get(i)).serialize(packetBuffer);
            packetBuffer.func_179254_b(((Long)changedCount.get(i)).longValue());
        }
    }

    public void read(PacketBuffer packetBuffer) throws IOException {
        if (!NetworkUtils.isClient()) {
            return;
        }
        int changes = packetBuffer.func_150792_a();
        ArrayList<IStackType> changedItem = new ArrayList<IStackType>(changes);
        ArrayList<Long> changedCount = new ArrayList<Long>(changes);
        for (int i = 0; i < changes; ++i) {
            changedItem.add(IStackType.deserializeCommon(packetBuffer));
            changedCount.add(packetBuffer.func_179260_f());
        }
        IStackTypedHandler clientStorage = this.stacks;
        int i = 0;
        for (IStackType remoteStack : changedItem) {
            if (clientStorage.hasStackType(remoteStack)) {
                if ((Long)changedCount.get(i) > 0L) {
                    clientStorage.insert(remoteStack.copyWithCount((Long)changedCount.get(i)), false);
                } else {
                    clientStorage.extract(remoteStack.copyWithCount(-((Long)changedCount.get(i)).longValue()), false);
                }
            } else if ((Long)changedCount.get(i) > 0L) {
                clientStorage.insert(remoteStack.copyWithCount((Long)changedCount.get(i)), false);
            }
            ++i;
        }
        this.onValueChanged();
    }

    public void refreshLast() {
        this.lastStacks.clear();
        for (IStackType stack : this.stacks.getStorage()) {
            this.lastStacks.add(stack.copy());
        }
    }
}

