/*
 * Decompiled with CFR 0.152.
 */
package com.wintercogs.beyonddimensions.Unit;

import com.github.promeg.pinyinhelper.Pinyin;

public class TinyPinyinUtils {
    public static String getFirstPinYin(String hanyu) {
        char[] chars;
        StringBuilder firstPinyin = new StringBuilder();
        for (char c : chars = hanyu.trim().toCharArray()) {
            if (Pinyin.isChinese(c)) {
                String pinyin = Pinyin.toPinyin(c);
                if (pinyin.isEmpty()) continue;
                firstPinyin.append(pinyin.charAt(0));
                continue;
            }
            firstPinyin.append(c);
        }
        return firstPinyin.toString();
    }

    public static String getAllPinyin(String hanzi, boolean addSpace) {
        char[] chars;
        StringBuilder result = new StringBuilder();
        for (char c : chars = hanzi.trim().toCharArray()) {
            if (Pinyin.isChinese(c)) {
                result.append(Pinyin.toPinyin(c));
            } else {
                result.append(c);
            }
            if (!addSpace) continue;
            result.append(' ');
        }
        if (addSpace && result.length() > 0) {
            result.deleteCharAt(result.length() - 1);
        }
        return result.toString();
    }

    static {
        Pinyin.init(Pinyin.newConfig());
    }
}

