/*
 * Decompiled with CFR 0.152.
 */
package com.wintercogs.beyonddimensions.Api.DataBase.Handler;

import com.wintercogs.beyonddimensions.Api.DataBase.Handler.StackTypedHandler;
import com.wintercogs.beyonddimensions.Api.DataBase.Stack.EnergyStackType;
import com.wintercogs.beyonddimensions.Unit.BDMath;
import net.minecraftforge.energy.IEnergyStorage;

public class EnergyStackTypedHandler
implements IEnergyStorage {
    private StackTypedHandler handlerStorage;

    public EnergyStackTypedHandler(StackTypedHandler handlerStorage) {
        this.handlerStorage = handlerStorage;
    }

    public int receiveEnergy(int count, boolean simulate) {
        return (int)((long)count - this.handlerStorage.insert(new EnergyStackType(count), simulate).getStackAmount());
    }

    public int extractEnergy(int count, boolean simulate) {
        return (int)this.handlerStorage.extract(new EnergyStackType(count), simulate).getStackAmount();
    }

    public int getEnergyStored() {
        return this.handlerStorage.getTypeIdIndexList(EnergyStackType.ID).map(slots -> (Integer)slots.get(0)).filter(actualIndex -> actualIndex >= 0).map(actualIndex -> (EnergyStackType)this.handlerStorage.getStackBySlot((int)actualIndex)).map(energyStackType -> BDMath.clampLongToInt(energyStackType.getStackAmount())).orElse(0);
    }

    public int getMaxEnergyStored() {
        return Integer.MAX_VALUE;
    }

    public boolean canExtract() {
        return true;
    }

    public boolean canReceive() {
        return true;
    }
}

