/*
 * Decompiled with CFR 0.152.
 */
package com.wintercogs.beyonddimensions.Item.Custom;

import com.wintercogs.beyonddimensions.Api.DataBase.Stack.IStackType;
import com.wintercogs.beyonddimensions.Api.DataBase.Stack.ItemStackType;
import com.wintercogs.beyonddimensions.Api.DataBase.Storage.UnifiedStorage;
import com.wintercogs.beyonddimensions.Item.Custom.BaseMachineItem;
import com.wintercogs.beyonddimensions.Item.Custom.NetedItem;
import com.wintercogs.beyonddimensions.Machine.FeederMode;
import com.wintercogs.beyonddimensions.Machine.FilterMode;
import com.wintercogs.beyonddimensions.Menu.NetFeederMenu;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodData;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.NotNull;

public class NetFeederItem
extends BaseMachineItem {
    public static final int capacity = 36;

    public NetFeederItem(Item.Properties properties) {
        super(properties.m_41487_(1));
    }

    @Override
    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand usedHand) {
        super.m_7203_(level, player, usedHand);
        ItemStack itemstack = player.m_21120_(usedHand);
        if (usedHand != InteractionHand.MAIN_HAND || player.m_6144_()) {
            return InteractionResultHolder.m_19100_((Object)itemstack);
        }
        if (!level.m_5776_()) {
            NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)player), (MenuProvider)new SimpleMenuProvider((containerId, inv, ServerPlayer2) -> new NetFeederMenu(containerId, inv, itemstack), (Component)Component.m_237115_((String)"menu.title.beyonddimensions.feeder_menu")), buf -> buf.m_130068_((Enum)usedHand));
        }
        return InteractionResultHolder.m_19092_((Object)itemstack, (boolean)level.m_5776_());
    }

    @Override
    public void checkComponents(ItemStack stack) {
        super.checkComponents(stack);
        if (!NetFeederItem.hasFilterSlots(stack)) {
            NetFeederItem.setFilterSlots(stack, new ArrayList(Collections.nCopies(36, new ItemStackType())));
        }
        if (!NetFeederItem.hasFeederMode(stack)) {
            NetFeederItem.setFeederMode(stack, FeederMode.NORMAL);
        }
    }

    @Override
    public boolean shouldWork(ItemStack stack, Level level, Entity holder, int slotId, boolean isSelected) {
        return super.shouldWork(stack, level, holder, slotId, isSelected) && NetedItem.getNet(stack, level.m_7654_()) != null;
    }

    @Override
    public void workContent(ItemStack stack, Level level, Entity holder, int slotId, boolean isSelected) {
        super.workContent(stack, level, holder, slotId, isSelected);
        if (holder instanceof Player) {
            Player player = (Player)holder;
            FeederMode feederMode = NetFeederItem.getFeederModeOrDefault(stack, FeederMode.NORMAL);
            List<IStackType<?>> filterSlots = NetFeederItem.getFilterSlotsOrDefault(stack, new ArrayList());
            FoodData playerFoodState = player.m_36324_();
            if (this.feederModeMatch(playerFoodState, feederMode)) {
                ItemStackType foodToFeed;
                UnifiedStorage storage = NetedItem.getNet(stack, level.m_7654_()).getUnifiedStorage();
                IStackType<?> foodCache = null;
                block0: for (IStackType<?> filter : filterSlots) {
                    for (IStackType<?> storedStack : storage.getStorage()) {
                        ItemStackType itemStackType;
                        if (!(storedStack instanceof ItemStackType) || !(itemStackType = (ItemStackType)storedStack).isSame(filter) || itemStackType.getStack().getFoodProperties((LivingEntity)player) == null) continue;
                        foodCache = storedStack.copyWithCount(1L);
                        continue block0;
                    }
                }
                if (foodCache != null && !(foodToFeed = (ItemStackType)storage.extract(foodCache, false)).isEmpty()) {
                    ItemStack foodStack = foodToFeed.copyStack();
                    Item foodItem = foodStack.m_41720_();
                    FoodProperties foodProperties = foodItem.getFoodProperties(foodStack, (LivingEntity)player);
                    if (foodProperties != null && (feederMode == FeederMode.SATURATION_KEEP && foodProperties.m_38745_() > 0.0f || feederMode != FeederMode.SATURATION_KEEP && foodProperties.m_38744_() > 0)) {
                        ItemStackType remainingAgain;
                        IStackType<?> iStackType;
                        ItemStack remaining = ForgeEventFactory.onItemUseFinish((LivingEntity)player, (ItemStack)foodStack.m_41777_(), (int)0, (ItemStack)foodItem.m_5922_(foodStack, level, (LivingEntity)player));
                        if (!remaining.m_41619_() && (iStackType = storage.insert(new ItemStackType(remaining), false)) instanceof ItemStackType && !(remainingAgain = (ItemStackType)iStackType).isEmpty()) {
                            player.m_36176_(remainingAgain.copyStack(), false);
                        }
                        return;
                    }
                    storage.insert(foodToFeed, false);
                }
            }
        }
    }

    private boolean feederModeMatch(FoodData playerFoodState, FeederMode feederMode) {
        return switch (feederMode) {
            default -> throw new IncompatibleClassChangeError();
            case FeederMode.HUNGER_TO_EAT -> {
                if (playerFoodState.m_38702_() <= 2) {
                    yield true;
                }
                yield false;
            }
            case FeederMode.NORMAL -> {
                if (playerFoodState.m_38702_() <= 10) {
                    yield true;
                }
                yield false;
            }
            case FeederMode.SATURATION_KEEP -> {
                if (playerFoodState.m_38722_() <= 0.0f) {
                    yield true;
                }
                yield false;
            }
            case FeederMode.CRAZY -> playerFoodState.m_38702_() < 20;
        };
    }

    private boolean matchesFilter(List<IStackType<?>> filterSlots, IStackType<?> otherStack) {
        switch (FilterMode.WHITE) {
            case BLACK: {
                for (IStackType<?> stack : filterSlots) {
                    if (!stack.isSame(otherStack)) continue;
                    return false;
                }
                return true;
            }
            case WHITE: {
                for (IStackType<?> stack : filterSlots) {
                    if (!stack.isSame(otherStack)) continue;
                    return true;
                }
                return false;
            }
            case IGNORE: {
                return true;
            }
        }
        return false;
    }

    @Override
    public int getTicksPerWork(ItemStack stack, Level level, Entity holder, int slotId, boolean isSelected) {
        return 10;
    }
}

