/*
 * Decompiled with CFR 0.152.
 */
package com.wintercogs.beyonddimensions.Menu;

import com.wintercogs.beyonddimensions.Api.DataBase.Handler.IStackTypedHandler;
import com.wintercogs.beyonddimensions.Api.DataBase.Handler.StackTypedHandler;
import com.wintercogs.beyonddimensions.Api.DataBase.Stack.IStackType;
import com.wintercogs.beyonddimensions.Item.Custom.BaseMachineItem;
import com.wintercogs.beyonddimensions.Machine.FilterMode;
import com.wintercogs.beyonddimensions.Machine.HopperFluidMode;
import com.wintercogs.beyonddimensions.Machine.HopperItemMode;
import com.wintercogs.beyonddimensions.Machine.HopperNBTMode;
import com.wintercogs.beyonddimensions.Machine.HopperRangeMode;
import com.wintercogs.beyonddimensions.Machine.HopperXpMode;
import com.wintercogs.beyonddimensions.Machine.RedStoneControlMode;
import com.wintercogs.beyonddimensions.Menu.BDBaseMenu;
import com.wintercogs.beyonddimensions.Menu.Slot.FlagStackTypedSlot;
import com.wintercogs.beyonddimensions.Registry.UIRegister;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class NetMagnetMenu
extends BDBaseMenu {
    private static final int slotStartY = 25;
    private static final int invSlotStartY = 111;
    private final IStackTypedHandler storage = new StackTypedHandler(36){

        @Override
        public void onChange() {
            super.onChange();
            if (!NetMagnetMenu.this.player.m_9236_().m_5776_() && NetMagnetMenu.this.initialized) {
                BaseMachineItem.setFilterSlots(NetMagnetMenu.this.menuStack, new ArrayList(NetMagnetMenu.this.storage.getStorage()));
            }
        }
    };
    private boolean initialized;
    public final ItemStack menuStack;
    private RedStoneControlMode lastControlMode;
    private FilterMode lastFilterMode;
    private HopperItemMode lastHopperItemMode;
    private HopperXpMode lastHopperXpMode;
    private HopperNBTMode lastHopperNBTMode;
    private HopperFluidMode lastHopperFluidMode;
    private HopperRangeMode lastHopperRangeMode;

    public NetMagnetMenu(int id, Inventory playerInventory, FriendlyByteBuf data) {
        this(id, playerInventory, playerInventory.f_35978_.m_21120_((InteractionHand)data.m_130066_(InteractionHand.class)));
    }

    public NetMagnetMenu(int containerId, Inventory playerInventory, ItemStack menuStack) {
        super(UIRegister.Net_Magnet_Menu.get(), containerId, playerInventory);
        this.menuStack = menuStack;
        this.initialized = false;
        if (!playerInventory.f_35978_.m_9236_().m_5776_()) {
            List<IStackType<?>> stacks = BaseMachineItem.getFilterSlotsOrDefault(menuStack, new ArrayList());
            for (int i = 0; i < stacks.size(); ++i) {
                this.storage.insert(i, stacks.get(i).copy(), false);
            }
        }
        this.initialized = true;
        this.addPlayerInv(playerInventory);
        this.addFlagSlots();
    }

    private void addFlagSlots() {
        for (int row = 0; row < 4; ++row) {
            for (int col = 0; col < 9; ++col) {
                FlagStackTypedSlot flagSlot = new FlagStackTypedSlot(this, this.storage, row * 9 + col, 8 + col * 18, 25 + row * 18);
                this.m_38897_(flagSlot);
            }
        }
    }

    private void addPlayerInv(Inventory playerInventory) {
        this.inventoryStartIndex = this.f_38839_.size();
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 9; ++col) {
                this.m_38897_(new Slot((Container)playerInventory, col + row * 9 + 9, 8 + col * 18, 111 + row * 18));
            }
        }
        for (int col = 0; col < 9; ++col) {
            this.m_38897_(new Slot((Container)playerInventory, col, 8 + col * 18, 169));
        }
        this.inventoryEndIndex = this.f_38839_.size();
    }

    @Override
    public boolean m_6875_(Player player) {
        return this.menuStack != null && !this.menuStack.m_41619_();
    }

    @Override
    protected boolean shouldSendQuickData() {
        boolean result;
        boolean bl = result = super.shouldSendQuickData() || this.lastControlMode != BaseMachineItem.getControlModeOrDefault(this.menuStack, RedStoneControlMode.IGNORE) || this.lastFilterMode != BaseMachineItem.getFilterModeOrDefault(this.menuStack, FilterMode.BLACK) || this.lastHopperItemMode != BaseMachineItem.getHopperItemModeOrDefault(this.menuStack, HopperItemMode.ALLOW) || this.lastHopperXpMode != BaseMachineItem.getHopperXpModeOrDefault(this.menuStack, HopperXpMode.DENY) || this.lastHopperNBTMode != BaseMachineItem.getHopperNBTModeOrDefault(this.menuStack, HopperNBTMode.DENY) || this.lastHopperFluidMode != BaseMachineItem.getHopperFluidModeOrDefault(this.menuStack, HopperFluidMode.DENY) || this.lastHopperRangeMode != BaseMachineItem.getHopperRangeModeOrDefault(this.menuStack, HopperRangeMode.RADIUS_MID);
        if (result) {
            this.lastControlMode = BaseMachineItem.getControlModeOrDefault(this.menuStack, RedStoneControlMode.IGNORE);
            this.lastFilterMode = BaseMachineItem.getFilterModeOrDefault(this.menuStack, FilterMode.BLACK);
            this.lastHopperItemMode = BaseMachineItem.getHopperItemModeOrDefault(this.menuStack, HopperItemMode.ALLOW);
            this.lastHopperXpMode = BaseMachineItem.getHopperXpModeOrDefault(this.menuStack, HopperXpMode.DENY);
            this.lastHopperNBTMode = BaseMachineItem.getHopperNBTModeOrDefault(this.menuStack, HopperNBTMode.DENY);
            this.lastHopperFluidMode = BaseMachineItem.getHopperFluidModeOrDefault(this.menuStack, HopperFluidMode.DENY);
            this.lastHopperRangeMode = BaseMachineItem.getHopperRangeModeOrDefault(this.menuStack, HopperRangeMode.RADIUS_MID);
        }
        return result;
    }

    @Override
    protected void writeQuickDataTag(CompoundTag tag) {
        super.writeQuickDataTag(tag);
        tag.m_128359_("control_mode", BaseMachineItem.getControlModeOrDefault(this.menuStack, RedStoneControlMode.IGNORE).name());
        tag.m_128359_("filter_type", BaseMachineItem.getFilterModeOrDefault(this.menuStack, FilterMode.BLACK).name());
        tag.m_128359_("hopper_item_mode", BaseMachineItem.getHopperItemModeOrDefault(this.menuStack, HopperItemMode.ALLOW).name());
        tag.m_128359_("hopper_xp_mode", BaseMachineItem.getHopperXpModeOrDefault(this.menuStack, HopperXpMode.DENY).name());
        tag.m_128359_("hopper_nbt_mode", BaseMachineItem.getHopperNBTModeOrDefault(this.menuStack, HopperNBTMode.DENY).name());
        tag.m_128359_("hopper_fluid_mode", BaseMachineItem.getHopperFluidModeOrDefault(this.menuStack, HopperFluidMode.DENY).name());
        tag.m_128359_("hopper_range_mode", BaseMachineItem.getHopperRangeModeOrDefault(this.menuStack, HopperRangeMode.RADIUS_MID).name());
    }

    @Override
    public void readQuickDataTag(CompoundTag tag) {
        super.readQuickDataTag(tag);
        BaseMachineItem.setControlMode(this.menuStack, RedStoneControlMode.valueOf(tag.m_128461_("control_mode")));
        BaseMachineItem.setFilterMode(this.menuStack, FilterMode.valueOf(tag.m_128461_("filter_type")));
        BaseMachineItem.setHopperItemMode(this.menuStack, HopperItemMode.valueOf(tag.m_128461_("hopper_item_mode")));
        BaseMachineItem.setHopperXpMode(this.menuStack, HopperXpMode.valueOf(tag.m_128461_("hopper_xp_mode")));
        BaseMachineItem.setHopperNBTMode(this.menuStack, HopperNBTMode.valueOf(tag.m_128461_("hopper_nbt_mode")));
        BaseMachineItem.setHopperFluidMode(this.menuStack, HopperFluidMode.valueOf(tag.m_128461_("hopper_fluid_mode")));
        BaseMachineItem.setHopperRangeMode(this.menuStack, HopperRangeMode.valueOf(tag.m_128461_("hopper_range_mode")));
    }
}

