/*
 * Decompiled with CFR 0.152.
 */
package com.wintercogs.beyonddimensions.Network.Packet.ClientOrServer;

import com.wintercogs.beyonddimensions.Api.DataBase.Stack.IStackType;
import com.wintercogs.beyonddimensions.Menu.BDBaseMenu;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;

public record CallSeverClickPacket(int slotIndex, IStackType clickItem, int button, boolean shiftDown) {
    private void handleServer(NetworkEvent.Context context) {
        ServerPlayer player = context.getSender();
        AbstractContainerMenu abstractContainerMenu = player.f_36096_;
        if (abstractContainerMenu instanceof BDBaseMenu) {
            BDBaseMenu menu = (BDBaseMenu)abstractContainerMenu;
            menu.customClickHandler(this.slotIndex(), this.clickItem(), this.button(), this.shiftDown());
            menu.m_38946_();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void handleClient(NetworkEvent.Context context) {
    }

    public static void handle(CallSeverClickPacket packet, Supplier<NetworkEvent.Context> cxt) {
        if (packet != null) {
            NetworkEvent.Context context = cxt.get();
            NetworkDirection direction = context.getDirection();
            if (direction == NetworkDirection.PLAY_TO_CLIENT) {
                context.enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> packet.handleClient(context)));
                context.setPacketHandled(true);
            } else if (direction == NetworkDirection.PLAY_TO_SERVER) {
                context.enqueueWork(() -> packet.handleServer(context));
                context.setPacketHandled(true);
            }
        }
    }

    public static void encode(CallSeverClickPacket packet, FriendlyByteBuf buf) {
        buf.writeInt(packet.slotIndex());
        IStackType stackType = packet.clickItem();
        stackType.serialize(buf);
        buf.writeInt(packet.button());
        buf.writeBoolean(packet.shiftDown());
    }

    public static CallSeverClickPacket decode(FriendlyByteBuf buf) {
        int slotIndex = buf.readInt();
        IStackType clickItem = IStackType.deserializeCommon(buf);
        int button = buf.readInt();
        boolean shiftDown = buf.readBoolean();
        return new CallSeverClickPacket(slotIndex, clickItem, button, shiftDown);
    }
}

