/*
 * Decompiled with CFR 0.152.
 */
package com.wintercogs.beyonddimensions.Network.Packet.toServer;

import com.wintercogs.beyonddimensions.Api.DataBase.Stack.IStackType;
import com.wintercogs.beyonddimensions.Api.DataBase.Stack.ItemStackType;
import com.wintercogs.beyonddimensions.Api.DataBase.Storage.UnifiedStorage;
import com.wintercogs.beyonddimensions.Menu.DimensionsNetMenu;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;

public record BatchTransferPacket(IStackType clickStack, boolean dirToStorage) {
    private void handle(NetworkEvent.Context context) {
        IStackType iStackType = this.clickStack();
        if (iStackType instanceof ItemStackType) {
            ItemStackType clickItem = (ItemStackType)iStackType;
            ServerPlayer player = context.getSender();
            AbstractContainerMenu abstractContainerMenu = player.f_36096_;
            if (abstractContainerMenu instanceof DimensionsNetMenu) {
                DimensionsNetMenu menu = (DimensionsNetMenu)abstractContainerMenu;
                if (this.dirToStorage) {
                    for (Slot invSlot : menu.f_38839_) {
                        if (menu.inventoryStartIndex > invSlot.f_40219_ || invSlot.f_40219_ >= menu.inventoryEndIndex || !ItemStack.m_150942_((ItemStack)clickItem.getStack(), (ItemStack)invSlot.m_7993_())) continue;
                        menu.customClickHandler(invSlot.f_40219_, new ItemStackType(invSlot.m_7993_()), 0, true);
                    }
                } else if (!this.clickStack.isEmpty()) {
                    UnifiedStorage storage = menu.storage;
                    ItemStackType trueStack = storage.getStackByStack(this.clickStack).copyWithCount(this.clickStack.getStackAmount());
                    for (int targetSlotIndex = menu.inventoryStartIndex; targetSlotIndex < menu.inventoryEndIndex && !trueStack.isEmpty(); ++targetSlotIndex) {
                        Slot slot = (Slot)menu.f_38839_.get(targetSlotIndex);
                        if (!(trueStack instanceof ItemStackType)) continue;
                        ItemStackType trueItemTypedStack = trueStack;
                        ItemStack extract = (ItemStack)storage.extract(trueItemTypedStack, false).getStack();
                        ItemStack remaining = slot.m_150659_(extract);
                        if (!remaining.m_41619_()) {
                            storage.insert(new ItemStackType(remaining), false);
                        }
                        trueStack = new ItemStackType(remaining.m_41777_());
                    }
                }
                menu.m_38946_();
            }
        }
    }

    public static void handle(BatchTransferPacket packet, Supplier<NetworkEvent.Context> cxt) {
        if (packet != null) {
            NetworkEvent.Context context = cxt.get();
            context.enqueueWork(() -> packet.handle(context));
            context.setPacketHandled(true);
        }
    }

    public static void encode(BatchTransferPacket packet, FriendlyByteBuf buf) {
        packet.clickStack.serialize(buf);
        buf.writeBoolean(packet.dirToStorage);
    }

    public static BatchTransferPacket decode(FriendlyByteBuf buf) {
        IStackType clickStack = IStackType.deserializeCommon(buf);
        boolean dirToStorage = buf.readBoolean();
        return new BatchTransferPacket(clickStack, dirToStorage);
    }
}

