/*
 * Decompiled with CFR 0.152.
 */
package com.wintercogs.beyonddimensions.Network.Packet.toServer;

import com.wintercogs.beyonddimensions.Api.DataBase.DimensionsNet;
import com.wintercogs.beyonddimensions.Api.DataBase.Stack.IStackType;
import com.wintercogs.beyonddimensions.Api.DataBase.Stack.ItemStackType;
import com.wintercogs.beyonddimensions.Api.DataBase.Storage.UnifiedStorage;
import com.wintercogs.beyonddimensions.Unit.BDMath;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.NetworkEvent;

public record PutHandItemToNetPacket(InteractionHand hand) {
    private void handle(NetworkEvent.Context context) {
        ServerPlayer player = context.getSender();
        if (player.m_21205_().m_41619_()) {
            return;
        }
        DimensionsNet net = DimensionsNet.getNetFromPlayer((Player)player);
        if (net == null) {
            return;
        }
        UnifiedStorage storage = net.getUnifiedStorage();
        IStackType<?> remaining = storage.insert(new ItemStackType(player.m_21205_()), false);
        player.m_21205_().m_41764_(BDMath.clampLongToInt(remaining.getStackAmount()));
    }

    public static void handle(PutHandItemToNetPacket packet, Supplier<NetworkEvent.Context> cxt) {
        if (packet != null) {
            NetworkEvent.Context context = cxt.get();
            context.enqueueWork(() -> packet.handle(context));
            context.setPacketHandled(true);
        }
    }

    public static void encode(PutHandItemToNetPacket packet, FriendlyByteBuf buf) {
        buf.m_130068_((Enum)packet.hand);
    }

    public static PutHandItemToNetPacket decode(FriendlyByteBuf buf) {
        return new PutHandItemToNetPacket((InteractionHand)buf.m_130066_(InteractionHand.class));
    }
}

