/*
 * Decompiled with CFR 0.152.
 */
package com.wintercogs.beyonddimensions.Unit;

public class StringFormat {
    private static final String[] UNITS = new String[]{"", "k", "M", "G", "T", "P", "E"};
    private static final long[] THRESHOLDS = new long[]{1000L, 1000000L, 1000000000L, 1000000000000L, 1000000000000000L, 1000000000000000000L};

    public static String formatCount(long count) {
        int unitIndex;
        if (count < 1000L) {
            return String.valueOf(count);
        }
        for (unitIndex = 0; unitIndex < THRESHOLDS.length - 1 && count >= THRESHOLDS[unitIndex + 1]; ++unitIndex) {
        }
        double value = (double)count / (double)THRESHOLDS[unitIndex];
        return String.format("%d%s", (long)value, UNITS[unitIndex + 1]);
    }

    public static String formatBucket(long count) {
        int unitIndex;
        if (count < 1000L) {
            return String.valueOf((float)count / 1000.0f);
        }
        if ((count /= 1000L) < 1000L) {
            return String.valueOf(count);
        }
        for (unitIndex = 0; unitIndex < THRESHOLDS.length - 1 && count >= THRESHOLDS[unitIndex + 1]; ++unitIndex) {
        }
        double value = (double)count / (double)THRESHOLDS[unitIndex];
        return String.format("%d%s", (long)value, UNITS[unitIndex + 1]);
    }

    public static String formatChange(long change) {
        int unitIndex;
        if (change == 0L) {
            return "0";
        }
        String sign = change > 0L ? "+" : "-";
        long absValue = Math.abs(change);
        if (absValue < 1000L) {
            return sign + String.format("%d", absValue);
        }
        for (unitIndex = 0; unitIndex < THRESHOLDS.length - 1 && absValue >= THRESHOLDS[unitIndex + 1]; ++unitIndex) {
        }
        double value = (double)absValue / (double)THRESHOLDS[unitIndex];
        return sign + String.format("%.2f%s", value, UNITS[unitIndex + 1]);
    }
}

