/*
 * Decompiled with CFR 0.152.
 */
package com.wintercogs.beyonddimensions.Integration.Ars.Caps;

import com.hollingsworth.arsnouveau.api.source.ISourceTile;
import com.hollingsworth.arsnouveau.common.block.tile.CreativeSourceJarTile;
import com.wintercogs.beyonddimensions.Integration.Ars.Caps.ISourceCap;

public class BlockSourceAdp
implements ISourceCap {
    private ISourceTile sourceTile;

    public BlockSourceAdp(ISourceTile sourceTile) {
        this.sourceTile = sourceTile;
    }

    @Override
    public boolean canAcceptSource(int amount) {
        return this.sourceTile.canAcceptSource();
    }

    @Override
    public boolean canProvideSource(int amount) {
        return this.sourceTile.getSource() > 0;
    }

    @Override
    public int getMaxExtract() {
        return this.sourceTile.getTransferRate();
    }

    @Override
    public int getMaxReceive() {
        return this.sourceTile.getTransferRate();
    }

    @Override
    public int getSource() {
        return this.sourceTile.getSource();
    }

    @Override
    public int getSourceCapacity() {
        return this.sourceTile.getMaxSource();
    }

    @Override
    public void setSource(int amount) {
        this.sourceTile.setSource(amount);
    }

    @Override
    public void setMaxSource(int amount) {
        this.sourceTile.setMaxSource(amount);
    }

    @Override
    public int receiveSource(int amount, boolean sim) {
        int before = this.sourceTile.getSource();
        int actInsert = Math.min(amount, Math.min(this.sourceTile.getMaxSource() - before, this.sourceTile.getTransferRate()));
        if (!sim) {
            return this.sourceTile.addSource(actInsert) - before;
        }
        return actInsert;
    }

    @Override
    public int extractSource(int amount, boolean sim) {
        if (this.sourceTile instanceof CreativeSourceJarTile) {
            return 1000000;
        }
        int before = this.sourceTile.getSource();
        int actExtract = Math.max(amount, Math.min(before, this.sourceTile.getTransferRate()));
        if (!sim) {
            return before - this.sourceTile.removeSource(actExtract);
        }
        return actExtract;
    }
}

