/*
 * Decompiled with CFR 0.152.
 */
package com.wintercogs.beyonddimensions.Integration.Botania.Block;

import com.google.common.base.Predicates;
import com.mojang.blaze3d.systems.RenderSystem;
import com.wintercogs.beyonddimensions.Api.DataBase.Storage.ManaUnifiedStorageHandler;
import com.wintercogs.beyonddimensions.Api.Util.CapCtx;
import com.wintercogs.beyonddimensions.BlockEntity.Custom.NetedBlockEntity;
import com.wintercogs.beyonddimensions.BlockEntity.ModBlockEntities;
import com.wintercogs.beyonddimensions.Unit.BDMath;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import org.apache.commons.lang3.mutable.MutableInt;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.BotaniaAPIClient;
import vazkii.botania.api.BotaniaForgeCapabilities;
import vazkii.botania.api.BotaniaForgeClientCapabilities;
import vazkii.botania.api.block.WandHUD;
import vazkii.botania.api.block.Wandable;
import vazkii.botania.api.internal.ManaBurst;
import vazkii.botania.api.internal.VanillaPacketDispatcher;
import vazkii.botania.api.item.ManaDissolvable;
import vazkii.botania.api.mana.ManaBlockType;
import vazkii.botania.api.mana.ManaCollector;
import vazkii.botania.api.mana.ManaItem;
import vazkii.botania.api.mana.ManaNetworkAction;
import vazkii.botania.api.mana.ManaPool;
import vazkii.botania.api.mana.ManaReceiver;
import vazkii.botania.api.mana.spark.ManaSpark;
import vazkii.botania.api.mana.spark.SparkAttachable;
import vazkii.botania.api.recipe.ManaInfusionRecipe;
import vazkii.botania.client.core.helper.RenderHelper;
import vazkii.botania.client.fx.SparkleParticleData;
import vazkii.botania.client.fx.WispParticleData;
import vazkii.botania.client.gui.HUDHandler;
import vazkii.botania.common.block.BotaniaBlocks;
import vazkii.botania.common.block.block_entity.mana.BellowsBlockEntity;
import vazkii.botania.common.crafting.BotaniaRecipeTypes;
import vazkii.botania.common.handler.BotaniaSounds;
import vazkii.botania.common.handler.ManaNetworkHandler;
import vazkii.botania.common.helper.EntityHelper;
import vazkii.botania.common.item.BotaniaItems;
import vazkii.botania.common.item.ManaTabletItem;
import vazkii.botania.xplat.BotaniaConfig;
import vazkii.botania.xplat.XplatAbstractions;

public class ManaPoolPathwayBlockEntity
extends NetedBlockEntity
implements ManaCollector,
ManaPool,
SparkAttachable,
Wandable {
    LazyOptional<ManaPoolPathwayBlockEntity> opt = LazyOptional.empty();
    LazyOptional<WandHud> opt_hud = LazyOptional.empty();
    private ManaUnifiedStorageHandler handler = null;
    private boolean isOutPutting = true;
    private final Int2ObjectMap<MutableInt> chargingParticles = new Int2ObjectOpenHashMap();
    private final Int2ObjectMap<MutableInt> drainingParticles = new Int2ObjectOpenHashMap();
    private static final float CHARGING_GRAVITY = 0.003f;
    private static final int CRAFT_EFFECT_EVENT = 0;
    private static final int CHARGE_EFFECT_EVENT = 1;
    private static final int DRAIN_EFFECT_EVENT = 2;
    private int soundTicks = 0;
    private int ticks = 0;
    private final Long2ObjectOpenHashMap<ManaInfusionRecipe> recipeCache = new Long2ObjectOpenHashMap();
    private int recipeCacheVersionSeen = -1;
    private static volatile int GLOBAL_RECIPE_CACHE_VERSION = 0;

    public ManaPoolPathwayBlockEntity(BlockPos pos, BlockState blockState) {
        super(ModBlockEntities.MANA_POOL_PATHWAY_BLOCK_ENTITY.get(), pos, blockState);
        this.refreshHandler();
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (cap == BotaniaForgeCapabilities.MANA_RECEIVER || cap == BotaniaForgeCapabilities.SPARK_ATTACHABLE || cap == BotaniaForgeCapabilities.WANDABLE) {
            if (!this.opt.isPresent()) {
                this.opt = LazyOptional.of(() -> this);
            }
            return this.opt.cast();
        }
        if (cap == BotaniaForgeClientCapabilities.WAND_HUD) {
            if (this.f_58857_ != null && this.f_58857_.m_5776_()) {
                if (!this.opt_hud.isPresent()) {
                    this.opt_hud = LazyOptional.of(() -> new WandHud(this));
                }
                return this.opt_hud.cast();
            }
            return LazyOptional.empty();
        }
        return super.getCapability(cap, side);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.opt.invalidate();
        this.opt_hud.invalidate();
        this.opt = LazyOptional.empty();
        this.opt_hud = LazyOptional.empty();
    }

    public static void clientTick(Level level, BlockPos pos, BlockState state, ManaPoolPathwayBlockEntity be) {
        double particleChance = 0.9;
        if (Math.random() > particleChance) {
            WispParticleData data = WispParticleData.wisp((float)((float)Math.random() / 3.0f), (float)0.0f, (float)0.7764706f, (float)1.0f, (float)2.0f);
            level.m_7106_((ParticleOptions)data, (double)pos.m_123341_() + 0.3 + Math.random() * 0.5, (double)pos.m_123342_() + 0.6 + Math.random() * 0.25, (double)pos.m_123343_() + Math.random(), 0.0, (double)((float)Math.random() / 25.0f), 0.0);
        }
        ManaPoolPathwayBlockEntity.displayChargingParticles(level, pos, be, be.chargingParticles, true);
        ManaPoolPathwayBlockEntity.displayChargingParticles(level, pos, be, be.drainingParticles, false);
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, ManaPoolPathwayBlockEntity be) {
        be.initManaCapAndNetwork();
        if (be.soundTicks > 0) {
            --be.soundTicks;
        }
        List items = level.m_45976_(ItemEntity.class, new AABB(pos));
        for (ItemEntity item : items) {
            if (!item.m_6084_()) continue;
            ItemStack stack = item.m_32055_();
            ManaItem mana = XplatAbstractions.INSTANCE.findManaItem(stack);
            if (stack.m_41619_() || mana == null || (!be.isOutPutting || !mana.canReceiveManaFromPool((BlockEntity)be)) && (be.isOutPutting || !mana.canExportManaToPool((BlockEntity)be))) continue;
            boolean didSomething = false;
            int transfRate = Integer.MAX_VALUE;
            if (be.isOutPutting) {
                if (be.getCurrentMana() > 0 && mana.getMana() < mana.getMaxMana()) {
                    didSomething = true;
                    manaVal = Math.min(transfRate, Math.min(be.getCurrentMana(), mana.getMaxMana() - mana.getMana()));
                    mana.addMana(manaVal);
                    be.receiveMana(-manaVal);
                }
            } else if (mana.getMana() > 0 && !be.isFull()) {
                didSomething = true;
                manaVal = Math.min(transfRate, Math.min(BDMath.clampLongToInt(be.getActualMaxMana() - be.getActualCurrentMana()), mana.getMana()));
                if (manaVal == 0 && be.f_58857_.m_8055_(pos.m_7495_()).m_60713_(BotaniaBlocks.manaVoid)) {
                    manaVal = Math.min(transfRate, mana.getMana());
                }
                mana.addMana(-manaVal);
                be.receiveMana(manaVal);
            }
            if (!didSomething) continue;
            if (BotaniaConfig.common().chargingAnimationEnabled() && be.ticks % 10 == 0) {
                level.m_7696_(pos, state.m_60734_(), be.isOutPutting ? 1 : 2, ManaPoolPathwayBlockEntity.encodeRelativeItemPosition(pos, item));
            }
            EntityHelper.syncItem((ItemEntity)item);
        }
        ++be.ticks;
    }

    private static int encodeRelativeItemPosition(BlockPos worldPosition, ItemEntity item) {
        double relX = Mth.m_14008_((double)(item.m_20182_().m_7096_() - (double)worldPosition.m_123341_()), (double)0.0, (double)1.0);
        double relY = Mth.m_14008_((double)(0.125 + 0.875 * (item.m_20182_().m_7098_() - (double)worldPosition.m_123342_())), (double)0.125, (double)0.9);
        double relZ = Mth.m_14008_((double)(item.m_20182_().m_7094_() - (double)worldPosition.m_123343_()), (double)0.0, (double)1.0);
        int compressedX = (int)Math.round(7.0 * relX);
        int compressedY = 4 - Mth.m_14163_((int)(14 - (int)(14.0 * relY)));
        int compressedZ = (int)Math.round(7.0 * relZ);
        return compressedX | compressedY << 3 | compressedZ << 5;
    }

    public static void onRecipesReloaded() {
        ++GLOBAL_RECIPE_CACHE_VERSION;
    }

    @Nullable
    public ManaInfusionRecipe getMatchingRecipe(ItemStack stack, BlockState below) {
        int blockId;
        int itemId;
        long key;
        ManaInfusionRecipe cached;
        if (this.f_58857_ == null || stack.m_41619_()) {
            return null;
        }
        if (this.recipeCacheVersionSeen != GLOBAL_RECIPE_CACHE_VERSION) {
            this.recipeCache.clear();
            this.recipeCacheVersionSeen = GLOBAL_RECIPE_CACHE_VERSION;
        }
        if ((cached = (ManaInfusionRecipe)this.recipeCache.get(key = (long)(itemId = BuiltInRegistries.f_257033_.m_7447_((Object)stack.m_41720_())) << 32 | (long)(blockId = BuiltInRegistries.f_256975_.m_7447_((Object)below.m_60734_())) & 0xFFFFFFFFL)) != null) {
            ManaInfusionRecipe r = cached;
            if (r.matches(stack) && (r.getRecipeCatalyst() == null || r.getRecipeCatalyst().test(below))) {
                return cached;
            }
            this.recipeCache.remove(key);
        }
        ManaInfusionRecipe best = null;
        ManaInfusionRecipe firstNonCat = null;
        for (ManaInfusionRecipe rh : BotaniaRecipeTypes.getRecipes((Level)this.f_58857_, (RecipeType)BotaniaRecipeTypes.MANA_INFUSION_TYPE).values()) {
            ManaInfusionRecipe r = rh;
            if (!r.matches(stack)) continue;
            if (r.getRecipeCatalyst() != null) {
                if (!r.getRecipeCatalyst().test(below)) continue;
                best = rh;
                break;
            }
            if (firstNonCat != null) continue;
            firstNonCat = rh;
        }
        if (best == null) {
            best = firstNonCat;
        }
        if (best != null) {
            if (this.recipeCache.size() > 256) {
                this.recipeCache.clear();
            }
            this.recipeCache.put(key, best);
        }
        return best;
    }

    public boolean collideEntityItem(ItemEntity item) {
        if (this.f_58857_.f_46443_ || !item.m_6084_() || item.m_32055_().m_41619_()) {
            return false;
        }
        ItemStack stack = item.m_32055_();
        Item item2 = stack.m_41720_();
        if (item2 instanceof ManaDissolvable) {
            ManaDissolvable dissolvable = (ManaDissolvable)item2;
            dissolvable.onDissolveTick((ManaPool)this, item);
        }
        if (XplatAbstractions.INSTANCE.itemFlagsComponent((ItemEntity)item).manaInfusionSpawned) {
            return false;
        }
        ManaInfusionRecipe recipe = this.getMatchingRecipe(stack, this.f_58857_.m_8055_(this.f_58858_.m_7495_()));
        if (recipe != null) {
            int mana = recipe.getManaToConsume();
            if (this.getCurrentMana() >= mana) {
                this.receiveMana(-mana);
                ItemStack output = recipe.getRecipeOutput(this.f_58857_.m_9598_(), stack);
                EntityHelper.shrinkItem((ItemEntity)item);
                item.m_6853_(false);
                ItemEntity outputItem = new ItemEntity(this.f_58857_, (double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 1.5, (double)this.f_58858_.m_123343_() + 0.5, output);
                XplatAbstractions.INSTANCE.itemFlagsComponent((ItemEntity)outputItem).manaInfusionSpawned = true;
                Entity entity = item.m_19749_();
                if (entity instanceof Player) {
                    Player player = (Player)entity;
                    player.m_280300_((Recipe)recipe, List.of(output));
                    output.m_41678_(this.f_58857_, player, output.m_41613_());
                }
                this.f_58857_.m_7967_((Entity)outputItem);
                this.craftingEffect(true);
                return true;
            }
        }
        return false;
    }

    public void craftingEffect(boolean playSound) {
        if (playSound && this.soundTicks == 0) {
            this.f_58857_.m_5594_(null, this.f_58858_, BotaniaSounds.manaPoolCraft, SoundSource.BLOCKS, 1.0f, 1.0f);
            this.soundTicks = 6;
        }
        this.f_58857_.m_142346_(null, GameEvent.f_223702_, this.m_58899_());
        this.f_58857_.m_7696_(this.m_58899_(), this.m_58900_().m_60734_(), 0, 0);
    }

    public boolean m_7531_(int event, int param) {
        return switch (event) {
            case 0 -> {
                if (this.f_58857_.f_46443_) {
                    for (int i = 0; i < 25; ++i) {
                        float red = (float)Math.random();
                        float green = (float)Math.random();
                        float blue = (float)Math.random();
                        SparkleParticleData data = SparkleParticleData.sparkle((float)((float)Math.random()), (float)red, (float)green, (float)blue, (int)10);
                        this.f_58857_.m_7106_((ParticleOptions)data, (double)this.f_58858_.m_123341_() + 0.5 + Math.random() * 0.4 - 0.2, (double)this.f_58858_.m_123342_() + 0.75, (double)this.f_58858_.m_123343_() + 0.5 + Math.random() * 0.4 - 0.2, 0.0, 0.0, 0.0);
                    }
                }
                yield true;
            }
            case 1 -> {
                if (this.f_58857_.f_46443_ && BotaniaConfig.common().chargingAnimationEnabled()) {
                    ((MutableInt)this.chargingParticles.computeIfAbsent(param, i -> new MutableInt(15))).setValue(15);
                }
                yield true;
            }
            case 2 -> {
                if (this.f_58857_.f_46443_ && BotaniaConfig.common().chargingAnimationEnabled()) {
                    ((MutableInt)this.drainingParticles.computeIfAbsent(param, i -> new MutableInt(15))).setValue(15);
                }
                yield true;
            }
            default -> super.m_7531_(event, param);
        };
    }

    private static void displayChargingParticles(Level level, BlockPos worldPosition, ManaPoolPathwayBlockEntity be, Int2ObjectMap<MutableInt> particles, boolean charging) {
        int bellowCount = charging ? ManaPoolPathwayBlockEntity.getBellowCount(level, worldPosition, be) : 0;
        int max = be.getMaxMana();
        float relativeMana = max > 0 ? (float)be.getCurrentMana() / (float)max : 0.0f;
        ObjectIterator particlesIterator = particles.int2ObjectEntrySet().iterator();
        while (particlesIterator.hasNext()) {
            Int2ObjectMap.Entry entry = (Int2ObjectMap.Entry)particlesIterator.next();
            int ticksRemaining = ((MutableInt)entry.getValue()).decrementAndGet();
            if (ticksRemaining % 2 == 0) {
                int encodedPos = entry.getIntKey();
                Vec3 itemPosRelBase = ManaPoolPathwayBlockEntity.decodeRelativeItemPosition(encodedPos, relativeMana);
                if (charging) {
                    for (int i = 0; i <= bellowCount; ++i) {
                        Vec3 itemPosRel = ManaPoolPathwayBlockEntity.randomizeItemPos(itemPosRelBase);
                        Vec3 poolPosRel = new Vec3(0.1 + 0.8 * Math.random(), 0.1 + 0.4 * (double)relativeMana, 0.1 + 0.8 * Math.random());
                        ManaPoolPathwayBlockEntity.addManaFlowParticle(level, worldPosition, poolPosRel, itemPosRel);
                    }
                } else {
                    Vec3 itemPosRel = ManaPoolPathwayBlockEntity.randomizeItemPos(itemPosRelBase);
                    Vec3 poolPosRel = new Vec3(0.05 + 0.9 * Math.random(), 0.35 * (double)relativeMana, 0.05 + 0.9 * Math.random());
                    ManaPoolPathwayBlockEntity.addManaFlowParticle(level, worldPosition, itemPosRel, poolPosRel);
                }
            }
            if (ticksRemaining > 0) continue;
            particlesIterator.remove();
        }
    }

    private static int getBellowCount(Level level, BlockPos worldPosition, ManaPoolPathwayBlockEntity be) {
        int bellowCount = 0;
        for (Direction dir : Direction.Plane.HORIZONTAL) {
            BellowsBlockEntity bellows;
            BlockEntity tile = level.m_7702_(worldPosition.m_121945_(dir));
            if (!(tile instanceof BellowsBlockEntity) || (bellows = (BellowsBlockEntity)tile).getLinkedTile() != be) continue;
            ++bellowCount;
        }
        return bellowCount;
    }

    private static Vec3 decodeRelativeItemPosition(int param, float relativeMana) {
        int compressedX = param & 7;
        int compressedY = param >> 3 & 3;
        int compressedZ = param >> 5 & 7;
        double relX = (double)compressedX / 7.0;
        double relY = 1.0 - 0.875 / (double)(1 << compressedY);
        double relZ = (double)compressedZ / 7.0;
        return new Vec3(relX, Math.max(relY, 0.5 * (double)relativeMana), relZ);
    }

    private static Vec3 randomizeItemPos(Vec3 itemPosRelBase) {
        return itemPosRelBase.m_82520_(0.1 * Math.random() - 0.05, 0.1 * Math.random() + 0.25, 0.1 * Math.random() - 0.05);
    }

    private static void addManaFlowParticle(Level level, BlockPos worldPosition, Vec3 startPos, Vec3 endPos) {
        double maxHeight = Math.max(startPos.f_82480_, endPos.f_82480_) - endPos.f_82480_ + 0.05 * Math.random();
        Vec3 horizontalDiff = new Vec3(endPos.f_82479_ - startPos.f_82479_, 0.0, endPos.f_82481_ - startPos.f_82481_);
        double horizontalDistance = horizontalDiff.m_165924_();
        if (horizontalDistance < 1.0E-6) {
            horizontalDiff = new Vec3((Math.random() - 0.5) * 0.01, 0.0, (Math.random() - 0.5) * 0.01);
            horizontalDistance = horizontalDiff.m_165924_();
        }
        Vec3 horizontalDir = horizontalDiff.m_82490_(1.0 / horizontalDistance);
        double startHeight = startPos.f_82480_ - endPos.f_82480_;
        double vY0Squared = (double)0.006f * (maxHeight - startHeight);
        double vY0 = Math.sqrt(vY0Squared);
        double lifetime = (vY0 + Math.sqrt(vY0Squared + (double)0.006f * startHeight)) / (double)0.003f;
        double vX0 = horizontalDistance / lifetime;
        Vec3 v0 = horizontalDir.m_82490_(vX0).m_193103_(Direction.Axis.Y, vY0);
        WispParticleData data = WispParticleData.wisp((float)0.1f, (float)0.0f, (float)0.7764706f, (float)1.0f, (float)((float)(0.025 * lifetime)), (float)0.003f).withNoClip(true);
        level.m_7106_((ParticleOptions)data, (double)worldPosition.m_123341_() + startPos.f_82479_, (double)worldPosition.m_123342_() + startPos.f_82480_, (double)worldPosition.m_123343_() + startPos.f_82481_, v0.f_82479_, v0.f_82480_, v0.f_82481_);
    }

    private void initManaCapAndNetwork() {
        if (!ManaNetworkHandler.instance.isPoolIn(this.f_58857_, (ManaPool)this) && !this.m_58901_()) {
            BotaniaAPI.instance().getManaNetworkInstance().fireManaNetworkEvent((ManaReceiver)this, ManaBlockType.POOL, ManaNetworkAction.ADD);
        }
    }

    public boolean refreshHandler() {
        if (this.getNet() != null && this.handler != null && this.getNet().getUnifiedStorage() == this.handler.getStorage()) {
            return true;
        }
        if (this.getNet() != null) {
            this.handler = new ManaUnifiedStorageHandler(this.getNet().getUnifiedStorage(), new CapCtx(this.f_58857_, this.m_58899_(), this));
            return true;
        }
        return false;
    }

    public long getActualCurrentMana() {
        if (this.refreshHandler()) {
            return this.handler.getActualCurrentMana();
        }
        return 0L;
    }

    public long getActualMaxMana() {
        if (this.refreshHandler()) {
            return this.handler.getActualMaxMana();
        }
        return 0L;
    }

    public void onClientDisplayTick() {
    }

    public float getManaYieldMultiplier(ManaBurst burst) {
        return 1.0f;
    }

    public boolean isOutputtingPower() {
        return this.isOutPutting;
    }

    public int getMaxMana() {
        if (this.refreshHandler()) {
            return this.handler.getMaxMana();
        }
        return 0;
    }

    public Optional<DyeColor> getColor() {
        return Optional.empty();
    }

    public void setColor(Optional<DyeColor> color) {
    }

    public Level getManaReceiverLevel() {
        return this.f_58857_;
    }

    public BlockPos getManaReceiverPos() {
        return this.m_58899_();
    }

    public int getCurrentMana() {
        if (this.refreshHandler()) {
            return this.handler.getCurrentMana();
        }
        return 0;
    }

    public boolean isFull() {
        if (this.refreshHandler()) {
            return this.handler.isFull();
        }
        return true;
    }

    public void receiveMana(int mana) {
        if (this.refreshHandler()) {
            this.handler.receiveMana(mana);
        }
    }

    public boolean canReceiveManaFromBursts() {
        return true;
    }

    public boolean canAttachSpark(ItemStack stack) {
        if (this.refreshHandler()) {
            return this.handler.canAttachSpark(stack);
        }
        return false;
    }

    public int getAvailableSpaceForMana() {
        if (this.refreshHandler()) {
            return this.handler.getAvailableSpaceForMana();
        }
        return 0;
    }

    public ManaSpark getAttachedSpark() {
        List sparks = this.f_58857_.m_6443_(Entity.class, new AABB(this.m_58899_().m_7494_()), (Predicate)Predicates.instanceOf(ManaSpark.class));
        if (sparks.size() == 1) {
            Entity e = (Entity)sparks.get(0);
            return (ManaSpark)e;
        }
        return null;
    }

    public boolean areIncomingTranfersDone() {
        if (this.refreshHandler()) {
            return this.handler.areIncomingTranfersDone();
        }
        return false;
    }

    public boolean onUsedByWand(@Nullable Player player, ItemStack stack, Direction side) {
        if ((player == null || player.m_6144_()) && !this.f_58857_.m_5776_()) {
            this.isOutPutting = !this.isOutPutting;
            this.m_6596_();
            VanillaPacketDispatcher.dispatchTEToNearbyPlayers((BlockEntity)this);
        }
        return true;
    }

    @Override
    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128379_("out_putting", this.isOutPutting);
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.isOutPutting = tag.m_128471_("out_putting");
    }

    public void m_7651_() {
        super.m_7651_();
        BotaniaAPI.instance().getManaNetworkInstance().fireManaNetworkEvent((ManaReceiver)this, ManaBlockType.POOL, ManaNetworkAction.REMOVE);
    }

    public static class WandHud
    implements WandHUD {
        private final ManaPoolPathwayBlockEntity pool;

        public WandHud(ManaPoolPathwayBlockEntity pool) {
            this.pool = pool;
        }

        @OnlyIn(value=Dist.CLIENT)
        public void renderHUD(GuiGraphics gui, Minecraft mc) {
            ItemStack poolStack = new ItemStack((ItemLike)this.pool.m_58900_().m_60734_());
            String name = poolStack.m_41786_().getString();
            int centerX = mc.m_91268_().m_85445_() / 2;
            int centerY = mc.m_91268_().m_85446_() / 2;
            int width = Math.max(102, mc.f_91062_.m_92895_(name)) + 4;
            RenderHelper.renderHUDBox((GuiGraphics)gui, (int)(centerX - width / 2), (int)(centerY + 8), (int)(centerX + width / 2), (int)(centerY + 48));
            BotaniaAPIClient.instance().drawSimpleManaHUD(gui, 38399, 1, 1, name);
            RenderSystem.enableBlend();
            RenderSystem.blendFunc((int)770, (int)771);
            int arrowU = this.pool.isOutPutting ? 22 : 0;
            int arrowV = 38;
            RenderHelper.drawTexturedModalRect((GuiGraphics)gui, (ResourceLocation)HUDHandler.manaBar, (int)(centerX - 11), (int)(centerY + 30), (int)arrowU, (int)arrowV, (int)22, (int)15);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            ItemStack tablet = new ItemStack((ItemLike)BotaniaItems.manaTablet);
            ManaTabletItem.setStackCreative((ItemStack)tablet);
            gui.m_280480_(tablet, centerX - 31, centerY + 30);
            gui.m_280480_(poolStack, centerX + 15, centerY + 30);
            RenderSystem.disableBlend();
        }
    }
}

