/*
 * Decompiled with CFR 0.152.
 */
package com.wintercogs.beyonddimensions.BlockEntity.Custom;

import com.wintercogs.beyonddimensions.BlockEntity.Custom.NetedBlockEntity;
import com.wintercogs.beyonddimensions.DataBase.DimensionsNet;
import com.wintercogs.beyonddimensions.DataBase.Storage.EnergyStorage;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;

public class NetEnergyPathwayBlockEntity
extends NetedBlockEntity
implements ITickable {
    public final int transHold = 20;
    public int transTime = 0;
    public boolean popMode = false;
    private final EnumFacing[] directions = EnumFacing.values();
    private EnergyStorage energyStorageCache;

    public void func_73660_a() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.getNetId() == -1) {
            return;
        }
        ++this.transTime;
        if (this.transTime >= 20) {
            this.transTime = 0;
        }
        if (this.popMode) {
            this.popEnergy();
        }
    }

    private void popEnergy() {
        if (this.energyStorageCache == null) {
            DimensionsNet net = this.getNet();
            if (net == null) {
                return;
            }
            this.energyStorageCache = net.getEnergyStorage();
        }
        for (EnumFacing dir : this.directions) {
            IEnergyStorage otherStorage;
            BlockPos targetPos = this.func_174877_v().func_177972_a(dir);
            TileEntity neighbor = this.field_145850_b.func_175625_s(targetPos);
            if (neighbor == null || neighbor instanceof NetedBlockEntity || (otherStorage = (IEnergyStorage)neighbor.getCapability(CapabilityEnergy.ENERGY, dir.func_176734_d())) == null) continue;
            int maxExtract = (int)Math.min((long)this.energyStorageCache.getEnergyStored(), this.energyStorageCache.getMaxTransfer());
            int received = otherStorage.receiveEnergy(maxExtract, false);
            this.energyStorageCache.extractEnergy(received, false);
        }
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        DimensionsNet net = this.getNet();
        if (net != null && capability == CapabilityEnergy.ENERGY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> cap, EnumFacing side) {
        DimensionsNet net;
        if (cap == CapabilityEnergy.ENERGY && (net = this.getNet()) != null) {
            return (T)net.getEnergyStorage();
        }
        return (T)super.getCapability(cap, side);
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        compound.func_74757_a("popMode", this.popMode);
        return compound;
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.popMode = compound.func_74767_n("popMode");
    }

    public void onChunkUnload() {
        this.energyStorageCache = null;
    }

    public double getEnergyProgress() {
        DimensionsNet net = this.getNet();
        if (net != null) {
            return (double)net.getEnergyStorage().getRealEnergyStored() / (double)net.getEnergyStorage().getRealEnergyCapacity();
        }
        return 0.0;
    }

    public long getEnergyStored() {
        DimensionsNet net = this.getNet();
        if (net != null) {
            return net.getEnergyStorage().getRealEnergyStored();
        }
        return 0L;
    }

    public long getEnergyCapacity() {
        DimensionsNet net = this.getNet();
        if (net != null) {
            return net.getEnergyStorage().getRealEnergyCapacity();
        }
        return 0L;
    }
}

