/*
 * Decompiled with CFR 0.152.
 */
package com.wintercogs.beyonddimensions.BlockEntity.Custom;

import com.wintercogs.beyonddimensions.BlockEntity.Custom.NetedBlockEntity;
import com.wintercogs.beyonddimensions.DataBase.DimensionsNet;
import com.wintercogs.beyonddimensions.DataBase.Storage.UnifiedStorage;
import com.wintercogs.beyonddimensions.Unit.CapabilityHelper;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.Capability;

public class NetPathwayBlockEntity
extends NetedBlockEntity {
    public boolean hasCapability(Capability<?> cap, EnumFacing side) {
        DimensionsNet net = this.getNet();
        if (net != null) {
            for (Map.Entry<ResourceLocation, Capability<? extends Object>> entry : CapabilityHelper.BlockCapabilityMap.entrySet()) {
                if (entry.getValue() != cap) continue;
                return true;
            }
        }
        return super.hasCapability(cap, side);
    }

    public <T> T getCapability(Capability<T> cap, EnumFacing side) {
        DimensionsNet net = this.getNet();
        if (net != null) {
            for (Map.Entry<ResourceLocation, Capability<? extends Object>> entry : CapabilityHelper.BlockCapabilityMap.entrySet()) {
                Function<UnifiedStorage, Object> handlerConstructor;
                if (entry.getValue() != cap || (handlerConstructor = UnifiedStorage.typedHandlerMap.get(entry.getKey())) == null) continue;
                Object handler = handlerConstructor.apply(net.getUnifiedStorage());
                return (T)handler;
            }
        }
        return (T)super.getCapability(cap, side);
    }

    private boolean isCapabilitySupported(Capability<?> cap) {
        return CapabilityHelper.BlockCapabilityMap.values().stream().anyMatch(c -> c == cap);
    }
}

