/*
 * Decompiled with CFR 0.152.
 */
package com.wintercogs.beyonddimensions.DataBase;

import com.wintercogs.beyonddimensions.DataBase.NetPermissionlevel;
import com.wintercogs.beyonddimensions.DataBase.PlayerPermissionInfo;
import com.wintercogs.beyonddimensions.DataBase.Stack.ItemStackType;
import com.wintercogs.beyonddimensions.DataBase.Storage.EnergyStorage;
import com.wintercogs.beyonddimensions.DataBase.Storage.UnifiedStorage;
import com.wintercogs.beyonddimensions.Item.ModItems;
import com.wintercogs.beyonddimensions.Unit.PlayerNameHelper;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.storage.WorldSavedData;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

@Mod.EventBusSubscriber(modid="beyonddimensions")
public class DimensionsNet
extends WorldSavedData {
    private int id;
    private UUID owner;
    private final Set<UUID> managers = new HashSet<UUID>();
    private final Set<UUID> players = new HashSet<UUID>();
    private EnergyStorage energyStorage;
    private UnifiedStorage unifiedStorage = new UnifiedStorage(this);
    private boolean temporary;
    private int currentTime = 12000;
    private int holdTime = 12000;

    public DimensionsNet() {
        super("BDNet_temporary");
        this.energyStorage = new EnergyStorage(this);
        MinecraftForge.EVENT_BUS.register((Object)this);
        this.temporary = true;
    }

    public DimensionsNet(String mapName) {
        super(mapName);
        this.energyStorage = new EnergyStorage(this);
        MinecraftForge.EVENT_BUS.register((Object)this);
        this.temporary = false;
    }

    public static String buildNewNetName(EntityPlayer player) {
        int netId;
        WorldServer world = player.func_184102_h().func_71218_a(0);
        for (netId = 0; netId < 10000 && world.getPerWorldStorage().func_75742_a(DimensionsNet.class, "BDNet_" + netId) != null; ++netId) {
        }
        return "BDNet_" + netId;
    }

    public static DimensionsNet getNetFromId(int id, World world) {
        if (id < 0) {
            return null;
        }
        return (DimensionsNet)world.getPerWorldStorage().func_75742_a(DimensionsNet.class, "BDNet_" + id);
    }

    public static DimensionsNet getNetFromPlayer(EntityPlayer player) {
        WorldServer world = player.func_130014_f_().func_73046_m().func_71218_a(0);
        for (int netId = 0; netId < 3000; ++netId) {
            DimensionsNet net = (DimensionsNet)world.getPerWorldStorage().func_75742_a(DimensionsNet.class, "BDNet_" + netId);
            if (net == null || !net.players.contains(player.func_110124_au())) continue;
            return net;
        }
        return null;
    }

    public void func_76184_a(NBTTagCompound nbt) {
        this.id = nbt.func_74762_e("Id");
        if (nbt.func_74764_b("Owner")) {
            this.owner = UUID.fromString(nbt.func_74779_i("Owner"));
        }
        this.energyStorage.deserializeNBT(nbt.func_74775_l("EnergyStorage"));
        this.unifiedStorage.deserializeNBT(nbt.func_74775_l("UnifiedStorage"));
        this.managers.clear();
        NBTTagList managerList = nbt.func_150295_c("Managers", 8);
        for (int i = 0; i < managerList.func_74745_c(); ++i) {
            this.managers.add(UUID.fromString(managerList.func_150307_f(i)));
        }
        this.players.clear();
        NBTTagList playerList = nbt.func_150295_c("Players", 8);
        for (int i = 0; i < playerList.func_74745_c(); ++i) {
            this.players.add(UUID.fromString(playerList.func_150307_f(i)));
        }
        this.currentTime = nbt.func_74762_e("currentTime");
        this.temporary = false;
    }

    public NBTTagCompound func_189551_b(NBTTagCompound compound) {
        compound.func_74768_a("Id", this.id);
        if (this.owner != null) {
            compound.func_74778_a("Owner", this.owner.toString());
        }
        compound.func_74782_a("EnergyStorage", (NBTBase)this.energyStorage.serializeNBT());
        compound.func_74782_a("UnifiedStorage", (NBTBase)this.unifiedStorage.serializeNBT());
        NBTTagList managerList = new NBTTagList();
        for (UUID manager : this.managers) {
            managerList.func_74742_a((NBTBase)new NBTTagString(manager.toString()));
        }
        compound.func_74782_a("Managers", (NBTBase)managerList);
        NBTTagList playerList = new NBTTagList();
        for (UUID player : this.players) {
            playerList.func_74742_a((NBTBase)new NBTTagString(player.toString()));
        }
        compound.func_74782_a("Players", (NBTBase)playerList);
        compound.func_74768_a("currentTime", this.currentTime);
        return compound;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int Id) {
        this.id = Id;
        this.func_76186_a(true);
    }

    public UUID getOwner() {
        return this.owner;
    }

    public void setOwner(UUID owner) {
        this.owner = owner;
        this.addManager(owner);
        this.func_76186_a(true);
    }

    public Set<UUID> getManagers() {
        return this.managers;
    }

    public void addManager(UUID managerId) {
        this.managers.add(managerId);
        this.addPlayer(managerId);
        this.func_76186_a(true);
    }

    public void removeManager(UUID managerId) {
        if (managerId.equals(this.owner)) {
            return;
        }
        this.managers.remove(managerId);
        this.func_76186_a(true);
    }

    public Set<UUID> getPlayers() {
        return this.players;
    }

    public void addPlayer(UUID playerId) {
        this.players.add(playerId);
        this.func_76186_a(true);
    }

    public void removePlayer(UUID playerId) {
        if (playerId == this.owner) {
            return;
        }
        this.players.remove(playerId);
        if (this.managers.contains(playerId)) {
            this.managers.remove(playerId);
        }
        this.func_76186_a(true);
    }

    public boolean isOwner(EntityPlayer player) {
        return player.func_110124_au().equals(this.getOwner());
    }

    public boolean isOwner(UUID playerId) {
        return playerId.equals(this.getOwner());
    }

    public boolean isManager(EntityPlayer player) {
        boolean flag = false;
        if (this.managers.contains(player.func_110124_au())) {
            flag = true;
        }
        return flag;
    }

    public boolean isManager(UUID playerId) {
        boolean flag = false;
        if (this.managers.contains(playerId)) {
            flag = true;
        }
        return flag;
    }

    public HashMap<UUID, PlayerPermissionInfo> getPlayerPermissionInfoMap(World playerInfoProvider) {
        HashMap<UUID, PlayerPermissionInfo> infoMap = new HashMap<UUID, PlayerPermissionInfo>();
        for (UUID playerId : this.players) {
            if (this.isOwner(playerId)) {
                infoMap.put(playerId, new PlayerPermissionInfo(PlayerNameHelper.getPlayerNameByUUID(playerId, playerInfoProvider), NetPermissionlevel.Owner, playerId));
                continue;
            }
            if (this.isManager(playerId)) {
                infoMap.put(playerId, new PlayerPermissionInfo(PlayerNameHelper.getPlayerNameByUUID(playerId, playerInfoProvider), NetPermissionlevel.Manager, playerId));
                continue;
            }
            infoMap.put(playerId, new PlayerPermissionInfo(PlayerNameHelper.getPlayerNameByUUID(playerId, playerInfoProvider), NetPermissionlevel.Member, playerId));
        }
        return infoMap;
    }

    public EnergyStorage getEnergyStorage() {
        return this.energyStorage;
    }

    public UnifiedStorage getUnifiedStorage() {
        return this.unifiedStorage;
    }

    @SubscribeEvent
    public void onServerTick(TickEvent.ServerTickEvent event) {
        if (this.temporary) {
            return;
        }
        --this.currentTime;
        this.func_76185_a();
        if (this.currentTime <= 0) {
            ItemStack stack = new ItemStack(ModItems.SHATTERED_SPACE_TIME_CRYSTALLIZATION, 1);
            ItemStackType stackType = new ItemStackType(stack);
            this.unifiedStorage.insert(stackType, false);
            this.currentTime = this.holdTime;
        }
    }
}

