/*
 * Decompiled with CFR 0.152.
 */
package com.wintercogs.beyonddimensions.DataBase.StackHandlerWrapper;

import com.wintercogs.beyonddimensions.DataBase.Stack.ItemStackType;
import com.wintercogs.beyonddimensions.DataBase.StackHandlerWrapper.IStackHandlerWrapper;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.items.IItemHandler;

public class ItemHandlerWrapper
implements IStackHandlerWrapper<ItemStack> {
    private final IItemHandler itemHandler;

    public ItemHandlerWrapper(Object itemHandler) {
        this.itemHandler = (IItemHandler)itemHandler;
    }

    @Override
    public ResourceLocation getTypeId() {
        return ItemStackType.ID;
    }

    @Override
    public int getSlots() {
        return this.itemHandler.getSlots();
    }

    @Override
    public ItemStack getStackInSlot(int slot) {
        return this.itemHandler.getStackInSlot(slot);
    }

    @Override
    public long getCapacity(int slot) {
        return this.itemHandler.getSlotLimit(slot);
    }

    @Override
    public boolean isStackValid(EnumFacing facing, int slot, ItemStack stack) {
        return this.itemHandler.isItemValid(slot, stack);
    }

    @Override
    public long insert(EnumFacing facing, int slot, ItemStack Stack, boolean sim) {
        return this.itemHandler.insertItem(slot, Stack, sim).func_190916_E();
    }

    @Override
    public long insert(EnumFacing facing, ItemStack stack, boolean sim) {
        for (int i = 0; i < this.getSlots(); ++i) {
            if (!(stack = this.itemHandler.insertItem(i, stack, sim)).func_190926_b()) continue;
            return 0L;
        }
        return stack.func_190916_E();
    }

    @Override
    public long extract(EnumFacing facing, int slot, long amount, boolean sim) {
        return this.itemHandler.extractItem(slot, (int)Math.min(amount, Integer.MAX_VALUE), sim).func_190916_E();
    }

    @Override
    public long extract(EnumFacing facing, ItemStack stack, boolean sim) {
        int currentNum = 0;
        for (int i = 0; i < this.getSlots(); ++i) {
            if (!ItemStack.func_179545_c((ItemStack)this.itemHandler.getStackInSlot(i), (ItemStack)stack) || !ItemStack.func_77970_a((ItemStack)this.itemHandler.getStackInSlot(i), (ItemStack)stack)) continue;
            int extracting = this.itemHandler.extractItem(i, stack.func_190916_E(), sim).func_190916_E();
            stack.func_190918_g(extracting);
            currentNum += extracting;
            if (stack.func_190926_b()) break;
        }
        return currentNum;
    }
}

