/*
 * Decompiled with CFR 0.152.
 */
package com.wintercogs.beyonddimensions.Gui.Sync;

import com.cleanroommc.modularui.network.NetworkUtils;
import com.cleanroommc.modularui.value.sync.ValueSyncHandler;
import com.wintercogs.beyonddimensions.DataBase.Handler.IStackTypedHandler;
import com.wintercogs.beyonddimensions.DataBase.Stack.IStackType;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.PacketBuffer;

public class OrderedStackTypedHandlerSync
extends ValueSyncHandler<IStackTypedHandler> {
    private IStackTypedHandler stacks;
    private List<IStackType> lastStacks;

    public OrderedStackTypedHandlerSync(IStackTypedHandler stacks) {
        this.stacks = stacks;
        this.lastStacks = new ArrayList<IStackType>();
    }

    public void setValue(IStackTypedHandler StackTypeList, boolean setSource, boolean sync) {
        this.stacks = StackTypeList;
        if (setSource) {
            // empty if block
        }
        if (sync && !NetworkUtils.isClient()) {
            this.syncToClient(0, this::write);
        }
        this.onValueChanged();
    }

    public IStackTypedHandler getValue() {
        return this.stacks;
    }

    public boolean updateCacheFromSource(boolean init) {
        if (!NetworkUtils.isClient()) {
            this.syncToClient(0, this::write);
        }
        return true;
    }

    public void write(PacketBuffer packetBuffer) throws IOException {
        ArrayList changedItems = new ArrayList();
        ArrayList<Long> changedCounts = new ArrayList<Long>();
        ArrayList<Integer> changedIndices = new ArrayList<Integer>();
        ArrayList lastSnapshot = new ArrayList();
        for (IStackType iStackType : this.lastStacks) {
            lastSnapshot.add(iStackType != null ? iStackType.copy() : null);
        }
        ArrayList currentSnapshot = new ArrayList();
        for (IStackType stack : this.stacks.getStorage()) {
            currentSnapshot.add(stack != null ? stack.copy() : null);
        }
        this.refreshLast();
        int n = Math.max(lastSnapshot.size(), currentSnapshot.size());
        while (lastSnapshot.size() < n) {
            lastSnapshot.add(null);
        }
        while (currentSnapshot.size() < n) {
            currentSnapshot.add(null);
        }
        for (int slot = 0; slot < n; ++slot) {
            IStackType lastStack = (IStackType)lastSnapshot.get(slot);
            IStackType currentStack = (IStackType)currentSnapshot.get(slot);
            boolean stackChanged = false;
            if (lastStack == null != (currentStack == null)) {
                stackChanged = true;
            } else if (lastStack != null && currentStack != null && !lastStack.isSameTypeSameComponents(currentStack)) {
                stackChanged = true;
            }
            long delta = (currentStack != null ? currentStack.getStackAmount() : 0L) - (lastStack != null ? lastStack.getStackAmount() : 0L);
            if (delta != 0L) {
                stackChanged = true;
            }
            if (!stackChanged) continue;
            changedIndices.add(slot);
            changedItems.add(currentStack != null ? currentStack.copy() : null);
            changedCounts.add(delta);
        }
        int changes = changedItems.size();
        packetBuffer.func_150787_b(changes);
        for (int i = 0; i < changes; ++i) {
            ((IStackType)changedItems.get(i)).serialize(packetBuffer);
            packetBuffer.writeLong(((Long)changedCounts.get(i)).longValue());
            packetBuffer.writeInt(((Integer)changedIndices.get(i)).intValue());
        }
    }

    public void read(PacketBuffer packetBuffer) throws IOException {
        if (!NetworkUtils.isClient()) {
            return;
        }
        int changes = packetBuffer.func_150792_a();
        ArrayList<IStackType> changedItems = new ArrayList<IStackType>();
        ArrayList<Long> changedCounts = new ArrayList<Long>();
        ArrayList<Integer> changedIndices = new ArrayList<Integer>();
        for (int slot = 0; slot < changes; ++slot) {
            changedItems.add(IStackType.deserializeCommon(packetBuffer));
            changedCounts.add(packetBuffer.readLong());
            changedIndices.add(packetBuffer.readInt());
        }
        IStackTypedHandler clientStorage = this.stacks;
        int i = 0;
        for (IStackType remoteStack : changedItems) {
            if ((Long)changedCounts.get(i) > 0L) {
                clientStorage.insert((Integer)changedIndices.get(i), remoteStack.copyWithCount((Long)changedCounts.get(i)), false);
            } else {
                clientStorage.extract((Integer)changedIndices.get(i), -((Long)changedCounts.get(i)).longValue(), false);
            }
            ++i;
        }
        this.onValueChanged();
    }

    public void refreshLast() {
        this.lastStacks.clear();
        for (IStackType stack : this.stacks.getStorage()) {
            this.lastStacks.add(stack.copy());
        }
    }
}

