/*
 * Decompiled with CFR 0.152.
 */
package com.wintercogs.beyonddimensions.Render;

import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class IngredientRenderer {
    private static final int TEXTURE_SIZE = 16;
    private static final int MIN_FLUID_HEIGHT = 1;

    public static void drawTiledSprite(int tiledWidth, int tiledHeight, int color, long scaledAmount, TextureAtlasSprite sprite, int posX, int posY) {
        GlStateManager.func_179147_l();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(TextureMap.field_110575_b);
        IngredientRenderer.setGLColorFromInt(color);
        int xTileCount = tiledWidth / 16;
        int xRemainder = tiledWidth - xTileCount * 16;
        long yTileCount = scaledAmount / 16L;
        long yRemainder = scaledAmount - yTileCount * 16L;
        int yStart = tiledHeight + posY;
        for (int xTile = 0; xTile <= xTileCount; ++xTile) {
            int yTile = 0;
            while ((long)yTile <= yTileCount) {
                int width = xTile == xTileCount ? xRemainder : 16;
                long height = (long)yTile == yTileCount ? yRemainder : 16L;
                int x = posX + xTile * 16;
                int y = yStart - (yTile + 1) * 16;
                if (width > 0 && height > 0L) {
                    long maskTop = 16L - height;
                    int maskRight = 16 - width;
                    IngredientRenderer.drawTextureWithMasking(x, y, sprite, maskTop, maskRight);
                }
                ++yTile;
            }
        }
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179084_k();
    }

    private static void setGLColorFromInt(int color) {
        float red = (float)(color >> 16 & 0xFF) / 256.0f;
        float green = (float)(color >> 8 & 0xFF) / 256.0f;
        float blue = (float)(color & 0xFF) / 256.0f;
        GlStateManager.func_179131_c((float)red, (float)green, (float)blue, (float)1.0f);
    }

    private static void drawTextureWithMasking(float xCoord, float yCoord, TextureAtlasSprite textureSprite, long maskTop, long maskRight) {
        float uMin = textureSprite.func_94209_e();
        float uMax = textureSprite.func_94212_f();
        float vMin = textureSprite.func_94206_g();
        float vMax = textureSprite.func_94210_h();
        uMax -= (float)maskRight / 16.0f * (uMax - uMin);
        vMax -= (float)maskTop / 16.0f * (vMax - vMin);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        buffer.func_181662_b((double)xCoord, (double)(yCoord + 16.0f), 100.0).func_187315_a((double)uMin, (double)vMax).func_181675_d();
        buffer.func_181662_b((double)(xCoord + 16.0f - (float)maskRight), (double)(yCoord + 16.0f), 100.0).func_187315_a((double)uMax, (double)vMax).func_181675_d();
        buffer.func_181662_b((double)(xCoord + 16.0f - (float)maskRight), (double)(yCoord + (float)maskTop), 100.0).func_187315_a((double)uMax, (double)vMin).func_181675_d();
        buffer.func_181662_b((double)xCoord, (double)(yCoord + (float)maskTop), 100.0).func_187315_a((double)uMin, (double)vMin).func_181675_d();
        tessellator.func_78381_a();
    }
}

